/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.remote.cascading.BasicMBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.CascadingAgent;
import com.sun.jdmk.remote.cascading.CascadingServiceMBean;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.proxy.ProxyCascadingAgent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class CascadingService
implements CascadingServiceMBean,
NotificationEmitter,
MBeanRegistration {
    private static final String[] jmxConnectionNotificationTypes = new String[]{"com.sun.jdmk.remote.cascading.failed", "com.sun.jdmk.remote.cascading.stopped"};
    private static final MBeanNotificationInfo jmxConnectionNotificationInfo = new MBeanNotificationInfo(jmxConnectionNotificationTypes, (class$javax$management$remote$JMXConnectionNotification == null ? (class$javax$management$remote$JMXConnectionNotification = CascadingService.class$("javax.management.remote.JMXConnectionNotification")) : class$javax$management$remote$JMXConnectionNotification).getName(), "Notifications relating to the underlying CascadingAgent.");
    private final NotificationBroadcasterSupport emitter;
    private final MBeanServer targetMBS;
    private final NotificationListener listener;
    private final HashMap mountMap;
    private MBeanServer myMBS = null;
    private long sequenceNumber = 0L;
    static /* synthetic */ Class class$javax$management$remote$JMXConnectionNotification;

    static String makeID(JMXServiceURL jMXServiceURL, ObjectName objectName, String string) {
        String string2 = jMXServiceURL == null ? "???" : String.valueOf(jMXServiceURL);
        String string3 = objectName == null ? "*:*" : String.valueOf(objectName);
        return "mount: " + string2 + " " + objectName + " " + string;
    }

    public CascadingService() {
        this(null);
    }

    public CascadingService(MBeanServer mBeanServer) {
        this.targetMBS = mBeanServer;
        this.listener = new NotificationListener(){

            public void handleNotification(Notification notification, Object object) {
                CascadingService.this.handleJMXCN(notification, object);
            }
        };
        this.emitter = new NotificationBroadcasterSupport();
        this.mountMap = new HashMap();
    }

    public final synchronized String mount(JMXServiceURL jMXServiceURL, Map map, ObjectName objectName, String string) throws IOException, InstanceAlreadyExistsException {
        MountPoint mountPoint = new MountPoint(jMXServiceURL, objectName, string);
        if (this.isMounted(mountPoint.mountPointID)) {
            throw new IOException(mountPoint.mountPointID + ": already mounted.");
        }
        JMXConnector jMXConnector = this.connectSource(jMXServiceURL, map, mountPoint.mountPointID);
        try {
            this.mountMap.put(mountPoint.mountPointID, mountPoint);
            mountPoint.mount(jMXConnector, this.getTargetMBeanServer());
            return mountPoint.mountPointID;
        }
        catch (Exception exception) {
            try {
                this.mountMap.remove(mountPoint.mountPointID);
                mountPoint.unmount();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            IOException iOException = new IOException(mountPoint.mountPointID + ": " + exception);
            Utils.initCause(iOException, exception);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean unmount(String string) throws IOException {
        Exception exception;
        MountPoint mountPoint;
        block12: {
            String string2;
            boolean bl;
            block11: {
                mountPoint = null;
                exception = null;
                try {
                    block10: {
                        try {
                            CascadingService cascadingService = this;
                            synchronized (cascadingService) {
                                mountPoint = (MountPoint)this.mountMap.remove(string);
                                if (mountPoint == null) {
                                    bl = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 9] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                                    Object var8_8 = null;
                                    if (mountPoint == null) return bl;
                                    if (exception != null) break block10;
                                    string2 = ": succesfully unmounted";
                                    break block11;
                                }
                                mountPoint.unmount();
                                break block12;
                            }
                        }
                        catch (IOException iOException) {
                            exception = iOException;
                            throw iOException;
                        }
                        catch (RuntimeException runtimeException) {
                            exception = runtimeException;
                            throw runtimeException;
                        }
                    }
                    string2 = ": unmounted with errors: " + exception;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (mountPoint == null) throw throwable;
                    String string3 = exception == null ? ": succesfully unmounted" : ": unmounted with errors: " + exception;
                    JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("com.sun.jdmk.remote.cascading.stopped", this, mountPoint.mountPointID, this.newSequenceNumber(), mountPoint.mountPointID + string3, null);
                    this.sendNotification(jMXConnectionNotification);
                    throw throwable;
                }
            }
            String string4 = string2;
            JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("com.sun.jdmk.remote.cascading.stopped", this, mountPoint.mountPointID, this.newSequenceNumber(), mountPoint.mountPointID + string4, null);
            this.sendNotification(jMXConnectionNotification);
            return bl;
        }
        Object var8_9 = null;
        if (mountPoint == null) return true;
        String string5 = exception == null ? ": succesfully unmounted" : ": unmounted with errors: " + exception;
        JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("com.sun.jdmk.remote.cascading.stopped", this, mountPoint.mountPointID, this.newSequenceNumber(), mountPoint.mountPointID + string5, null);
        this.sendNotification(jMXConnectionNotification);
        return true;
    }

    public synchronized boolean isMounted(String string) {
        return this.mountMap.containsKey(string);
    }

    public synchronized String[] getMountPointIDs() {
        return this.mountMap.keySet().toArray(new String[this.mountMap.size()]);
    }

    public final void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.emitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public final void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener);
    }

    public final void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{jmxConnectionNotificationInfo};
        return mBeanNotificationInfoArray;
    }

    public final MBeanServer getTargetMBeanServer() {
        return this.targetMBS != null ? this.targetMBS : this.myMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        CascadingService cascadingService = this;
        synchronized (cascadingService) {
            if (this.targetMBS == null && this.myMBS != null && this.myMBS != mBeanServer) {
                throw new IllegalArgumentException("Already registered");
            }
            this.myMBS = mBeanServer;
        }
        if (objectName != null) {
            return objectName;
        }
        return CascadingServiceMBean.CASCADING_SERVICE_DEFAULT_NAME;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.myMBS = null;
    }

    CascadingAgent createCascadingAgent(JMXConnector jMXConnector, ObjectName objectName, String string, MBeanServer mBeanServer, String string2) throws IOException {
        MBeanServerConnectionFactory mBeanServerConnectionFactory = BasicMBeanServerConnectionFactory.newInstance(jMXConnector);
        return new ProxyCascadingAgent(mBeanServerConnectionFactory, objectName, null, string, mBeanServer, string2);
    }

    JMXConnector connectSource(JMXServiceURL jMXServiceURL, Map map, String string) throws IOException {
        return JMXConnectorFactory.connect(jMXServiceURL, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(CascadingAgent cascadingAgent, JMXConnector jMXConnector, String string) throws IOException {
        try {
            if (cascadingAgent != null) {
                cascadingAgent.stop();
            }
        }
        finally {
            if (jMXConnector != null) {
                jMXConnector.close();
            }
        }
    }

    void sendNotification(Notification notification) {
        this.emitter.sendNotification(notification);
    }

    final synchronized long newSequenceNumber() {
        return this.sequenceNumber++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJMXCN(Notification notification, Object object) {
        MountPoint mountPoint = (MountPoint)object;
        if (mountPoint == null) {
            return;
        }
        boolean bl = false;
        CascadingService cascadingService = this;
        synchronized (cascadingService) {
            if ("jmx.remote.connection.closed".equals(notification.getType()) && mountPoint.isClosed() || "jmx.remote.connection.failed".equals(notification.getType())) {
                try {
                    if (this.mountMap.remove(mountPoint.mountPointID) != null) {
                        mountPoint.unmount();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = true;
            }
        }
        if (bl) {
            String string = "jmx.remote.connection.failed".equals(notification.getType()) ? "failed" : "closed";
            JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("com.sun.jdmk.remote.cascading.failed", this, mountPoint.mountPointID, this.newSequenceNumber(), mountPoint.mountPointID + ": connection " + string, notification);
            this.sendNotification(jMXConnectionNotification);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MountPoint {
        public final JMXServiceURL sourceURL;
        public final ObjectName sourcePattern;
        public final String targetPath;
        public final String mountPointID;
        private JMXConnector sourceConnector = null;
        private MBeanServerConnectionFactory sourceConnectionFactory = null;
        private CascadingAgent agent = null;

        public MountPoint(JMXServiceURL jMXServiceURL, ObjectName objectName, String string) throws IOException {
            this.mountPointID = CascadingService.makeID(jMXServiceURL, objectName, string);
            this.sourceURL = jMXServiceURL;
            this.sourcePattern = objectName;
            this.targetPath = string;
        }

        public void mount(JMXConnector jMXConnector, MBeanServer mBeanServer) throws IOException, InstanceAlreadyExistsException {
            this.sourceConnector = jMXConnector;
            this.agent = CascadingService.this.createCascadingAgent(jMXConnector, this.sourcePattern, this.targetPath, mBeanServer, this.mountPointID);
            this.sourceConnectionFactory = this.agent.getConnectionFactory();
            this.agent.start(false);
            this.sourceConnectionFactory.addConnectionNotificationListener(CascadingService.this.listener, null, this);
            this.checkConnection();
        }

        public void unmount() throws IOException {
            Exception exception = null;
            try {
                this.sourceConnectionFactory.removeConnectionNotificationListener(CascadingService.this.listener, null, this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            try {
                CascadingService.this.terminate(this.agent, this.sourceConnector, this.mountPointID);
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception != null) {
                IOException iOException = new IOException(this.mountPointID + ": " + exception);
                Utils.initCause(iOException, exception);
                throw iOException;
            }
        }

        public boolean isClosed() {
            if (this.agent != null) {
                try {
                    this.agent.getConnectionFactory().getMBeanServerConnection().getDefaultDomain();
                    return false;
                }
                catch (Exception exception) {
                    return true;
                }
            }
            return true;
        }

        public void checkConnection() throws IOException {
            if (this.sourceConnector == null) {
                throw new IOException("not connected");
            }
            if (this.sourceConnectionFactory == null) {
                throw new IOException("not connected");
            }
            MBeanServerConnection mBeanServerConnection = this.sourceConnectionFactory.getMBeanServerConnection();
            if (mBeanServerConnection == null) {
                throw new IOException("not connected");
            }
            mBeanServerConnection.getDefaultDomain();
        }
    }
}

