/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryMsg;
import com.sun.jdmk.internal.ClassLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

abstract class DiscoveryCommon
extends MulticastSocket
implements Runnable {
    protected String localClassName = "com.sun.jdmk.discovery.DiscoveryCommon";
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "DiscoveryCommon");
    protected int multicastPort;
    protected InetAddress multicastGroup;
    protected InetAddress localHost;
    protected String localHostName;
    protected InetAddress selectedHost;
    protected String selectedHostName;

    public DiscoveryCommon(String string, int n) throws IOException {
        super(n);
        if (this.logger.finerOn()) {
            this.logger.finer("constructor ", "group = " + string + ", " + "port  = " + n);
        }
        this.multicastGroup = InetAddress.getByName(string);
        this.multicastPort = n;
        this.localHostName = System.getProperty("jdmk.hostname");
        if (this.localHostName != null) {
            this.selectedHost = this.localHost = InetAddress.getByName(this.localHostName);
            this.selectedHostName = this.localHostName;
        } else {
            this.localHost = InetAddress.getLocalHost();
            this.localHostName = InetAddress.getLocalHost().getHostName();
            this.selectedHost = this.localHost;
            this.selectedHostName = this.localHostName;
        }
    }

    public void connectToGroup() throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("connectToGroup", "join Group " + this.multicastGroup);
        }
        this.joinGroup(this.multicastGroup);
    }

    void disconnectFromGroup() throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("disconnectFromGroup", "leave Group " + this.multicastGroup);
        }
        this.leaveGroup(this.multicastGroup);
    }

    public void run() {
    }

    public String getLocalHostName() {
        return this.localHostName;
    }

    public InetAddress getLocalHostAddr() {
        return this.localHost;
    }

    public String getHostName() {
        return this.selectedHostName;
    }

    public InetAddress getHostAddr() {
        return this.selectedHost;
    }

    protected synchronized void sendMsg(DiscoveryMsg discoveryMsg, InetAddress inetAddress, int n) throws IOException {
        byte[] byArray = null;
        try {
            byArray = this.objectSerialization(discoveryMsg);
        }
        catch (IOException iOException) {
            if (this.logger.finestOn()) {
                this.logger.finest("sendMsg ", iOException);
            }
            throw iOException;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("sendMsg", "destination address = " + inetAddress + " Port = " + n);
            this.logger.finer("sendMsg", "Send msg '" + discoveryMsg.printState() + "'");
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        this.setTimeToLive(discoveryMsg.getTimeToLive());
        this.send(datagramPacket);
    }

    protected synchronized DiscoveryMsg receiveMsg(DatagramSocket datagramSocket) throws IOException, ClassNotFoundException, InvalidClassException, InterruptedIOException {
        byte[] byArray;
        DiscoveryMsg discoveryMsg;
        InetAddress inetAddress;
        byte[] byArray2 = new byte[65536];
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length);
        if (this.logger.finerOn()) {
            this.logger.finer("receiveMsg ", "Start waiting");
        }
        datagramSocket.receive(datagramPacket);
        if (this.logger.finerOn()) {
            this.logger.finer("receiveMsg ", "We Receive something");
        }
        if (!(inetAddress = (discoveryMsg = (DiscoveryMsg)this.objectDeserialization(byArray = datagramPacket.getData())).getEmittedGroup()).equals(this.multicastGroup)) {
            if (this.logger.finerOn()) {
                this.logger.finer("receiveMsg ", "Receive a msg for another group");
            }
            throw new IOException();
        }
        if (this.logger.finerOn()) {
            this.logger.finer("receiveMsg ", "Receive a msg");
        }
        return discoveryMsg;
    }

    private Object objectDeserialization(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.logger.finestOn()) {
                this.logger.finest("objectDeserialization", classNotFoundException);
            }
            throw classNotFoundException;
        }
        catch (OptionalDataException optionalDataException) {
            if (this.logger.finestOn()) {
                this.logger.finest("objectDeserialization", optionalDataException);
            }
            throw new IOException(optionalDataException.getMessage());
        }
    }

    private byte[] objectSerialization(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }
}

