/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpsConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryPDU;
import com.sun.jdmk.discovery.DiscoveryResponder;
import com.sun.jdmk.discovery.ResponsePDU;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.internal.Useful;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.remote.JMXServiceURL;

class ActualResponder
extends DiscoveryCommon {
    private DiscoveryResponder discResponder;
    public volatile boolean stopRequested;
    public Boolean interrupted;
    private final ClassLogger logger;
    private MBeanServer cmf;
    private String mbeanServerName;
    private String ImplementationName;
    private String ImplementationVendor;
    private String ImplementationVersion;
    private String SpecificationName;
    private String SpecificationVendor;
    private String SpecificationVersion;
    private int ttl;
    private boolean sendEvent;
    private boolean spy;

    public ActualResponder(String string, int n, int n2, MBeanServer mBeanServer, String string2, DiscoveryResponder discoveryResponder) throws IOException {
        block6: {
            super(string, n);
            this.discResponder = null;
            this.stopRequested = false;
            this.interrupted = new Boolean(false);
            this.logger = new ClassLogger("com.sun.jdmk.discovery", "ActualResponder");
            this.cmf = null;
            this.mbeanServerName = null;
            this.ImplementationName = null;
            this.ImplementationVendor = null;
            this.ImplementationVersion = null;
            this.SpecificationName = null;
            this.SpecificationVendor = null;
            this.SpecificationVersion = null;
            this.ttl = 1;
            this.sendEvent = true;
            this.spy = false;
            this.discResponder = discoveryResponder;
            if (this.logger.finerOn()) {
                this.logger.finer("constructor ", "group = " + string + ", " + "port  = " + n);
            }
            this.localClassName = "com.sun.jdmk.discovery.ActualResponder";
            this.ttl = n2;
            if (string2 != null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("constructor ", "constructor spy = '" + string2 + "'");
                }
                if (string2.compareTo("act_as_a_spy") == 0) {
                    this.spy = true;
                }
            }
            this.cmf = mBeanServer;
            try {
                ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                this.mbeanServerName = (String)mBeanServer.getAttribute(objectName, "MBeanServerId");
                this.SpecificationName = (String)mBeanServer.getAttribute(objectName, "SpecificationName");
                this.SpecificationVendor = (String)mBeanServer.getAttribute(objectName, "SpecificationVendor");
                this.SpecificationVersion = (String)mBeanServer.getAttribute(objectName, "SpecificationVersion");
                this.ImplementationName = (String)mBeanServer.getAttribute(objectName, "ImplementationName");
                this.ImplementationVendor = (String)mBeanServer.getAttribute(objectName, "ImplementationVendor");
                this.ImplementationVersion = (String)mBeanServer.getAttribute(objectName, "ImplementationVersion");
            }
            catch (Exception exception) {
                if (!this.logger.finestOn()) break block6;
                this.logger.finest("constructor ", exception);
            }
        }
    }

    public void noEvent() {
        this.sendEvent = false;
    }

    public void setLocalHost(String string) {
        if (string != null) {
            try {
                this.localHost = InetAddress.getByName(string);
                this.localHostName = string;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block49: {
            block50: {
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                if (!this.spy && this.sendEvent) {
                                    this.sendEvent(0);
                                }
                                try {
                                    while (!this.stopRequested) {
                                        try {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", " -------------------- Start Waiting -------------------- ");
                                            }
                                            if (this.spy) {
                                                var2_2 = this.receiveMsg(this);
                                                if (!this.logger.finerOn()) continue;
                                                this.logger.finer("run ", "(SPY) receive : " + var2_2.printState());
                                                continue;
                                            }
                                            var1_1 = (DiscoveryPDU)this.receiveMsg(this);
                                            this.processMsg(var1_1);
                                        }
                                        catch (InterruptedIOException var2_3) {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", "Stop execution ");
                                            }
                                            this.stopRequested = true;
                                        }
                                        catch (IOException var2_4) {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", "Not a discovering msg - continue - ");
                                            }
                                            if (!this.spy || !this.logger.finestOn()) continue;
                                            this.logger.finest("run ", var2_4);
                                        }
                                        catch (ClassCastException var2_5) {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", "Not a discovering msg - continue - ");
                                            }
                                            if (!this.spy || !this.logger.finestOn()) continue;
                                            this.logger.finest("run ", var2_5);
                                        }
                                        catch (ClassNotFoundException var2_6) {
                                            if (this.logger.finerOn()) {
                                                this.logger.finer("run ", "Not a discovering msg - continue - ");
                                            }
                                            if (!this.spy || !this.logger.finestOn()) continue;
                                            this.logger.finest("run ", var2_6);
                                        }
                                    }
                                    var4_7 = null;
                                    var5_9 /* !! */  = this.interrupted;
                                }
                                catch (Throwable var3_11) {
                                    block48: {
                                        var4_8 = null;
                                        var5_10 /* !! */  = this.interrupted;
                                        synchronized (var5_10 /* !! */ ) {
                                            this.interrupted = new Boolean(true);
                                            Thread.currentThread();
                                            Thread.interrupted();
                                            ** if (!this.sendEvent) goto lbl83
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            this.sendEvent(1);
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception var5_10 /* !! */ ) {
                                                // empty catch block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception var5_10 /* !! */ ) {
                                                // empty catch block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception var5_10 /* !! */ ) {
                                                // empty catch block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception var5_10 /* !! */ ) {
                                                // empty catch block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Exception var5_10 /* !! */ ) {
                                                // empty catch block
                                            }
                                        }
                                        if (this.logger.finerOn()) {
                                            this.logger.finer("run ", "Call leave group");
                                        }
                                        try {
                                            this.disconnectFromGroup();
                                        }
                                        catch (IOException var5_10 /* !! */ ) {
                                            if (this.logger.finestOn()) {
                                                this.logger.finest("start ", (Throwable)var5_10 /* !! */ );
                                            }
                                        }
                                        catch (Exception var5_10 /* !! */ ) {
                                            if (!this.logger.finestOn()) break block48;
                                            this.logger.finest("start ", (Throwable)var5_10 /* !! */ );
                                        }
                                    }
                                    this.close();
                                    throw var3_11;
                                }
                                synchronized (var5_9 /* !! */ ) {
                                    this.interrupted = new Boolean(true);
                                    Thread.currentThread();
                                    Thread.interrupted();
                                    if (!this.sendEvent) break block50;
                                }
                                this.sendEvent(1);
                                ** try [egrp 3[TRYBLOCK] [12 : 375->384)] { 
lbl108:
                                // 1 sources

                                Thread.sleep(100L);
                                break block51;
lbl110:
                                // 1 sources

                                catch (Exception var5_9 /* !! */ ) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [13 : 386->395)] { 
lbl114:
                            // 1 sources

                            Thread.sleep(100L);
                            break block52;
lbl116:
                            // 1 sources

                            catch (Exception var5_9 /* !! */ ) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 5[TRYBLOCK] [14 : 397->406)] { 
lbl120:
                        // 1 sources

                        Thread.sleep(100L);
                        break block53;
lbl122:
                        // 1 sources

                        catch (Exception var5_9 /* !! */ ) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [15 : 408->417)] { 
lbl126:
                    // 1 sources

                    Thread.sleep(100L);
                    break block54;
lbl128:
                    // 1 sources

                    catch (Exception var5_9 /* !! */ ) {
                        // empty catch block
                    }
                }
                ** try [egrp 7[TRYBLOCK] [16 : 419->428)] { 
lbl132:
                // 1 sources

                Thread.sleep(100L);
                break block50;
lbl134:
                // 1 sources

                catch (Exception var5_9 /* !! */ ) {
                    // empty catch block
                }
            }
            if (this.logger.finerOn()) {
                this.logger.finer("run ", "Call leave group");
            }
            ** try [egrp 8[TRYBLOCK] [17, 18 : 451->458)] { 
lbl140:
            // 1 sources

            this.disconnectFromGroup();
            break block49;
lbl142:
            // 1 sources

            catch (IOException var5_9 /* !! */ ) {
                if (this.logger.finestOn()) {
                    this.logger.finest("start ", (Throwable)var5_9 /* !! */ );
                }
            }
lbl146:
            // 1 sources

            catch (Exception var5_9 /* !! */ ) {
                if (!this.logger.finestOn()) break block49;
                this.logger.finest("start ", (Throwable)var5_9 /* !! */ );
            }
        }
        this.close();
    }

    private void sendEvent(int n) {
        block3: {
            if (this.logger.finerOn()) {
                this.logger.finer("sendEvent ", "Format Event PDU");
            }
            ResponsePDU responsePDU = new ResponsePDU(this.mbeanServerName, this.SpecificationName, this.SpecificationVendor, this.SpecificationVersion, this.ImplementationName, this.ImplementationVendor, this.ImplementationVersion, this.discResponder.getUserData());
            this.formatPdu(responsePDU, null, true);
            responsePDU.setAgentState(n);
            try {
                this.sendMsg(responsePDU, this.multicastGroup, this.multicastPort);
            }
            catch (IOException iOException) {
                if (!this.logger.finerOn()) break block3;
                this.logger.finer("sendEvent ", "Unable to send event !");
                this.logger.finer("sendEvent ", iOException);
            }
        }
        this.discResponder.changeState(n);
    }

    private void processMsg(DiscoveryPDU discoveryPDU) throws IOException {
        int n;
        InetAddress inetAddress;
        block20: {
            if (discoveryPDU == null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("processMsg ", "received null pdu");
                }
                return;
            }
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "received pdu '" + discoveryPDU.printState() + "'");
            }
            if (discoveryPDU.getHost() != null) {
                try {
                    if (!Useful.isLocalHost(discoveryPDU.getHost())) {
                        if (this.logger.finerOn()) {
                            this.logger.finer("processMsg", "Got a message looking for MBeanServers on other machine: " + discoveryPDU.getHost() + ", No answer is required ");
                        }
                        return;
                    }
                    if (this.logger.finerOn()) {
                        this.logger.finer("processMsg", " Request is for this host ('" + this.localHostName + "')");
                    }
                    break block20;
                }
                catch (Exception exception) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("processMsg", "Cannot decide whether the requested host " + this.localHostName + "is same as the local host. " + exception);
                    }
                    break block20;
                }
            }
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg", " Request is for all host ");
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("processMsg ", "Format response PDU");
        }
        ResponsePDU responsePDU = new ResponsePDU(this.mbeanServerName, this.SpecificationName, this.SpecificationVendor, this.SpecificationVersion, this.ImplementationName, this.ImplementationVendor, this.ImplementationVersion, this.discResponder.getUserData());
        this.formatPdu(responsePDU, discoveryPDU, false);
        if (this.logger.finerOn()) {
            this.logger.finer("processMsg ", "Check point to point response");
        }
        if (discoveryPDU.getReturnAddr()) {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "Point to point response using  Port " + discoveryPDU.getReturnPort() + " on Host " + discoveryPDU.getReturnHost());
            }
            inetAddress = discoveryPDU.getReturnHost();
            n = discoveryPDU.getReturnPort();
        } else {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg", "Use multicast socket for response");
            }
            inetAddress = this.multicastGroup;
            n = this.multicastPort;
        }
        try {
            this.setTimeToLive(responsePDU.getTimeToLive());
            this.sendMsg(responsePDU, inetAddress, n);
        }
        catch (IOException iOException) {
            if (this.logger.finerOn()) {
                this.logger.finer("processMsg ", "Unable to send response !");
            }
            throw iOException;
        }
    }

    private void formatPdu(ResponsePDU responsePDU, DiscoveryPDU discoveryPDU, boolean bl) {
        if (!bl) {
            responsePDU.setTimeStamp(discoveryPDU.getTimeStamp());
        } else {
            responsePDU.setTimeStamp("");
        }
        responsePDU.setEvent(bl);
        if (!bl) {
            responsePDU.setTimeToLive(discoveryPDU.getTimeToLive());
        } else {
            responsePDU.setTimeToLive(this.ttl);
        }
        if (!bl) {
            responsePDU.setEmittedGroup(discoveryPDU.getEmittedGroup());
        } else {
            responsePDU.setEmittedGroup(this.multicastGroup);
        }
        if (!bl) {
            if (discoveryPDU.getHost() != null) {
                responsePDU.setHost(discoveryPDU.getHost());
            } else {
                responsePDU.setHost(this.localHostName);
            }
        } else {
            responsePDU.setHost(this.localHostName);
        }
        boolean bl2 = bl;
        Object var5_5 = null;
        if (discoveryPDU != null) {
            bl2 |= discoveryPDU.getObjectRequired();
        }
        if (bl2) {
            Object object;
            Object object2;
            Serializable serializable;
            Iterator<ObjectName> iterator;
            block59: {
                Set<ObjectName> set;
                String string;
                ObjectName objectName;
                block58: {
                    block57: {
                        int n;
                        block56: {
                            block55: {
                                objectName = null;
                                try {
                                    objectName = new ObjectName("*:*");
                                }
                                catch (MalformedObjectNameException malformedObjectNameException) {
                                    if (this.logger.finestOn()) {
                                        this.logger.finest("formatPdu ", malformedObjectNameException);
                                    }
                                    return;
                                }
                                string = "com.sun.jdmk.comm.RmiConnectorServer";
                                try {
                                    set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value(string)));
                                    if (this.logger.finerOn()) {
                                        iterator = set.iterator();
                                        while (iterator.hasNext()) {
                                            serializable = iterator.next();
                                            this.logger.finer("formatPdu ", "Add\t'" + serializable + "' in response msg");
                                        }
                                    }
                                    iterator = set.iterator();
                                    while (iterator.hasNext()) {
                                        serializable = iterator.next();
                                        try {
                                            object2 = (String)this.cmf.getAttribute((ObjectName)serializable, "Host");
                                            n = (Integer)this.cmf.getAttribute((ObjectName)serializable, "Port");
                                            object = (String)this.cmf.getAttribute((ObjectName)serializable, "ServiceName");
                                            RmiConnectorAddress rmiConnectorAddress = new RmiConnectorAddress((String)object2, n, (String)object);
                                            responsePDU.addObjectList((ObjectName)serializable, rmiConnectorAddress);
                                        }
                                        catch (Exception exception) {
                                            if (!this.logger.finestOn()) continue;
                                            this.logger.finest("formatPdu ", exception);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    if (!this.logger.finerOn()) break block55;
                                    this.logger.finer("formatPdu ", "Unable to get Mbean for " + string);
                                    this.logger.finer("formatPdu ", exception);
                                }
                            }
                            string = "com.sun.jdmk.comm.HttpConnectorServer";
                            try {
                                set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value(string)));
                                if (this.logger.finerOn()) {
                                    iterator = set.iterator();
                                    while (iterator.hasNext()) {
                                        serializable = iterator.next();
                                        this.logger.finer("formatPdu ", "Add\t'" + serializable + "' in response msg");
                                    }
                                }
                                iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    serializable = iterator.next();
                                    try {
                                        object2 = (String)this.cmf.getAttribute((ObjectName)serializable, "Host");
                                        n = (Integer)this.cmf.getAttribute((ObjectName)serializable, "Port");
                                        object = new HttpConnectorAddress((String)object2, n);
                                        responsePDU.addObjectList((ObjectName)serializable, (ConnectorAddress)object);
                                    }
                                    catch (Exception exception) {
                                        if (!this.logger.finestOn()) continue;
                                        this.logger.finest("formatPdu ", exception);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                if (!this.logger.finerOn()) break block56;
                                this.logger.finer("formatPdu ", "Unable to get Mbean for " + string);
                                this.logger.finer("formatPdu ", exception);
                            }
                        }
                        string = "com.sun.jdmk.comm.HttpsConnectorServer";
                        try {
                            set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value(string)));
                            if (this.logger.finerOn()) {
                                iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    serializable = iterator.next();
                                    this.logger.finer("formatPdu ", "Add\t'" + serializable + "' in response msg");
                                }
                            }
                            iterator = set.iterator();
                            while (iterator.hasNext()) {
                                serializable = iterator.next();
                                try {
                                    object2 = (String)this.cmf.getAttribute((ObjectName)serializable, "Host");
                                    n = (Integer)this.cmf.getAttribute((ObjectName)serializable, "Port");
                                    object = new HttpsConnectorAddress((String)object2, n);
                                    responsePDU.addObjectList((ObjectName)serializable, (ConnectorAddress)object);
                                }
                                catch (Exception exception) {
                                    if (!this.logger.finestOn()) continue;
                                    this.logger.finest("formatPdu ", exception);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!this.logger.finerOn()) break block57;
                            this.logger.finer("formatPdu ", "Unable to get Mbean for " + string);
                            this.logger.finer("formatPdu ", exception);
                        }
                    }
                    string = "com.sun.jdmk.comm.HtmlAdaptorServer";
                    try {
                        set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value(string)));
                        if (this.logger.finerOn()) {
                            iterator = set.iterator();
                            while (iterator.hasNext()) {
                                serializable = iterator.next();
                                this.logger.finer("formatPdu ", "Add\t'" + serializable + "' in response msg");
                            }
                        }
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            serializable = iterator.next();
                            try {
                                responsePDU.addObjectList((ObjectName)serializable, null);
                            }
                            catch (Exception exception) {
                                if (!this.logger.finestOn()) continue;
                                this.logger.finest("formatPdu ", exception);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!this.logger.finerOn()) break block58;
                        this.logger.finer("formatPdu ", "Unable to get Mbean for " + string);
                        this.logger.finer("formatPdu ", exception);
                    }
                }
                string = "com.sun.jdmk.comm.SnmpAdaptorServer";
                try {
                    set = this.cmf.queryNames(objectName, Query.match(Query.classattr(), Query.value(string)));
                    if (this.logger.finerOn()) {
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            serializable = iterator.next();
                            this.logger.finer("formatPdu ", "Add\t'" + serializable + "' in response msg");
                        }
                    }
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        serializable = iterator.next();
                        try {
                            responsePDU.addObjectList((ObjectName)serializable, null);
                        }
                        catch (Exception exception) {
                            if (!this.logger.finestOn()) continue;
                            this.logger.finest("formatPdu ", exception);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.logger.finerOn()) break block59;
                    this.logger.finer("formatPdu ", "Unable to get Mbean for " + string);
                    this.logger.finer("formatPdu ", exception);
                }
            }
            iterator = this.cmf.queryNames(null, null);
            serializable = new ArrayList();
            object2 = iterator.iterator();
            while (object2.hasNext()) {
                ObjectName objectName = (ObjectName)object2.next();
                try {
                    if (!this.cmf.isInstanceOf(objectName, "javax.management.remote.JMXConnectorServerMBean")) continue;
                    object = (JMXServiceURL)this.cmf.getAttribute(objectName, "Address");
                    ((ArrayList)serializable).add(object);
                    if (!this.logger.finerOn()) continue;
                    this.logger.finer("formatPdu ", "Add\t'" + object + "' in response msg");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                }
                catch (MBeanException mBeanException) {
                    if (!this.logger.traceOn()) continue;
                    this.logger.trace("formatPdu", "Failed to get address from the jmx remote server: " + objectName, mBeanException);
                }
                catch (Exception exception) {
                    if (!this.logger.traceOn()) continue;
                    this.logger.trace("formatPdu", "Failed to get address from the jmx remote server: " + objectName, exception);
                }
            }
            responsePDU.serverAddresses = ((ArrayList)serializable).toArray(new JMXServiceURL[((ArrayList)serializable).size()]);
        }
    }
}

