/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm.internal;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.HttpConnectorServer;
import com.sun.jdmk.comm.HttpsConnectorServer;
import com.sun.jdmk.comm.JdmkLegacyConnector;
import com.sun.jdmk.comm.RmiConnectorServer;
import com.sun.jdmk.comm.internal.EnvHelp;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;

public class JDMKServerConnector
extends JMXConnectorServer
implements JdmkLegacyConnector {
    private CommunicatorServer wrapped;
    private JMXServiceURL address;
    private Map env;
    private ClassLogger logger;

    public JDMKServerConnector(JMXServiceURL jMXServiceURL, Map map, MBeanServer mBeanServer) throws IOException {
        super(mBeanServer);
        if (jMXServiceURL == null) {
            throw new IllegalArgumentException("Null url.");
        }
        this.address = jMXServiceURL;
        this.logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.wrapper", "JDMKClientConnector-" + this.address.getProtocol());
        if (this.logger.finerOn()) {
            this.logger.fine("Constructor", "Construct a JDMK legacy connector server wrapper: " + this.address);
        }
        this.env = map == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(map);
        String string = this.address.getProtocol();
        if ("jdmk-http".equals(string) || "jdmk-https".equals(string)) {
            this.wrapped = this.getHttpConnectorServer(this.address);
        } else if ("jdmk-rmi".equals(string)) {
            String string2 = this.address.getURLPath();
            int n = string2.indexOf("/");
            if (n < 0 || string2.length() == n + 1) {
                string2 = "name=RmiConnectorServer";
            } else if ((string2 = string2.substring(n + 1)).trim().equals("")) {
                string2 = "name=RmiConnectorServer";
            }
            this.wrapped = new RmiConnectorServer(jMXServiceURL.getPort(), string2);
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + string);
        }
    }

    private CommunicatorServer getHttpConnectorServer(JMXServiceURL jMXServiceURL) throws IOException {
        if ("jdmk-http".equals(jMXServiceURL.getProtocol())) {
            return new HttpConnectorServer(jMXServiceURL.getPort(), this.getAuthInfo(), this.getLocalAddress());
        }
        return new HttpsConnectorServer(jMXServiceURL.getPort(), this.getAuthInfo(), this.getLocalAddress(), this.getNeedClientAuth());
    }

    private AuthInfo[] getAuthInfo() throws IOException {
        try {
            return (AuthInfo[])this.env.get("com.sun.jdmk.http.server.authinfo.list");
        }
        catch (ClassCastException classCastException) {
            IOException iOException = new IOException(classCastException.toString());
            EnvHelp.initCause(iOException, classCastException);
            throw iOException;
        }
    }

    private InetAddress getLocalAddress() throws IOException {
        try {
            return (InetAddress)this.env.get("com.sun.jdmk.http.server.local.address");
        }
        catch (ClassCastException classCastException) {
            IOException iOException = new IOException(classCastException.toString());
            EnvHelp.initCause(iOException, classCastException);
            throw iOException;
        }
    }

    private boolean getNeedClientAuth() throws IOException {
        try {
            String string = (String)this.env.get("com.sun.jdmk.https.server.need.client.auth");
            return string == null || !"false".equals(string.toLowerCase());
        }
        catch (ClassCastException classCastException) {
            IOException iOException = new IOException(classCastException.toString());
            EnvHelp.initCause(iOException, classCastException);
            throw iOException;
        }
    }

    public JMXServiceURL getAddress() {
        return this.address;
    }

    public Map getAttributes() {
        Map map = EnvHelp.filterAttributes(this.env);
        return Collections.unmodifiableMap(map);
    }

    public boolean isActive() {
        return this.wrapped.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.logger.finerOn()) {
            this.logger.fine("start", "start the server: " + this.address);
        }
        int[] nArray = new int[]{};
        MyListener myListener = new MyListener(nArray);
        this.wrapped.addNotificationListener(myListener, null, nArray);
        try {
            this.wrapped.start();
        }
        catch (CommunicationException communicationException) {
            IOException iOException = new IOException(communicationException.toString());
            if (communicationException.getTargetException() != null) {
                EnvHelp.initCause(iOException, communicationException.getTargetException());
            } else {
                EnvHelp.initCause(iOException, communicationException);
            }
            throw iOException;
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            while (!myListener.stateChanged) {
                try {
                    nArray.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            try {
                this.wrapped.removeNotificationListener(myListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.wrapped.isActive()) {
                throw new IOException("Failed to start the server, the server is not active.");
            }
            return;
        }
    }

    public void stop() throws IOException {
        if (this.logger.finerOn()) {
            this.logger.fine("stop", "stop the server: " + this.address);
        }
        this.wrapped.stop();
    }

    public String[] getConnectionIds() {
        throw new UnsupportedOperationException("Sorry.");
    }

    public Object getWrapped() {
        return this.wrapped;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        super.preRegister(mBeanServer, objectName);
        try {
            return this.wrapped.preRegister(mBeanServer, objectName);
        }
        catch (Exception exception) {
            return objectName;
        }
    }

    public void postRegister(Boolean bl) {
        this.wrapped.postRegister(bl);
    }

    public void preDeregister() throws Exception {
        this.wrapped.preDeregister();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    private class MyListener
    implements NotificationListener {
        public boolean stateChanged = false;
        private Object handback;

        public MyListener(Object object) {
            this.handback = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notification, Object object) {
            if (this.handback != object || !(notification instanceof AttributeChangeNotification) || JDMKServerConnector.this.wrapped.getState() == 3) {
                return;
            }
            Object object2 = this.handback;
            synchronized (object2) {
                this.stateChanged = true;
                this.handback.notifyAll();
            }
        }
    }
}

