/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpMessage;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class HttpRequest
extends HttpMessage {
    public int method = 0;
    public String requestURI = null;
    public static final int METHOD_GET = 1;
    public static final int METHOD_POST = 2;
    static final String MALFORMED_REQUEST_LINE = "Malformed request line";
    static final String MALFORMED_HEADER_LINE = "Malformed header line";
    static final String UNSUPPORTED_METHOD = "Unsupported HTTP method";
    static final String PREFIX_AUTHORIZATION = "Authorization: ";

    public HttpRequest(HttpBody httpBody) {
        super(httpBody);
    }

    public String getURIPath() {
        return this.requestURI;
    }

    public void readFrom(InputStream inputStream) throws IOException, MalformedHttpException {
        int n;
        String string;
        String string2;
        this.method = 0;
        this.requestURI = null;
        this.httpVersion = null;
        while ((string2 = HttpRequest.readLine(inputStream)).length() == 0) {
        }
        int n2 = string2.indexOf(32);
        int n3 = string2.indexOf(32, n2 + 1);
        if (n2 == -1 || n3 == -1) {
            throw new MalformedHttpException(MALFORMED_REQUEST_LINE);
        }
        String string3 = string2.substring(0, n2);
        if (string3.equals("GET")) {
            this.method = 1;
        } else if (string3.equals("POST")) {
            this.method = 2;
        } else {
            throw new MalformedHttpException(UNSUPPORTED_METHOD);
        }
        this.requestURI = string2.substring(n2 + 1, n3);
        this.httpVersion = string2.substring(n3 + 1);
        if (this.requestURI.length() == 0 || this.httpVersion.length() == 0) {
            throw new MalformedHttpException(MALFORMED_REQUEST_LINE);
        }
        block3: while ((string = HttpRequest.readLine(inputStream)).length() != 0) {
            n = string.indexOf(58);
            if (n < 0) {
                throw new MalformedHttpException(MALFORMED_HEADER_LINE);
            }
            String string4 = string.substring(0, n);
            for (int i = 0; i < KNOWN_HEADERS.length; ++i) {
                if (!string4.equalsIgnoreCase(KNOWN_HEADERS[i])) continue;
                this.setHeader(i, string.substring(n + 1).trim());
                continue block3;
            }
        }
        string = this.getHeader(0);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedHttpException(numberFormatException.toString());
            }
            if (n > 0) {
                this.readBodyFrom(inputStream, n);
            }
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        String string;
        switch (this.method) {
            case 1: {
                string = "GET";
                break;
            }
            case 2: {
                string = "POST";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported method " + this.method);
            }
        }
        String string2 = string + " " + this.requestURI + " " + this.httpVersion;
        this.writeHeadersAndBodyTo(outputStream, string2);
    }

    static String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = inputStream.read();
        int n2 = inputStream.read();
        while (n2 != -1 && (n != 13 || n2 != 10)) {
            stringBuffer.append((char)n);
            n = n2;
            n2 = inputStream.read();
        }
        if (n2 == -1) {
            throw new EOFException();
        }
        return stringBuffer.toString();
    }
}

