/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;

abstract class GenericHttpClientHandler
extends ClientHandler {
    private static final AuthInfo nullAuthInfo = new AuthInfo(){

        public void setLogin(String string) {
            throw new IllegalArgumentException("unsupported operation");
        }

        public void setPassword(String string) {
            throw new IllegalArgumentException("unsupported operation");
        }
    };
    private GenericHttpSocket sockClient = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public GenericHttpClientHandler(CommunicatorServer communicatorServer, int n, GenericHttpSocket genericHttpSocket, MBeanServer mBeanServer, ObjectName objectName) {
        super(communicatorServer, n, mBeanServer, objectName);
        this.sockClient = genericHttpSocket;
        this.thread.start();
    }

    protected abstract AuthInfo authenticateRequest(HttpRequest var1) throws IOException;

    protected abstract HttpResponse processPostRequest(HttpRequest var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        try {
            try {
                HttpRequest httpRequest = new HttpRequest(new HttpBody());
                boolean bl = true;
                while (bl) {
                    HttpResponse httpResponse = null;
                    try {
                        httpRequest.readFrom(this.sockClient.doGetInputStream());
                        httpResponse = this.processRequest(httpRequest);
                    }
                    catch (MalformedHttpException malformedHttpException) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Malformed HTTP request rejected");
                        }
                        httpResponse = this.makeErrorResponse(400, "Bad Request");
                    }
                    boolean bl2 = Boolean.getBoolean("com.sun.jdmk.http.server.noKeepAlive");
                    if (bl2) {
                        httpResponse.setHeader(3, "close");
                    } else {
                        httpResponse.setHeader(3, httpRequest.getHeader(3));
                    }
                    httpResponse.writeTo(this.sockClient.doGetOutputStream());
                    if (bl2) {
                        bl = false;
                        continue;
                    }
                    bl = httpResponse.hasKeepAliveFlag() && !this.interruptCalled;
                }
                Object var6_10 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Request handler interrupted");
                }
                Object var6_11 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
            catch (EOFException eOFException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Connection closed by peer");
                }
                Object var6_12 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "Request handler interrupted");
                    }
                } else if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "I/O exception " + socketException);
                }
                Object var6_13 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
            catch (IOException iOException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "I/O exception " + iOException);
                }
                Object var6_14 = null;
                this.closeClient();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            this.closeClient();
            if (this.logger.finestOn()) {
                this.logger.finest("doRun", "Socket is now closed");
            }
            throw throwable;
        }
    }

    protected HttpResponse processRequest(HttpRequest httpRequest) throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("processRequest", "Process the HTTP request");
        }
        HttpResponse httpResponse = null;
        AuthInfo authInfo = this.authenticateRequest(httpRequest);
        if (authInfo == null) {
            httpResponse = this.makeErrorResponse(401, "Unauthorized");
        } else if (httpRequest.method == 2) {
            httpResponse = this.processPostRequest(httpRequest);
        } else {
            if (this.logger.finestOn()) {
                this.logger.finest("processRequest", "Bad request: Request method not supported");
            }
            httpResponse = this.makeErrorResponse(400, "Bad Request");
        }
        return httpResponse;
    }

    protected HttpResponse makeOkResponse(byte[] byArray) {
        return this.makeResponse(200, "OK", byArray);
    }

    protected HttpResponse makeExceptionResponse(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = this.serialize("Exception", exception);
        }
        catch (IOException iOException) {
            if (this.logger.finestOn()) {
                this.logger.finest("makeExceptionResponse", "Got IOException when serializing : " + iOException);
            }
            return this.makeErrorResponse(400, "Bad Request");
        }
        if (this.logger.finestOn()) {
            this.logger.finest("makeExceptionResponse", "Sending back Exception : " + exception);
        }
        return this.makeResponse(400, "Bad Request", byteArrayOutputStream.toByteArray());
    }

    protected HttpResponse makeErrorResponse(int n, String string) {
        return this.makeResponse(n, string, null);
    }

    protected HttpResponse makeResponse(int n, String string, byte[] byArray) {
        HttpBody httpBody = byArray == null ? new HttpBody() : new HttpBody(byArray);
        HttpResponse httpResponse = new HttpResponse(httpBody);
        httpResponse.statusCode = n;
        httpResponse.reasonPhrase = string;
        httpResponse.setHeader(1, "application/octet-stream");
        httpResponse.setHeader(2, new Date().toString());
        httpResponse.setHeader(4, this.getChallenge());
        return httpResponse;
    }

    protected AuthInfo makeNullAuthInfo() {
        return nullAuthInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeClient() {
        if (this.logger.finerOn()) {
            this.logger.finer("closeClient", "Close client ...");
        }
        if (this.sockClient != null) {
            try {
                this.sockClient.doDisconnect();
            }
            catch (IOException iOException) {
            }
            catch (CommunicationException communicationException) {
            }
            finally {
                this.sockClient = null;
            }
        }
    }

    protected ByteArrayOutputStream serialize(String string, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(string);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream;
    }

    protected abstract String getChallenge();
}

