/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MBeanServerInt;
import com.sun.jdmk.MetaData;
import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.NamedObject;
import com.sun.jdmk.Repository;
import com.sun.jdmk.RepositorySupport;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import com.sun.jdmk.internal.ClassLogger;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class DefaultMBeanInterceptor
implements MBeanServerInterceptor {
    private static final ObjectName _MBSDelegateObjectName;
    private transient MBeanInstantiator instantiator = null;
    private transient MBeanServer server = null;
    private transient MetaData meta = null;
    private transient Repository repository = null;
    private transient WeakHashMap listenerWrappers = new WeakHashMap();
    private String domain = null;
    private boolean queryByRepo;
    private static final String dbgTag = "DefaultMBeanInterceptor";
    private static final ClassLogger logger;
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;
    static /* synthetic */ Class class$javax$management$NotificationEmitter;
    static /* synthetic */ Class class$javax$management$NotificationListener;

    public DefaultMBeanInterceptor(MBeanServer mBeanServer) {
        this.initialize(mBeanServer, ((MBeanServerInt)((Object)mBeanServer)).getMetaData(), ((MBeanServerInt)((Object)mBeanServer)).getMBeanInstantiator(), null, null);
    }

    public DefaultMBeanInterceptor(MBeanServer mBeanServer, String string) {
        this.initialize(mBeanServer, ((MBeanServerInt)((Object)mBeanServer)).getMetaData(), ((MBeanServerInt)((Object)mBeanServer)).getMBeanInstantiator(), string, null);
    }

    public DefaultMBeanInterceptor(MBeanServer mBeanServer, String string, Repository repository) {
        this.initialize(mBeanServer, ((MBeanServerInt)((Object)mBeanServer)).getMetaData(), ((MBeanServerInt)((Object)mBeanServer)).getMBeanInstantiator(), string, repository);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(string, objectName, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectName objectName2 = objectName;
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred during MBean creation");
        }
        if (objectName != null && objectName.isPattern()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name->" + objectName.toString());
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred during MBean creation");
        }
        String string2 = "null";
        if (objectName != null) {
            string2 = objectName.toString();
        }
        if (logger.finerOn()) {
            logger.finer("createMBean", "ClassName = " + string + ",ObjectName = " + string2);
        }
        Class clazz = this.instantiator.findClassWithDefaultLoaderRepository(string);
        this.instantiator.testCreation(clazz);
        this.meta.testCompliance(clazz);
        Object object = this.instantiator.instantiate(clazz, objectArray, stringArray, this.getClass().getClassLoader());
        ObjectName objectName3 = this.registerCreatedObject(object, objectName);
        return this.makeObjectInstance(string, object, objectName3);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Class clazz;
        Object object;
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred during MBean creation");
        }
        if (objectName != null && objectName.isPattern()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name->" + objectName.toString());
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred during MBean registration");
        }
        if (objectName2 == null) {
            object = "null";
            if (objectName != null) {
                object = objectName.toString();
            }
            if (logger.finerOn()) {
                logger.finer("createMBean", "ClassName = " + string + ",ObjectName = " + (String)object + " Loader name = null");
            }
            clazz = this.instantiator.findClass(string, this.getClass().getClassLoader());
        } else {
            object = "null";
            if (objectName != null) {
                object = objectName.toString();
            }
            if (logger.finerOn()) {
                logger.finer("createMBean", "ClassName = " + string + ",ObjectName = " + (String)object + ",Loader name = " + objectName2.toString());
            }
            clazz = this.instantiator.findClass(string, objectName2);
        }
        this.instantiator.testCreation(clazz);
        this.meta.testCompliance(clazz);
        object = this.instantiator.instantiate(clazz, objectArray, stringArray, this.getClass().getClassLoader());
        ObjectName objectName3 = this.registerCreatedObject(object, objectName);
        return this.makeObjectInstance(string, object, objectName3);
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName objectName2 = objectName;
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        this.meta.testCompliance(clazz);
        ObjectName objectName3 = this.registerObject(object, objectName);
        return this.makeObjectInstance(string, object, objectName3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (objectName == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Object name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to unregister the MBean");
        }
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            ModifiableClassLoaderRepository modifiableClassLoaderRepository;
            Object object = this.repository.retrieve(objectName);
            if (object == null) {
                if (logger.finerOn()) {
                    logger.finer("unregisterMBean", objectName + ": Found no object");
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
            if (object instanceof MBeanRegistration) {
                this.meta.preDeregisterInvoker(object);
            }
            this.repository.remove(objectName);
            if (logger.finerOn()) {
                logger.finer("unregisterMBean", "Send delete notification of object " + objectName.getCanonicalName());
            }
            this.sendNotification("JMX.mbean.unregistered", objectName);
            if (object instanceof MBeanRegistration) {
                this.meta.postDeregisterInvoker(object);
            }
            if (object instanceof ClassLoader && (modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository()) != null) {
                modifiableClassLoaderRepository.removeClassLoader(objectName);
            }
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        String string;
        Object object = this.getMBean(objectName);
        try {
            string = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            logger.finest("getObjectInstance", introspectionException);
            throw new JMRuntimeException("Can't obtain class name for " + objectName + ": " + introspectionException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            logger.finest("getObjectInstance", notCompliantMBeanException);
            throw new JMRuntimeException("Can't obtain class name for " + objectName + ": " + notCompliantMBeanException);
        }
        return new ObjectInstance(objectName, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        Set set;
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            set = this.repository.query(objectName, queryExp);
        }
        if (this.queryByRepo) {
            return set;
        }
        return this.filterListOfObjects(set, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
        Set set = this.queryMBeans(objectName, queryExp);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(objectInstance.getObjectName());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDomains() {
        Set set;
        Object object = this;
        synchronized (object) {
            set = this.repository.query(null, null);
        }
        object = new HashSet(1);
        String[] stringArray = set.iterator();
        while (stringArray.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)stringArray.next();
            ObjectName objectName = objectInstance.getObjectName();
            String string = objectName.getDomain();
            if (object.contains(string)) continue;
            object.add(string);
        }
        stringArray = new String[object.size()];
        return object.toArray(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ObjectName objectName) {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Object name cannot be null");
        }
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            return this.repository.contains(objectName);
        }
    }

    public Integer getMBeanCount() {
        return this.repository.getCount();
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (logger.finerOn()) {
            logger.finer("getAttribute", "Attribute= " + string + ", obj= " + objectName);
        }
        Object object = this.getMBean(objectName);
        return this.meta.getAttribute(object, string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        if (stringArray.length == 0) {
            return new AttributeList(0);
        }
        if (logger.finerOn()) {
            logger.finer("getAttributes", "Object= " + objectName);
        }
        Object object = this.getMBean(objectName);
        return this.meta.getAttributes(object, stringArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (logger.finerOn()) {
            logger.finer("setAttribute", "Object= " + objectName + ", attribute=" + attribute.getName());
        }
        Object object = this.getMBean(objectName);
        Object object2 = this.meta.setAttribute(object, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        if (attributeList.isEmpty()) {
            return attributeList;
        }
        Object object = this.getMBean(objectName);
        return this.meta.setAttributes(object, attributeList);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object object = this.getMBean(objectName);
        return this.meta.invoke(object, string, objectArray, stringArray);
    }

    protected MetaData meta() {
        return this.meta;
    }

    protected ObjectInstance makeObjectInstance(String string, Object object, ObjectName objectName) throws NotCompliantMBeanException {
        if (object instanceof DynamicMBean) {
            try {
                string = this.meta.getMBeanClassName(object);
            }
            catch (IntrospectionException introspectionException) {
                logger.finest("makeObjectInstance", introspectionException);
                throw new NotCompliantMBeanException("Can't obtain class name for " + objectName + ": " + introspectionException);
            }
            catch (JMRuntimeException jMRuntimeException) {
                logger.finest("makeObjectInstance", jMRuntimeException);
                throw new NotCompliantMBeanException("Can't obtain class name for " + objectName + ": " + jMRuntimeException);
            }
        }
        if (string == null) {
            throw new NotCompliantMBeanException("The class Name returned is null");
        }
        return new ObjectInstance(objectName, string);
    }

    protected ObjectName registerObject(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName objectName2 = objectName;
        if (object == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot add null object");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to register the MBean");
        }
        String string = "null";
        if (objectName != null) {
            string = objectName.toString();
        }
        if (logger.finerOn()) {
            logger.finer("registerMBean", "ObjectName = " + string);
        }
        Object var5_6 = null;
        if (object instanceof MBeanRegistration) {
            objectName2 = this.meta.preRegisterInvoker(object, objectName, this.server);
        }
        if (objectName2 == null) {
            if (object instanceof MBeanRegistration) {
                this.meta.postRegisterInvoker(object, false);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No object name specified");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to register the MBean");
        }
        this.internal_addObject(object, objectName2);
        if (object instanceof MBeanRegistration) {
            this.meta.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            ModifiableClassLoaderRepository modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository();
            if (modifiableClassLoaderRepository == null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Dynamic addition of class loaders is not supported");
                throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to register the MBean as a class loader");
            }
            modifiableClassLoaderRepository.addClassLoader(objectName2, (ClassLoader)object);
        }
        return objectName2;
    }

    protected ObjectName registerCreatedObject(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        return this.registerObject(object, objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMBean(ObjectName objectName) throws InstanceNotFoundException {
        block9: {
            if (objectName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occurred trying to get an MBean");
            }
            if (objectName.getDomain().equals("")) {
                try {
                    objectName = new ObjectName(this.domain + objectName.toString());
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!logger.finestOn()) break block9;
                    logger.finest("getMBean", "Unexpected MalformedObjectNameException");
                }
            }
        }
        Object object = null;
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            object = this.repository.retrieve(objectName);
            if (object == null) {
                if (logger.finerOn()) {
                    logger.finer("getMBean", objectName + ": Found no object");
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
        }
        return object;
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        Object object2;
        if (logger.finerOn()) {
            logger.finer("addNotificationListener", "obj= " + objectName);
        }
        if (!((object2 = this.getMBean(objectName)) instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName.getCanonicalName()), "The MBean " + objectName.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        NotificationBroadcaster notificationBroadcaster = (NotificationBroadcaster)object2;
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        NotificationListener notificationListener2 = this.getListenerWrapper(notificationListener, objectName, object2, true);
        notificationBroadcaster.addNotificationListener(notificationListener2, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        Object object2 = this.getMBean(objectName2);
        if (!(object2 instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName2.getCanonicalName()), "The MBean " + objectName2.getCanonicalName() + "does not implement the NotificationListener interface");
        }
        if (logger.finerOn()) {
            logger.finer("addNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.addNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(objectName, notificationListener, null, null, true);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(objectName, notificationListener, notificationFilter, object, false);
    }

    private void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, boolean bl) throws InstanceNotFoundException, ListenerNotFoundException {
        if (logger.finerOn()) {
            logger.finer("removeNotificationListener", "obj= " + objectName);
        }
        Object object2 = this.getMBean(objectName);
        NotificationBroadcaster notificationBroadcaster = null;
        NotificationEmitter notificationEmitter = null;
        if (bl) {
            if (!(object2 instanceof NotificationBroadcaster)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(objectName.getCanonicalName());
                String string = "MBean " + objectName.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = DefaultMBeanInterceptor.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getName();
                throw new RuntimeOperationsException(illegalArgumentException, string);
            }
            notificationBroadcaster = (NotificationBroadcaster)object2;
        } else {
            if (!(object2 instanceof NotificationEmitter)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(objectName.getCanonicalName());
                String string = "MBean " + objectName.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = DefaultMBeanInterceptor.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter).getName();
                throw new RuntimeOperationsException(illegalArgumentException, string);
            }
            notificationEmitter = (NotificationEmitter)object2;
        }
        NotificationListener notificationListener2 = this.getListenerWrapper(notificationListener, objectName, object2, false);
        if (notificationListener2 == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        if (bl) {
            notificationBroadcaster.removeNotificationListener(notificationListener2);
        } else {
            notificationEmitter.removeNotificationListener(notificationListener2, notificationFilter, object);
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(objectName, objectName2, null, null, true);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(objectName, objectName2, notificationFilter, object, false);
    }

    private void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object, boolean bl) throws InstanceNotFoundException, ListenerNotFoundException {
        Object object2;
        try {
            object2 = this.getMBean(objectName2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new ListenerNotFoundException(instanceNotFoundException.getMessage());
        }
        if (!(object2 instanceof NotificationListener)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(objectName2.getCanonicalName());
            String string = "MBean " + objectName.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationListener == null ? (class$javax$management$NotificationListener = DefaultMBeanInterceptor.class$("javax.management.NotificationListener")) : class$javax$management$NotificationListener).getName();
            throw new RuntimeOperationsException(illegalArgumentException, string);
        }
        if (logger.finerOn()) {
            logger.finer("removeNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.removeNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object, bl);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Object object = this.getMBean(objectName);
        MBeanInfo mBeanInfo = this.meta.getMBeanInfo(object);
        if (mBeanInfo == null) {
            throw new JMRuntimeException("MBean " + objectName + "has no MBeanInfo");
        }
        return mBeanInfo;
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        try {
            return this.meta.isInstanceOf(object, string);
        }
        catch (ReflectionException reflectionException) {
            logger.finest("isInstanceOf", reflectionException);
            return false;
        }
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        if (object == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        if (!(object instanceof ClassLoader)) {
            throw new InstanceNotFoundException(objectName.toString() + " is not a ClassLoader");
        }
        return (ClassLoader)object;
    }

    public final ClassLoader getMBeanClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.getClassLoaderFor(objectName);
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        return object.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internal_addObject(Object object, ObjectName objectName) throws InstanceAlreadyExistsException {
        DefaultMBeanInterceptor defaultMBeanInterceptor = this;
        synchronized (defaultMBeanInterceptor) {
            try {
                this.repository.addMBean(object, objectName);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (object instanceof MBeanRegistration) {
                    this.meta.postRegisterInvoker(object, false);
                }
                throw instanceAlreadyExistsException;
            }
        }
        if (logger.finerOn()) {
            logger.finer("addObject", "Send create notification of object " + objectName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.registered", objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String string, ObjectName objectName) {
        MBeanServerNotification mBeanServerNotification = null;
        Object object = this;
        synchronized (object) {
            if (logger.finerOn()) {
                logger.finer("sendNotrification", string + " " + objectName);
            }
            mBeanServerNotification = new MBeanServerNotification(string, (Object)_MBSDelegateObjectName, 0L, objectName);
        }
        object = ((MBeanServerInt)((Object)this.server)).getMBeanServerDelegate();
        ((MBeanServerDelegate)object).sendNotification(mBeanServerNotification);
    }

    private void initialize(MBeanServer mBeanServer, MetaData metaData, MBeanInstantiator mBeanInstantiator, String string, Repository repository) {
        this.server = mBeanServer;
        this.meta = metaData;
        this.instantiator = mBeanInstantiator;
        this.repository = repository;
        if (this.repository == null) {
            this.repository = new RepositorySupport();
        }
        this.domain = string == null || string.equals("") ? this.repository.getDefaultDomain() : string;
        this.repository.setDefaultDomain(this.domain);
        if (logger.finerOn()) {
            logger.finer("new", "Initializing domain " + this.domain);
        }
        try {
            this.queryByRepo = this.repository.isFiltering();
        }
        catch (Exception exception) {
            this.queryByRepo = false;
        }
    }

    private Set filterListOfObjects(Set set, QueryExp queryExp) {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        if (queryExp == null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                NamedObject namedObject;
                block10: {
                    namedObject = (NamedObject)iterator.next();
                    Object object = namedObject.getObject();
                    string = null;
                    try {
                        string = this.meta.getMBeanClassName(object);
                    }
                    catch (JMException jMException) {
                        if (!logger.finestOn()) break block10;
                        logger.finest("filterListOfObjects", "Can't obtain class name for " + namedObject.getName() + ": " + jMException);
                    }
                }
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                NamedObject namedObject;
                block11: {
                    namedObject = (NamedObject)iterator.next();
                    Object object = namedObject.getObject();
                    boolean bl = false;
                    queryExp.setMBeanServer(this.server);
                    try {
                        bl = queryExp.apply(namedObject.getName());
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!bl) continue;
                    string = null;
                    try {
                        string = this.meta.getMBeanClassName(object);
                    }
                    catch (JMException jMException) {
                        if (!logger.finestOn()) break block11;
                        logger.finest("filterListOfObjects", "Can't obtain class name for " + namedObject.getName() + ": " + jMException);
                    }
                }
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationListener getListenerWrapper(NotificationListener notificationListener, ObjectName objectName, Object object, boolean bl) {
        ListenerWrapper listenerWrapper = new ListenerWrapper(notificationListener, objectName, object);
        WeakHashMap weakHashMap = this.listenerWrappers;
        synchronized (weakHashMap) {
            NotificationListener notificationListener2;
            WeakReference weakReference = (WeakReference)this.listenerWrappers.get(listenerWrapper);
            if (weakReference != null && (notificationListener2 = (NotificationListener)weakReference.get()) != null) {
                return notificationListener2;
            }
            if (bl) {
                this.listenerWrappers.put(listenerWrapper, new WeakReference<ListenerWrapper>(listenerWrapper));
                return listenerWrapper;
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            _MBSDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new UnsupportedOperationException(malformedObjectNameException.getMessage());
        }
        logger = new ClassLogger("com.sun.jdmk.mbeanserver", dbgTag);
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private NotificationListener listener;
        private ObjectName name;
        private Object mbean;

        ListenerWrapper(NotificationListener notificationListener, ObjectName objectName, Object object) {
            this.listener = notificationListener;
            this.name = objectName;
            this.mbean = object;
        }

        public void handleNotification(Notification notification, Object object) {
            if (notification != null && notification.getSource() == this.mbean) {
                notification.setSource(this.name);
            }
            this.listener.handleNotification(notification, object);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ListenerWrapper)) {
                return false;
            }
            ListenerWrapper listenerWrapper = (ListenerWrapper)object;
            return listenerWrapper.listener == this.listener && listenerWrapper.mbean == this.mbean && listenerWrapper.name.equals(this.name);
        }

        public int hashCode() {
            return System.identityHashCode(this.listener) ^ System.identityHashCode(this.mbean);
        }
    }
}

