/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.Com4jObject;
import com4j.ComException;
import com4j.ComMethod;
import com4j.ErrorInfo;
import com4j.GUID;
import com4j.Holder;
import com4j.IErrorInfo;
import com4j.IllegalAnnotationException;
import com4j.MethodIntrospector;
import com4j.Native;
import com4j.NativeType;
import com4j.ReturnValue;
import com4j.VTID;
import com4j.Variant;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.Buffer;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class StandardComMethod
extends ComMethod {
    final Method method;
    final int vtIndex;
    final int[] paramConvs;
    final NativeType[] params;
    final int returnIndex;
    final boolean returnIsInOut;
    final NativeType returnConv;
    final Class<?>[] paramTypes;
    final Type[] genericParamTypes;
    private static final Map<Class, NativeType> defaultConversions = new HashMap<Class, NativeType>();

    StandardComMethod(Method m) {
        this.method = m;
        MethodIntrospector mi = new MethodIntrospector(m);
        VTID vtid = m.getAnnotation(VTID.class);
        if (vtid == null) {
            throw new IllegalAnnotationException("@VTID is missing: " + m.toGenericString());
        }
        this.vtIndex = vtid.value();
        Annotation[][] pa = m.getParameterAnnotations();
        int paramLen = pa.length;
        ReturnValue rt = m.getAnnotation(ReturnValue.class);
        if (rt != null) {
            this.returnIndex = rt.index() == -1 ? pa.length : rt.index();
            this.returnIsInOut = rt.inout();
            this.returnConv = rt.type();
        } else if (this.method.getReturnType() == Void.TYPE) {
            this.returnIndex = -1;
            this.returnIsInOut = false;
            this.returnConv = NativeType.Default;
        } else {
            this.returnIndex = paramLen;
            this.returnIsInOut = false;
            this.returnConv = StandardComMethod.getDefaultConversion(this.method.getReturnType());
        }
        this.paramTypes = m.getParameterTypes();
        this.genericParamTypes = m.getGenericParameterTypes();
        this.paramConvs = new int[paramLen];
        this.params = new NativeType[paramLen];
        for (int i = 0; i < paramLen; ++i) {
            NativeType n;
            this.params[i] = n = mi.getParamConversation(i);
            this.paramConvs[i] = n.code;
        }
    }

    Object invoke(int ptr, Object[] args) {
        Object h;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Holder && this.params[i].getNoByRef() != null) {
                h = (Holder)args[i];
                ((Holder)h).value = this.params[i].getNoByRef().massage(((Holder)h).value);
                continue;
            }
            args[i] = this.params[i].massage(args[i]);
        }
        try {
            Object r = Native.invoke(ptr, this.vtIndex, args, this.paramConvs, this.returnIndex, this.returnIsInOut, this.returnConv.code);
            h = this.returnConv.unmassage(this.method.getReturnType(), this.method.getGenericReturnType(), r);
            Object var6_8 = null;
        }
        catch (ComException e) {
            try {
                try {
                    IErrorInfo pErrorInfo = Native.getErrorInfo(ptr, this.method.getDeclaringClass());
                    if (pErrorInfo != null) {
                        e.setErrorInfo(new ErrorInfo(pErrorInfo));
                        pErrorInfo.dispose();
                    }
                }
                catch (ComException x) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] instanceof Holder && this.params[i].getNoByRef() != null) {
                        Holder h2 = (Holder)args[i];
                        Type holderParamType = StandardComMethod.getTypeParameter(this.genericParamTypes[i], 0);
                        h2.value = this.params[i].getNoByRef().unmassage(StandardComMethod.erasure(holderParamType), holderParamType, h2.value);
                        continue;
                    }
                    args[i] = this.params[i].unmassage(this.paramTypes[i], this.genericParamTypes[i], args[i]);
                }
                throw throwable;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Holder && this.params[i].getNoByRef() != null) {
                Holder h2 = (Holder)args[i];
                Type holderParamType = StandardComMethod.getTypeParameter(this.genericParamTypes[i], 0);
                h2.value = this.params[i].getNoByRef().unmassage(StandardComMethod.erasure(holderParamType), holderParamType, h2.value);
                continue;
            }
            args[i] = this.params[i].unmassage(this.paramTypes[i], this.genericParamTypes[i], args[i]);
        }
        return h;
    }

    static NativeType getDefaultConversion(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            NativeType r = defaultConversions.get(c);
            if (r != null) {
                return r;
            }
            if (Com4jObject.class.isAssignableFrom(c)) {
                return NativeType.ComObject;
            }
            if (Enum.class.isAssignableFrom(c)) {
                return NativeType.Int32;
            }
            if (Buffer.class.isAssignableFrom(c)) {
                return NativeType.PVOID;
            }
            if (Calendar.class.isAssignableFrom(c)) {
                return NativeType.Date;
            }
            if (c.isArray()) {
                return NativeType.SafeArray;
            }
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            if (p.getRawType() == Holder.class) {
                Class c;
                Type v = p.getActualTypeArguments()[0];
                Class clazz = c = v instanceof Class ? (Class)v : null;
                if (c != null) {
                    if (Com4jObject.class.isAssignableFrom(c)) {
                        return NativeType.ComObject_ByRef;
                    }
                    if (String.class == c) {
                        return NativeType.BSTR_ByRef;
                    }
                    if (Integer.class == c || Enum.class.isAssignableFrom(c)) {
                        return NativeType.Int32_ByRef;
                    }
                    if (Boolean.class == c) {
                        return NativeType.VariantBool_ByRef;
                    }
                    if (Buffer.class.isAssignableFrom(c)) {
                        return NativeType.PVOID_ByRef;
                    }
                }
            }
            if (p.getRawType() == Iterator.class) {
                return NativeType.ComObject;
            }
        }
        throw new IllegalAnnotationException("no default conversion available for " + t);
    }

    private static Type getTypeParameter(Type t, int index) {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return pt.getActualTypeArguments()[index];
        }
        return Object.class;
    }

    private static Class erasure(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return StandardComMethod.erasure(pt.getRawType());
        }
        if (t instanceof WildcardType) {
            WildcardType wt = (WildcardType)t;
            Type[] ub = wt.getUpperBounds();
            if (ub.length == 0) {
                return Object.class;
            }
            return StandardComMethod.erasure(ub[0]);
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType ga = (GenericArrayType)t;
            return Array.newInstance(StandardComMethod.erasure(ga.getGenericComponentType()), 0).getClass();
        }
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            Type[] ub = tv.getBounds();
            if (ub.length == 0) {
                return Object.class;
            }
            return StandardComMethod.erasure(ub[0]);
        }
        throw new IllegalArgumentException(t.toString());
    }

    static {
        defaultConversions.put(Iterator.class, NativeType.ComObject);
        defaultConversions.put(GUID.class, NativeType.GUID);
        defaultConversions.put(Double.TYPE, NativeType.Double);
        defaultConversions.put(Float.TYPE, NativeType.Float);
        defaultConversions.put(Integer.TYPE, NativeType.Int32);
        defaultConversions.put(Short.TYPE, NativeType.Int16);
        defaultConversions.put(Byte.TYPE, NativeType.Int8);
        defaultConversions.put(Boolean.TYPE, NativeType.VariantBool);
        defaultConversions.put(String.class, NativeType.BSTR);
        defaultConversions.put(Object.class, NativeType.VARIANT_ByRef);
        defaultConversions.put(Variant.class, NativeType.VARIANT_ByRef);
        defaultConversions.put(Date.class, NativeType.Date);
    }
}

