/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.axiondb.jdbc.AxionClob;
import org.axiondb.util.ExceptionConverter;

public class StringClob
implements AxionClob {
    private String _value = null;

    public StringClob(String str) {
        if (null == str) {
            throw new NullPointerException();
        }
        this._value = str;
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this._value.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionConverter.convert(e);
        }
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this._value);
    }

    public String getSubString(long pos, int len) throws SQLException {
        return this._value.substring((int)pos, (int)pos + len);
    }

    public long length() throws SQLException {
        return this._value.length();
    }

    public long position(Clob searchstr, long start) throws SQLException {
        if (null == searchstr) {
            throw new SQLException("search string was null");
        }
        StringBuffer buf = new StringBuffer();
        Reader in = searchstr.getCharacterStream();
        try {
            int c = in.read();
            while (c != -1) {
                buf.append((char)c);
                c = in.read();
            }
        }
        catch (IOException e) {
            throw ExceptionConverter.convert(e);
        }
        return this.position(buf.toString(), start);
    }

    public long position(String searchstr, long start) throws SQLException {
        if (null == searchstr) {
            throw new SQLException("search string was null");
        }
        return this._value.indexOf(searchstr, (int)start);
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLException("Unsupported");
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new SQLException("Unsupported");
    }

    public int setString(long pos, String str) throws SQLException {
        throw new SQLException("Unsupported");
    }

    public int setString(long pos, String str, int offset, int length) throws SQLException {
        throw new SQLException("Unsupported");
    }

    public String getString() {
        return this._value;
    }

    public void truncate(long length) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    public void free() throws SQLException {
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw new SQLException("Unsupported.");
    }
}

