/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.axiondb.AxionException;
import org.axiondb.types.LobSource;

public class CompressedLobSource
implements LobSource {
    private LobSource _source = null;

    public CompressedLobSource(LobSource source) {
        this._source = source;
    }

    public long length() throws AxionException {
        throw new AxionException("Can't get the length of compressed lob types.");
    }

    public void truncate(long length) throws AxionException {
        if (0L != length) {
            throw new AxionException("Length must be 0, found " + length + ".");
        }
        this._source.truncate(length);
    }

    public InputStream getInputStream() throws AxionException {
        try {
            return new GZIPInputStream(this._source.getInputStream());
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }

    public OutputStream setOutputStream(long pos) throws AxionException {
        if (pos != 0L) {
            throw new AxionException("Position must be 0, found " + pos + ".");
        }
        try {
            return new GZIPOutputStream(this._source.setOutputStream(pos));
        }
        catch (IOException e) {
            throw new AxionException(e);
        }
    }
}

