/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.types.StringType;
import org.axiondb.util.ValuePool;

public class InStringFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new StringType();
    private static final DataType ARG_TYPE = new IntegerType();

    public InStringFunction() {
        super("INSTRING");
    }

    public ConcreteFunction makeNewInstance() {
        return new InStringFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object evaluate(RowDecorator row) throws AxionException {
        int pos = -1;
        String str = (String)this.getArgument(0).evaluate(row);
        String substr = (String)this.getArgument(1).evaluate(row);
        if (str == null || substr == null) {
            return ValuePool.getInt(pos);
        }
        if (this.getArgumentCount() == 3) {
            Object val3 = this.getArgument(2).evaluate(row);
            if (val3 == null) throw new AxionException("Value " + val3 + " cannot be converted to a " + ARG_TYPE);
            Integer startPos = (Integer)ARG_TYPE.convert(val3);
            if (startPos >= 0) {
                pos = str.indexOf(substr, (int)startPos);
                return ValuePool.getInt(pos);
            } else {
                int fromIdx = str.length() - Math.abs(startPos);
                pos = str.lastIndexOf(substr, fromIdx);
            }
            return ValuePool.getInt(pos);
        } else {
            pos = str.indexOf(substr);
        }
        return ValuePool.getInt(pos);
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 2 && this.getArgumentCount() < 4;
    }
}

