/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecoratorIterator;
import org.axiondb.Selectable;
import org.axiondb.functions.AggregateFunction;
import org.axiondb.functions.BaseAggregateFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.types.IntegerType;

public class CountFunction
extends BaseAggregateFunction
implements AggregateFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new IntegerType();

    public CountFunction() {
        super("COUNT");
    }

    public ConcreteFunction makeNewInstance() {
        return new CountFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecoratorIterator rows) throws AxionException {
        int count = 0;
        this.setDistinct();
        Selectable sel = this.getArgument(0);
        if (this.isDistinct()) {
            if (sel.getName().equals("*")) {
                throw new AxionException("Invalid Expression, Use COUNT(DISTINCT <column>)");
            }
            while (rows.hasNext()) {
                Object rawVal = sel.evaluate(rows.next());
                DataType type = sel.getDataType();
                Object val = type.convert(rawVal);
                if (!this.acceptable(val)) continue;
                ++count;
            }
        } else {
            count = rows.size();
        }
        return new Integer(count);
    }
}

