/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.collections.primitives.IntCollection;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.RowCollection;
import org.axiondb.engine.tables.BaseFlatfileTable;
import org.axiondb.engine.tables.DelimitedFlatfileTable;
import org.axiondb.engine.tables.WebTableLoader;

public class WebTable
extends DelimitedFlatfileTable {
    private static final Set PROPERTY_KEYS = new HashSet(5);
    private static final Set REQUIRED_KEYS = new HashSet(1);
    private static final String PROP_URL = "URL";
    private static final String PROP_REFRESH = "REFRESH";
    private static final String PROP_TABLE_NO = "TABLENUMBER";
    private int _tableNumber = -1;
    private boolean _refresh = false;
    private String url;
    private HTMLDocument doc;
    private URL web;
    private EditorKit kit;

    public WebTable(String name, Database db) throws AxionException {
        super(name, db, new WebTableLoader());
        this.setType("WEB TABLE");
    }

    public void applyDeletes(IntCollection rowIds) throws AxionException {
        throw new AxionException("Operation not supported");
    }

    public void applyInserts(RowCollection rows) throws AxionException {
        throw new AxionException("Operation not supported");
    }

    public void applyUpdates(RowCollection rows) throws AxionException {
        throw new AxionException("Operation not supported");
    }

    protected void parseTableProperties(ObjectInputStream in) throws AxionException {
        try {
            this._lineSep = in.readUTF();
            this._fieldSep = in.readUTF();
            this._isFirstLineHeader = Boolean.valueOf(in.readUTF());
            this._fileName = in.readUTF();
            in.readUTF();
            this._qualifier = in.readUTF();
            in.readUTF();
            try {
                this._rowCount = in.readInt();
            }
            catch (EOFException ignore) {
                // empty catch block
            }
            this.url = in.readUTF();
            this._refresh = in.readBoolean();
            this._tableNumber = in.readInt();
            this.context = new WebTableOrganizationContext();
            this.context.updateProperties();
            this.context.readOrSetDefaultProperties(this.context.getTableProperties());
            this.createOrLoadDataFile();
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to parse meta file for table " + this.getName(), ioex);
        }
    }

    protected void writeTableProperties(ObjectOutputStream out) throws AxionException {
        try {
            if (this._lineSep != null && this._fieldSep != null && this._fileName != null) {
                out.writeUTF(this._lineSep);
                out.writeUTF(this._fieldSep);
                out.writeUTF(Boolean.toString(this._isFirstLineHeader));
                out.writeUTF(this._fileName);
                out.writeUTF(this._lineSep);
                out.writeUTF(this._qualifier);
                out.writeUTF("true");
                out.writeInt(this._rowsToSkip);
                out.writeUTF(this.url);
                out.writeBoolean(this._refresh);
                out.writeInt(this._tableNumber);
            }
        }
        catch (IOException ioex) {
            throw new AxionException("Unable to write meta file for table " + this.getName(), ioex);
        }
    }

    public boolean loadExternalTable(Properties props) throws AxionException {
        this.context = new WebTableOrganizationContext();
        try {
            this.context.readOrSetDefaultProperties(props);
            this.context.updateProperties();
            this.createOrLoadDataFile();
            this.initializeTable();
            this.writeMetaFile();
            return true;
        }
        catch (Exception e) {
            try {
                this.drop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AxionException("Failed to create table using supplied properties. ", e);
        }
    }

    private void createDataFile() throws AxionException {
        this.getURL();
        this.initializeEditorKit();
        Element element = this.getTableElement(this._tableNumber);
        this.createCSV(element);
    }

    private void initializeEditorKit() {
        this.kit = new HTMLEditorKit();
        this.doc = (HTMLDocument)this.kit.createDefaultDocument();
        this.doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            this.kit.read(this.web.openStream(), (Document)this.doc, 0);
        }
        catch (IOException ex) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void getURL() throws AxionException {
        try {
            if (this.url.startsWith("http") || this.url.startsWith("file")) {
                this.web = new URI(this.url.trim()).toURL();
            } else {
                File file = new File(this.url.trim());
                if (file.exists()) {
                    this.web = file.toURI().toURL();
                }
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    private Element getTableElement(int _tableNumber) {
        int count = 0;
        ElementIterator it = new ElementIterator(this.doc);
        Element element = null;
        while ((element = it.next()) != null) {
            if ("table".equalsIgnoreCase(element.getName())) {
                ++count;
            }
            if (count != _tableNumber) continue;
            return element;
        }
        return null;
    }

    private void createCSV(Element element) throws AxionException {
        FileOutputStream out;
        File datafile = this.getDataFile();
        try {
            out = new FileOutputStream(datafile);
        }
        catch (IOException ex) {
            throw new AxionException(ex);
        }
        ElementIterator eleIt = new ElementIterator(element);
        Element elem = null;
        LinkedList list = new LinkedList();
        Object th = null;
        try {
            int i = 0;
            StringBuffer trData = new StringBuffer();
            while ((elem = eleIt.next()) != null) {
                if (elem.getName().equalsIgnoreCase("tr")) {
                    if (i++ == 0) continue;
                    trData.append(this._preferredLineSep);
                    out.write(trData.toString().getBytes());
                    trData = new StringBuffer();
                    continue;
                }
                if (!elem.getName().equalsIgnoreCase("th") && !elem.getName().equalsIgnoreCase("td")) continue;
                String dt = this.doc.getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset()).trim();
                if (trData.length() == 0) {
                    trData.append(this._qualifier + dt + this._qualifier);
                    continue;
                }
                trData.append(this._fieldSep + this._qualifier + dt + this._qualifier);
            }
            trData.append(this._preferredLineSep);
            out.write(trData.toString().getBytes());
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (Exception ex) {
            throw new AxionException(ex);
        }
    }

    static {
        PROPERTY_KEYS.add("FIELDDELIMITER");
        PROPERTY_KEYS.add("QUALIFIER");
        PROPERTY_KEYS.add(PROP_URL);
        PROPERTY_KEYS.add(PROP_REFRESH);
        PROPERTY_KEYS.add(PROP_TABLE_NO);
    }

    private class WebTableOrganizationContext
    extends BaseFlatfileTable.BaseFlatfileTableOrganizationContext {
        private WebTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            Set baseKeys = super.getPropertyKeys();
            HashSet keys = new HashSet(baseKeys.size() + PROPERTY_KEYS.size());
            keys.addAll(baseKeys);
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            props.put("LOADTYPE", "DELIMITED");
            super.readOrSetDefaultProperties(props);
            String rawFieldSep = props.getProperty("FIELDDELIMITER");
            if (WebTable.this.isNullString(rawFieldSep)) {
                rawFieldSep = ",";
            }
            WebTable.this._fieldSep = BaseFlatfileTable.fixEscapeSequence(rawFieldSep);
            String lineSep = System.getProperty("line.separator");
            if ("".equals(WebTable.this._lineSep)) {
                WebTable.this._lineSep = BaseFlatfileTable.fixEscapeSequence(lineSep);
            }
            StringTokenizer tokenizer = new StringTokenizer(WebTable.this._lineSep, " ");
            ArrayList<String> tmpList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                tmpList.add(token);
                if (!token.equals(lineSep)) continue;
                WebTable.this._preferredLineSep = token;
            }
            WebTable.this._lineSeps = tmpList.toArray(new String[0]);
            if (WebTable.this._preferredLineSep == null || WebTable.this._preferredLineSep.length() == 0) {
                WebTable.this._preferredLineSep = WebTable.this._lineSeps[0];
            }
            WebTable.this._qualifier = BaseFlatfileTable.fixEscapeSequence(props.getProperty("QUALIFIER"));
            if (WebTable.this.isNullString(WebTable.this._qualifier)) {
                WebTable.this._qualifier = "";
            } else {
                WebTable.this._qPattern = Pattern.compile(WebTable.this._qualifier);
                WebTable.this._qqPattern = Pattern.compile(WebTable.this._qualifier + WebTable.this._qualifier);
            }
            try {
                WebTable.this._tableNumber = Integer.parseInt(props.getProperty(WebTable.PROP_TABLE_NO).trim());
            }
            catch (NumberFormatException ex) {
                WebTable.this._tableNumber = 1;
            }
            WebTable.this.url = props.getProperty(WebTable.PROP_URL);
            WebTable.this._refresh = Boolean.valueOf(props.getProperty(WebTable.PROP_REFRESH, "false").trim());
            props.put("FILENAME", WebTable.this.getRootDir().getAbsoluteFile() + File.separator + "datafile.csv");
            WebTable.this._dataFile = new File(props.getProperty("FILENAME"));
            if (WebTable.this._refresh) {
                if (WebTable.this._dataFile.exists()) {
                    WebTable.this._dataFile.delete();
                }
                try {
                    WebTable.this._dataFile.createNewFile();
                    WebTable.this.createDataFile();
                }
                catch (IOException ex) {
                    throw new AxionException(ex);
                }
            }
            if (!WebTable.this._dataFile.exists()) {
                try {
                    WebTable.this._dataFile.createNewFile();
                    WebTable.this.createDataFile();
                }
                catch (IOException ex) {
                    throw new AxionException(ex);
                }
            }
        }

        public void updateProperties() {
            super.updateProperties();
            this._props.setProperty("LOADTYPE", "DELIMITED");
            this._props.setProperty("FIELDDELIMITER", BaseFlatfileTable.addEscapeSequence(WebTable.this._fieldSep));
            this._props.setProperty("QUALIFIER", WebTable.this._qualifier);
            this._props.setProperty(WebTable.PROP_URL, WebTable.this.url);
            this._props.setProperty(WebTable.PROP_TABLE_NO, String.valueOf(WebTable.this._tableNumber));
            this._props.setProperty(WebTable.PROP_REFRESH, String.valueOf(WebTable.this._refresh));
        }

        public Set getRequiredPropertyKeys() {
            Set baseRequiredKeys = this.getBaseRequiredPropertyKeys();
            HashSet keys = new HashSet(baseRequiredKeys.size() + REQUIRED_KEYS.size());
            keys.addAll(baseRequiredKeys);
            keys.addAll(REQUIRED_KEYS);
            return keys;
        }
    }
}

