/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.axiondb.AxionException;
import org.axiondb.Index;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowIterator;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.tables.BaseTable;
import org.axiondb.event.RowInsertedEvent;

public class MemoryTable
extends BaseTable {
    private int _freeIdPos = -1;
    private ArrayIntList _freeIds = new ArrayIntList();
    private int _nextFreeId = -1;
    private int _rowCount = 0;
    private ArrayList _rows = new ArrayList();

    public MemoryTable(String name) {
        super(name);
    }

    public MemoryTable(String name, String type) {
        super(name);
        this.setType(type);
    }

    public void applyDeletes(IntCollection rowids) throws AxionException {
        this.applyDeletesToIndices(rowids);
        this.applyDeletesToRows(rowids);
    }

    public void applyInserts(RowCollection rows) throws AxionException {
        this.applyInsertsToIndices(rows);
        this.applyInsertsToRows(rows.rowIterator());
    }

    public void applyUpdates(RowCollection rows) throws AxionException {
        this.applyUpdatesToIndices(rows);
        this.applyUpdatesToRows(rows.rowIterator());
    }

    public final void freeRowId(int id) {
        if (this._freeIdPos >= 0 && id == this._freeIds.get(this._freeIdPos)) {
            --this._freeIdPos;
        } else if (this._nextFreeId > this._rows.size() - 1) {
            --this._nextFreeId;
        }
    }

    public final int getNextRowId() {
        if (this._freeIds.isEmpty() || this._freeIdPos >= this._freeIds.size() - 1) {
            this._nextFreeId = this._nextFreeId == -1 ? this._rows.size() : this._nextFreeId + 1;
            return this._nextFreeId;
        }
        return this._freeIds.get(++this._freeIdPos);
    }

    public final Row getRow(int id) {
        if (id > this._rows.size() - 1 || id < 0) {
            return null;
        }
        return (Row)this._rows.get(id);
    }

    public final int getRowCount() {
        return this._rowCount;
    }

    public void populateIndex(Index index) throws AxionException {
        int I = this._rows.size();
        for (int i = 0; i < I; ++i) {
            Row row = (Row)this._rows.get(i);
            if (row == null) continue;
            index.rowInserted(new RowInsertedEvent(this, null, row));
        }
    }

    public void truncate() throws AxionException {
        this._rows.clear();
        this._freeIds.clear();
        this._rowCount = 0;
        this.truncateIndices();
    }

    protected RowIterator getRowIterator() throws AxionException {
        return new BaseRowIterator(){
            Row _current = null;
            int _currentId = -1;
            int _currentIndex = -1;
            int _nextId = 0;
            int _nextIndex = 0;

            public Row current() {
                if (!this.hasCurrent()) {
                    throw new NoSuchElementException("No current row.");
                }
                return this._current;
            }

            public final int currentIndex() {
                return this._currentIndex;
            }

            public final boolean hasCurrent() {
                return null != this._current;
            }

            public final boolean hasNext() {
                return this.nextIndex() < MemoryTable.this.getRowCount();
            }

            public final boolean hasPrevious() {
                return this.nextIndex() > 0;
            }

            public Row last() {
                if (this.isEmpty()) {
                    throw new IllegalStateException("No rows in table.");
                }
                this._nextIndex = MemoryTable.this.getRowCount();
                this._nextId = MemoryTable.this._rows.size();
                this.previous();
                ++this._nextIndex;
                ++this._nextId;
                return this.current();
            }

            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next row");
                }
                do {
                    ++this._nextId;
                    this._currentId = this._currentId;
                    this._current = MemoryTable.this.getRow(this._currentId);
                } while (null == this._current);
                this._currentIndex = this._nextIndex++;
                return this._current;
            }

            public final int nextIndex() {
                return this._nextIndex;
            }

            public Row previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous row");
                }
                do {
                    this._currentId = --this._nextId;
                    this._current = MemoryTable.this.getRow(this._currentId);
                } while (null == this._current);
                --this._nextIndex;
                this._currentIndex = this._nextIndex;
                return this._current;
            }

            public final int previousIndex() {
                return this._nextIndex - 1;
            }

            public void remove() throws AxionException {
                if (-1 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                MemoryTable.this.deleteRow(this._current);
                --this._nextIndex;
                this._currentIndex = -1;
            }

            public void reset() {
                this._current = null;
                this._nextIndex = 0;
                this._currentId = -1;
                this._currentIndex = -1;
                this._nextId = 0;
            }

            public final void set(Row row) throws AxionException {
                if (-1 == this._currentIndex) {
                    throw new IllegalStateException("No current row.");
                }
                MemoryTable.this.updateRow(this._current, row);
            }

            public final int size() throws AxionException {
                return MemoryTable.this.getRowCount();
            }

            public String toString() {
                return "MemoryTable(" + MemoryTable.this.getName() + ")";
            }
        };
    }

    private void applyDeleteToRow(int rowid) throws AxionException {
        if (rowid > this._rows.size() - 1) {
            throw new AxionException("Can't delete non-existent row");
        }
        this._rows.set(rowid, null);
        --this._rowCount;
    }

    private void applyDeletesToRows(IntCollection rowids) throws AxionException {
        IntIterator iter = rowids.iterator();
        while (iter.hasNext()) {
            this.applyDeleteToRow(iter.next());
        }
        this._freeIds.addAll(rowids);
    }

    private void applyInsertsToRows(RowIterator rows) throws AxionException {
        while (rows.hasNext()) {
            Row row = rows.next();
            if (!this._freeIds.isEmpty() && this._freeIdPos > -1) {
                this._rows.set(this._freeIds.removeElementAt(0), row);
                --this._freeIdPos;
            } else {
                this._rows.add(row);
            }
            ++this._rowCount;
        }
        this._nextFreeId = -1;
    }

    private void applyUpdatesToRows(RowIterator rows) throws AxionException {
        while (rows.hasNext()) {
            Row row = rows.next();
            if (row.getIdentifier() > this._rows.size() - 1) {
                throw new AxionException("Can't update non-existent row");
            }
            this._rows.set(row.getIdentifier(), row);
        }
    }
}

