/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.axiondb.AxionException;
import org.axiondb.Literal;
import org.axiondb.OrderNode;
import org.axiondb.Row;
import org.axiondb.RowComparator;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.engine.rowiterators.DelegatingRowIterator;
import org.axiondb.engine.rowiterators.ListRowIterator;
import org.axiondb.engine.rowiterators.RowIteratorRowDecoratorIterator;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.visitors.FindAggregateFunctionVisitor;
import org.axiondb.functions.AggregateFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.util.ComparatorChain;

public class GroupedRowIterator
extends DelegatingRowIterator {
    private Map _aggrFnValueCache;
    private Map _colIdToFieldMap;
    private List _groupByCols;
    private Selectable _having;
    private boolean[] _isAggregateFunction;
    private List _orderByNodes;
    private List _selected;
    private Selectable _where;
    private boolean _preSorted = true;

    public GroupedRowIterator(boolean sort, RowIterator rows, Map fieldMap, List groupBy, List selected, Selectable having, Selectable where, List orderBy) throws AxionException {
        super(null);
        this._colIdToFieldMap = fieldMap;
        this._groupByCols = groupBy;
        this._selected = selected;
        this._having = having;
        this._where = where;
        this._orderByNodes = orderBy;
        this._aggrFnValueCache = new HashMap(this._selected.size());
        SortedMap groupedRowMap = null;
        if (!this.isEmptyGroupBy() && sort) {
            groupedRowMap = this.doSort(rows);
        }
        this._isAggregateFunction = new boolean[this._selected.size() + 1];
        int I = this._selected.size();
        for (int i = 0; i < I; ++i) {
            this._isAggregateFunction[i] = this.isAggregateFunction(this._selected.get(i));
        }
        this._isAggregateFunction[this._selected.size()] = this.isAggregateFunction(this._having);
        List grList = null;
        grList = groupedRowMap == null ? this.makeGroupRows(rows) : this.makeGroupRows(groupedRowMap);
        this.setDelegate(new ListRowIterator(grList));
    }

    public GroupedRowIterator(RowIterator rows, Map fieldMap, List groupBy, List selected, Selectable having, List orderBy) throws AxionException {
        this(true, rows, fieldMap, groupBy, selected, having, null, orderBy);
    }

    public void add(Row row) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public void set(Row row) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public void remove() throws AxionException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(20);
        buf.append("Grouped(").append(this._groupByCols == null ? "" : this._groupByCols.toString());
        if (this._having != null) {
            buf.append("; having=").append(this._having).append(";");
        }
        buf.append("preSorted=").append(this._preSorted).append(")");
        return buf.toString();
    }

    private boolean acceptable(RowIterator currGroupRowIter, RowDecorator dec) throws AxionException {
        if (this._having == null) {
            return true;
        }
        if (this._isAggregateFunction[this._selected.size()]) {
            Object val = this.evaluateAggregateFunction(dec, (ConcreteFunction)this._having, currGroupRowIter);
            return (Boolean)val;
        }
        Boolean result = (Boolean)this._having.evaluate(dec);
        return result == null ? false : result;
    }

    private void addToCurrentGroup(RowDecorator dec, Row row, List currGroup) throws AxionException {
        if (this._where == null) {
            currGroup.add(row);
            return;
        }
        dec.setRow(row);
        Boolean result = (Boolean)this._where.evaluate(dec);
        if (result != null && result.booleanValue()) {
            currGroup.add(row);
        }
    }

    private SortedMap doSort(RowIterator rows) throws AxionException {
        ComparatorChain sortChain = this.generateOrderChain();
        TreeMap groupedRows = new TreeMap(sortChain);
        RowDecorator dec = new RowDecorator(this._colIdToFieldMap);
        while (rows.hasNext()) {
            Row row = rows.next();
            ArrayList currGroup = (ArrayList)groupedRows.get(row);
            if (currGroup == null) {
                currGroup = new ArrayList();
                groupedRows.put(row, currGroup);
            }
            this.addToCurrentGroup(dec, row, currGroup);
        }
        this._preSorted = false;
        return groupedRows;
    }

    private Object evaluateAggregateFunction(RowDecorator dec, ConcreteFunction fn, RowIterator rows) throws AxionException {
        if (fn instanceof AggregateFunction) {
            rows.reset();
            AggregateFunction vfn = (AggregateFunction)fn;
            Object val = this._aggrFnValueCache.get(vfn);
            if (val == null) {
                val = vfn.evaluate(new RowIteratorRowDecoratorIterator(rows, dec));
                this._aggrFnValueCache.put(vfn, val);
            }
            return val;
        }
        ArrayList<Selectable> fnArgs = new ArrayList<Selectable>(fn.getArgumentCount());
        int I = fn.getArgumentCount();
        for (int i = 0; i < I; ++i) {
            Selectable arg = fn.getArgument(i);
            fnArgs.add(i, arg);
            if (!(arg instanceof ConcreteFunction)) continue;
            ConcreteFunction innerFn = (ConcreteFunction)arg;
            Object val = this.evaluateAggregateFunction(dec, innerFn, rows);
            fn.setArgument(i, new Literal(val, ((ConcreteFunction)arg).getDataType()));
        }
        if (dec.getRow() == null) {
            dec.setRow(rows.first());
        }
        Object val = fn.evaluate(dec);
        int I2 = fn.getArgumentCount();
        for (int i = 0; i < I2; ++i) {
            fn.setArgument(i, (Selectable)fnArgs.get(i));
        }
        return val;
    }

    private ComparatorChain generateOrderChain() {
        ComparatorChain chain = new ComparatorChain();
        int I = this._groupByCols.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)this._groupByCols.get(i);
            if (this.isDescending(sel, this._orderByNodes)) {
                chain.setReverseSort(i);
            }
            chain.addComparator(new RowComparator(sel, new RowDecorator(this._colIdToFieldMap)));
        }
        return chain;
    }

    private boolean isAggregateFunction(Object sel) {
        if (sel instanceof ConcreteFunction) {
            FindAggregateFunctionVisitor findAggr = new FindAggregateFunctionVisitor();
            findAggr.visit((Selectable)sel);
            if (findAggr.foundAggregateFunction()) {
                return true;
            }
        }
        return false;
    }

    private boolean isDescending(Selectable sel, List orderNodes) {
        if (null != orderNodes && null != sel) {
            for (OrderNode node : orderNodes) {
                if (!node.getSelectable().equals(sel)) continue;
                return node.isDescending();
            }
        }
        return false;
    }

    private boolean isEmptyGroupBy() {
        return this._groupByCols == null || this._groupByCols.isEmpty();
    }

    private Row makeGroupRow(List currGroup, RowDecorator dec, Row row) throws AxionException {
        ArrayList myCurrGroup = new ArrayList(currGroup);
        ListRowIterator currGroupRowIter = new ListRowIterator(myCurrGroup);
        dec.setRow(row);
        this._aggrFnValueCache.clear();
        if (this.acceptable(currGroupRowIter, dec)) {
            return this.makeGroupRow(currGroupRowIter, dec);
        }
        return null;
    }

    private Row makeGroupRow(RowIterator currGroupRowIter, RowDecorator dec) throws AxionException {
        SimpleRow rowOut = new SimpleRow(this._selected.size());
        int I = this._selected.size();
        for (int i = 0; i < I; ++i) {
            if (this._isAggregateFunction[i]) {
                rowOut.set(i, this.evaluateAggregateFunction(dec, (ConcreteFunction)this._selected.get(i), currGroupRowIter));
                continue;
            }
            rowOut.set(i, ((Selectable)this._selected.get(i)).evaluate(dec));
        }
        return rowOut;
    }

    private List makeGroupRows(RowIterator rows) throws AxionException {
        if (this._groupByCols != null && !this._groupByCols.isEmpty() && !rows.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<RowComparator> comparators = new ArrayList<RowComparator>();
        if (this._groupByCols != null && !this._groupByCols.isEmpty()) {
            RowDecorator dec = new RowDecorator(this._colIdToFieldMap);
            int I = this._groupByCols.size();
            for (int i = 0; i < I; ++i) {
                comparators.add(new RowComparator((Selectable)this._groupByCols.get(i), dec));
            }
        }
        ArrayList<Row> groupedRows = new ArrayList<Row>();
        ArrayList currGroup = new ArrayList();
        RowDecorator dec = new RowDecorator(this._colIdToFieldMap);
        Row lastRow = null;
        if (rows.hasNext() && !comparators.isEmpty()) {
            lastRow = rows.next();
            this.addToCurrentGroup(dec, lastRow, currGroup);
            while (rows.hasNext()) {
                Row row = rows.next();
                int I = comparators.size();
                for (int i = 0; i < I && !currGroup.isEmpty(); ++i) {
                    RowComparator comp = (RowComparator)comparators.get(i);
                    if (comp.compare(lastRow, row) == 0) continue;
                    Row groupdRow = this.makeGroupRow(currGroup, dec, lastRow);
                    if (groupdRow != null) {
                        groupedRows.add(groupdRow);
                    }
                    currGroup.clear();
                    break;
                }
                this.addToCurrentGroup(dec, row, currGroup);
                lastRow = row;
            }
            Row groupdRow = this.makeGroupRow(currGroup, dec, lastRow);
            if (groupdRow != null) {
                groupedRows.add(groupdRow);
            }
        } else {
            groupedRows.add(this.makeGroupRow(rows, dec));
        }
        return groupedRows;
    }

    private List makeGroupRows(SortedMap groupedRowMap) throws AxionException {
        if (this._groupByCols != null && groupedRowMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Row> groupedRows = new ArrayList<Row>();
        List currGroup2 = new ArrayList();
        RowDecorator dec = new RowDecorator(this._colIdToFieldMap);
        for (List currGroup2 : groupedRowMap.values()) {
            Row groupdRow = this.makeGroupRow(currGroup2, dec, (Row)currGroup2.get(0));
            if (groupdRow == null) continue;
            groupedRows.add(groupdRow);
        }
        return groupedRows;
    }
}

