/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowComparator;
import org.axiondb.RowIterator;
import org.axiondb.engine.rowiterators.BaseRowIterator;

public class CollatingRowIterator
extends BaseRowIterator {
    private RowComparator _comparator;
    private int _currentIndex = -1;
    private Row _currentRow;
    private boolean _hasCurrent = false;
    private ArrayList _iterators;
    private int _lastReturnedFrom = -1;
    private boolean _nextAvailable = false;
    private int _nextIndex = 0;
    private Row[] _nextValues;
    private boolean _previousAvailable = false;
    private Row[] _previousValues;
    private boolean _started = false;

    public CollatingRowIterator(RowComparator comparator) {
        this._comparator = comparator;
        this._iterators = new ArrayList(3);
    }

    public void addRowIterator(RowIterator iter) throws IllegalStateException {
        this.assertNotStarted();
        this._iterators.add(iter);
    }

    public Row current() {
        if (!this.hasCurrent()) {
            throw new NoSuchElementException("No current row");
        }
        return this._currentRow;
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public boolean hasCurrent() {
        return this._hasCurrent;
    }

    public boolean hasNext() {
        this.start();
        return this.anyNextAvailable() || this.anyIteratorHasNext();
    }

    public boolean hasPrevious() {
        this.start();
        return this.anyPreviousAvailable() || this.anyIteratorHasPrevious();
    }

    public Row last() throws AxionException {
        if (this._started) {
            this.clearPreviousPeeked();
            this.clearNextPeeked();
        }
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            ((RowIterator)this._iterators.get(i)).last();
        }
        this._nextIndex = this.size();
        this._currentIndex = this._nextIndex - 1;
        this._hasCurrent = true;
        this._currentRow = this.peekPrevious();
        return this._currentRow;
    }

    public Row next() throws AxionException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next row");
        }
        this._currentIndex = this._nextIndex++;
        this._hasCurrent = true;
        this._currentRow = this.peekNextRow();
        return this._currentRow;
    }

    public int nextIndex() {
        return this._nextIndex;
    }

    public Row previous() throws AxionException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No previous row");
        }
        this._currentIndex = this._nextIndex - 1;
        --this._nextIndex;
        this._hasCurrent = true;
        this._currentRow = this.peekPreviousRow();
        return this._currentRow;
    }

    public int previousIndex() {
        return this._nextIndex - 1;
    }

    public void remove() throws AxionException {
        if (!this.hasCurrent()) {
            throw new NoSuchElementException("No current row");
        }
        RowIterator iter = this.getLastReturnedFrom();
        iter.remove();
        this._currentRow = null;
        this._currentIndex = -1;
        this._hasCurrent = false;
    }

    public void reset() throws AxionException {
        this.start();
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            this.clearNextPeeked(i);
            this.clearPreviousPeeked(i);
            ((RowIterator)this._iterators.get(i)).reset();
        }
        this._currentRow = null;
        this._currentIndex = -1;
        this._hasCurrent = false;
        this._nextIndex = 0;
        this._lastReturnedFrom = -1;
    }

    public void set(Row row) throws AxionException {
        if (!this.hasCurrent()) {
            throw new NoSuchElementException("No current row");
        }
        RowIterator iter = this.getLastReturnedFrom();
        iter.set(row);
        this._currentRow = row;
    }

    public String toString() {
        return "Collating(" + this._iterators + ")";
    }

    public int size() throws AxionException {
        int size = 0;
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            size += ((RowIterator)this._iterators.get(i)).size();
        }
        return size;
    }

    private boolean anyIteratorHasNext() {
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            RowIterator it = (RowIterator)this._iterators.get(i);
            if (!it.hasNext()) continue;
            return true;
        }
        return false;
    }

    private boolean anyIteratorHasPrevious() {
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            RowIterator it = (RowIterator)this._iterators.get(i);
            if (!it.hasPrevious()) continue;
            return true;
        }
        return false;
    }

    private boolean anyNextAvailable() {
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            if (!this.isValueSet(this._nextValues[i])) continue;
            return true;
        }
        return false;
    }

    private boolean anyPreviousAvailable() {
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            if (!this.isValueSet(this._previousValues[i])) continue;
            return true;
        }
        return false;
    }

    private void assertNotStarted() throws IllegalStateException {
        if (this._started) {
            throw new IllegalStateException("Already started");
        }
    }

    private void clearNextPeeked() throws AxionException {
        int m = this._iterators.size();
        for (int i = 0; i < m; ++i) {
            if (!this.isValueSet(this._nextValues[i])) continue;
            ((RowIterator)this._iterators.get(i)).previous();
            this.clearNextPeeked(i);
        }
        this._nextAvailable = false;
    }

    private void clearNextPeeked(int i) {
        this._nextValues[i] = null;
    }

    private void clearPreviousPeeked() throws AxionException {
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            if (!this.isValueSet(this._previousValues[i])) continue;
            ((RowIterator)this._iterators.get(i)).next();
            this.clearPreviousPeeked(i);
        }
        this._previousAvailable = false;
    }

    private void clearPreviousPeeked(int i) {
        this._previousValues[i] = null;
    }

    private RowIterator getLastReturnedFrom() throws IllegalStateException {
        return (RowIterator)this._iterators.get(this._lastReturnedFrom);
    }

    private boolean isValueSet(Object val) {
        return val != null;
    }

    private Row peekNextRow() throws AxionException {
        this._nextAvailable = true;
        if (this._previousAvailable) {
            this.clearPreviousPeeked();
        }
        int nextIndex = -1;
        Row nextValue = null;
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            if (this._nextValues[i] == null) {
                RowIterator iter = (RowIterator)this._iterators.get(i);
                if (!iter.hasNext()) continue;
                this._nextValues[i] = iter.next();
            }
            if (-1 == nextIndex) {
                nextIndex = i;
                nextValue = this._nextValues[i];
                continue;
            }
            if (this._comparator.compare(nextValue, this._nextValues[i]) <= 0) continue;
            nextIndex = i;
            nextValue = this._nextValues[i];
        }
        this._lastReturnedFrom = nextIndex;
        this.clearNextPeeked(nextIndex);
        return nextValue;
    }

    private Row peekPreviousRow() throws AxionException {
        this._previousAvailable = true;
        if (this._nextAvailable) {
            this.clearNextPeeked();
        }
        int previousIndex = -1;
        Row previousValue = null;
        int I = this._iterators.size();
        for (int i = 0; i < I; ++i) {
            if (this._previousValues[i] == null) {
                RowIterator iter = (RowIterator)this._iterators.get(i);
                if (!iter.hasPrevious()) continue;
                this._previousValues[i] = iter.previous();
            }
            if (-1 == previousIndex) {
                previousIndex = i;
                previousValue = this._previousValues[i];
                continue;
            }
            if (this._comparator.compare(previousValue, this._previousValues[i]) > 0) continue;
            previousIndex = i;
            previousValue = this._previousValues[i];
        }
        this._lastReturnedFrom = previousIndex;
        this.clearPreviousPeeked(previousIndex);
        return previousValue;
    }

    private void start() {
        if (!this._started) {
            int isize = this._iterators.size();
            this._nextValues = new Row[isize];
            this._previousValues = new Row[isize];
            this._started = true;
        }
    }
}

