/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowIterator;

public abstract class BaseRowIterator
implements RowIterator {
    public void add(Row row) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public abstract Row current() throws NoSuchElementException;

    public abstract int currentIndex() throws NoSuchElementException;

    public Row first() throws AxionException {
        this.reset();
        return this.peekNext();
    }

    public abstract boolean hasCurrent();

    public abstract boolean hasNext();

    public abstract boolean hasPrevious();

    public boolean isEmpty() {
        return !this.hasNext() && !this.hasPrevious();
    }

    public Row last() throws AxionException {
        if (!this.hasNext()) {
            this.previous(1);
        }
        while (this.hasNext()) {
            this.next(1);
        }
        return this.current();
    }

    public abstract Row next() throws NoSuchElementException, AxionException;

    public int next(int count) throws AxionException {
        for (int i = 0; i < count; ++i) {
            this.next();
        }
        return this.current().getIdentifier();
    }

    public abstract int nextIndex();

    public Row peekNext() throws AxionException {
        this.next(1);
        return this.previous();
    }

    public Row peekPrevious() throws AxionException {
        this.previous(1);
        return this.next();
    }

    public abstract Row previous() throws NoSuchElementException, AxionException;

    public int previous(int count) throws AxionException {
        for (int i = 0; i < count; ++i) {
            this.previous();
        }
        return this.current().getIdentifier();
    }

    public abstract int previousIndex();

    public void remove() throws AxionException {
        throw new UnsupportedOperationException();
    }

    public abstract void reset() throws AxionException;

    public void set(Row row) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public int size() throws AxionException {
        this.reset();
        int count = 0;
        while (this.hasNext()) {
            this.next(1);
            ++count;
        }
        return count;
    }
}

