/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.indexes;

import java.io.File;
import java.io.IOException;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.DataType;
import org.axiondb.IndexLoader;
import org.axiondb.engine.StringBTreeIndexLoader;
import org.axiondb.engine.indexes.ObjectBTreeIndex;
import org.axiondb.util.NullObject;
import org.axiondb.util.ObjectBTree;
import org.axiondb.util.StringBTree;

public class StringBTreeIndex
extends ObjectBTreeIndex {
    private static final IndexLoader LOADER = new StringBTreeIndexLoader();

    public StringBTreeIndex(String name, Column column, boolean unique) throws AxionException {
        this(name, column, unique, 1000);
    }

    public StringBTreeIndex(String name, Column column, boolean unique, int minimizationFactor) throws AxionException {
        this(name, column, unique, minimizationFactor, null);
    }

    public StringBTreeIndex(String name, Column column, boolean unique, int minimizationFactor, File dataDirectory) throws AxionException {
        super(name, column, unique, dataDirectory);
        this._minimizationFactor = minimizationFactor;
    }

    public IndexLoader getIndexLoader() {
        return LOADER;
    }

    public int getMinimizationFactor() {
        return this._minimizationFactor;
    }

    protected ObjectBTree createTree(File dataDirectory, String name, int minimizationFactor, DataType dataType) throws IOException, ClassNotFoundException {
        return new StringBTree(dataDirectory, name, minimizationFactor, dataType);
    }

    protected Object getNullKey() {
        return NullObject.INSTANCE.toString();
    }
}

