/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Table;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.engine.commands.DropCommand;
import org.axiondb.engine.tables.TableView;

public class DropTableCommand
extends DropCommand {
    public DropTableCommand(String tableName, boolean exists, boolean cascade) {
        this.setObjectName(tableName);
        this.setIfExists(exists);
        this.setCascade(cascade);
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (!this.isIfExists() || db.hasTable(this.getObjectName())) {
            Table t = db.getTable(this.getObjectName());
            if (t != null && !t.getType().equals(TableView.VIEW) && !t.getType().equals("SYSTEM TABLE")) {
                this.checkConstraint(db, t);
                List depedentViews = db.getDependentViews(this.getObjectName());
                this.dropDepedentViews(db, depedentViews);
                db.dropTable(this.getObjectName());
            } else {
                throw new AxionException("No table " + this.getObjectName() + " found");
            }
        }
        return false;
    }

    private void dropDepedentViews(Database db, List depedentViews) throws AxionException {
        if (depedentViews.size() > 0) {
            if (this.isCascade()) {
                db.dropDependentViews(depedentViews);
            } else {
                throw new AxionException("Can't drop table: " + this.getObjectName() + " has reference in another View...");
            }
        }
    }

    private void checkConstraint(Database db, Table table) throws AxionException {
        Iterator iter = table.getConstraints();
        while (iter.hasNext()) {
            ForeignKeyConstraint fk;
            Object constraint = iter.next();
            if (!(constraint instanceof ForeignKeyConstraint) || (fk = (ForeignKeyConstraint)constraint).getParentTableName().equals(fk.getChildTableName())) continue;
            if (table.getName().equals(fk.getChildTableName())) {
                Table parentTable = db.getTable(fk.getParentTableName());
                parentTable.removeConstraint(fk.getName());
                continue;
            }
            if (this.isCascade() && table.getName().equals(fk.getParentTableName())) {
                Table childTable = db.getTable(fk.getChildTableName());
                childTable.removeConstraint(fk.getName());
                continue;
            }
            throw new AxionException("Child table exist, can't drop");
        }
    }
}

