/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Table;
import org.axiondb.TransactableTable;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.engine.tables.BaseDiskTable;
import org.axiondb.engine.tables.ExternalDatabaseTable;
import org.axiondb.jdbc.AxionResultSet;

public class DefragCommand
extends BaseAxionCommand {
    private String _tableName;

    public int executeUpdate(Database db) throws AxionException {
        if (this._tableName == null) {
            throw new AxionException("Table name can't be null");
        }
        if (this.isDiskTable(db, this._tableName)) {
            return db.defragTable(this._tableName);
        }
        return 0;
    }

    public boolean execute(Database db) throws AxionException {
        this.executeUpdate(db);
        return false;
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use execute.");
    }

    public void setObjectName(String tableName) {
        this._tableName = tableName;
    }

    private boolean isDiskTable(Database db, String tableName) throws AxionException {
        boolean ret = false;
        Table table = db.getTable(tableName);
        if (table == null) {
            throw new AxionException("Table not found." + tableName);
        }
        if (!(table instanceof ExternalDatabaseTable)) {
            while (table instanceof TransactableTable) {
                table = ((TransactableTable)table).getTable();
            }
            if (table instanceof BaseDiskTable) {
                ret = true;
            }
        }
        return ret;
    }
}

