/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.math.BigInteger;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Sequence;
import org.axiondb.engine.commands.CreateCommand;

public class CreateSequenceCommand
extends CreateCommand {
    private BigInteger _startVal = BigInteger.valueOf(-1L);
    private BigInteger _incrementBy = BigInteger.valueOf(1L);
    private BigInteger _maxValue = BigInteger.valueOf(Integer.MAX_VALUE);
    private BigInteger _minValue = BigInteger.valueOf(0L);
    private boolean _isCycle = false;
    private String _identityType;
    private String _typeName = "INTEGER";

    public CreateSequenceCommand() {
    }

    public CreateSequenceCommand(String sequenceName, int startVal) {
        this.setObjectName(sequenceName);
        this._startVal = BigInteger.valueOf(startVal);
    }

    public void setStartValue(String value) {
        this._startVal = new BigInteger(value, Sequence.RADIX);
    }

    public void setIncrementBy(String incrementBy) {
        this._incrementBy = new BigInteger(incrementBy, Sequence.RADIX);
    }

    public void setMaxValue(String maxValue) {
        this._maxValue = new BigInteger(maxValue, Sequence.RADIX);
    }

    public void setMinValue(String minValue) {
        this._minValue = new BigInteger(minValue, Sequence.RADIX);
    }

    public void setCycle(boolean cycle) {
        this._isCycle = cycle;
    }

    public void setDataType(String typeName) {
        this._typeName = typeName;
    }

    public void setIdentityType(String type) {
        this._identityType = type;
    }

    public String getIdentityType() {
        return this._identityType;
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (!db.hasSequence(this.getObjectName())) {
            db.createSequence(this.createSequence(db));
        } else if (!this.isIfNotExists()) {
            throw new AxionException("A sequence named \"" + this.getObjectName() + "\" already exists.");
        }
        return false;
    }

    private void validate(DataType type) throws AxionException {
        int precision = type.getPrecision();
        if (this._maxValue.toString(10).length() > precision) {
            throw new AxionException("Invalid MaxValue");
        }
    }

    public Sequence createSequence(Database db) throws AxionException {
        DataType type = db.getDataType(this._typeName);
        this.validate(type);
        if (this._startVal.signum() == -1) {
            this._startVal = this._incrementBy.signum() == -1 ? this._maxValue : this._minValue;
        }
        return new Sequence(this.getObjectName(), type, this._startVal, this._incrementBy, this._maxValue, this._minValue, this._isCycle);
    }
}

