/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.FromNode;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.Literal;
import org.axiondb.OrderNode;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.TransactableTableImpl;
import org.axiondb.engine.commands.AxionQueryContext;
import org.axiondb.engine.commands.AxionQueryOptimizer;
import org.axiondb.engine.rowiterators.AbstractJoinedRowIterator;
import org.axiondb.engine.rowiterators.ChangingIndexedRowIterator;
import org.axiondb.engine.rowiterators.DistinctRowIterator;
import org.axiondb.engine.rowiterators.FilteringChangingIndexedRowIterator;
import org.axiondb.engine.rowiterators.FilteringRowIterator;
import org.axiondb.engine.rowiterators.GroupedRowIterator;
import org.axiondb.engine.rowiterators.IndexNestedLoopJoinedRowIterator;
import org.axiondb.engine.rowiterators.LimitingRowIterator;
import org.axiondb.engine.rowiterators.ListRowIterator;
import org.axiondb.engine.rowiterators.MutableIndexedRowIterator;
import org.axiondb.engine.rowiterators.NestedLoopJoinedRowIterator;
import org.axiondb.engine.rowiterators.ReverseSortedRowIterator;
import org.axiondb.engine.rowiterators.SingleRowIterator;
import org.axiondb.engine.rowiterators.SortedRowIterator;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.ExternalDatabaseTable;
import org.axiondb.engine.tables.TableView;
import org.axiondb.functions.ComparisonFunction;
import org.axiondb.functions.EqualFunction;
import org.axiondb.util.ValuePool;

public class AxionQueryPlanner {
    private Map _colIdToFieldMap = new HashMap();
    private AxionQueryContext _context;
    private List _literals;
    private RowDecorator _parentRow;
    private Set _unappliedWhereNodes = new LinkedHashSet();
    private Set _unappliedTableFilters = new LinkedHashSet();
    private boolean _isAllInnerJoin = false;
    private AxionQueryPlanNode _planNode = new AxionQueryPlanNode();
    private boolean _skipSorting = false;
    private boolean _doReverseSorting = false;
    private boolean _wasIndexUsedForGroupBy = false;

    public AxionQueryPlanner(AxionQueryContext context) {
        this._context = context;
    }

    public Map getColumnIdToFieldMap() {
        return this._colIdToFieldMap;
    }

    public RowIterator getPlanNodeRowIterator() {
        return this._planNode.getRowIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator makeRowIterator(Database db, boolean readOnly) throws AxionException {
        if (db.isReadOnly()) {
            readOnly = true;
        }
        RowIterator rows = null;
        AxionQueryContext context = this.getContext();
        this._literals = context.createLiteralList();
        this._parentRow = context.getParentRow();
        try {
            rows = context.getTableCount() == 0 ? this.processQueryWithNoTable(context) : (context.getTableCount() == 1 ? this.processQueryForSingleTable(db, readOnly, context) : this.processQuery(db, readOnly, context));
            rows = this.makeGroupedRowIterator(db, rows, context, this.getColumnIdToFieldMap());
            if (context.foundAggregateFunction()) {
                this.resolveSelectedAfterGrouping(context, this.getColumnIdToFieldMap());
            }
            rows = this.makeDistinctRowIterator(rows, context);
            rows = this.makeOrderedRowIterator(db, rows, this.getColumnIdToFieldMap(), context);
            rows = this.makeLimitingRowIterator(rows, context, this.getColumnIdToFieldMap());
        }
        finally {
            this.dropViewIfSubQuery(context.getFrom(), db);
        }
        return rows;
    }

    private void addExplainRow(RowIterator rows) {
        if (this._context.isExplain()) {
            this._planNode.addExplainRow(rows.toString());
        }
    }

    private Map clearAndGetColumnIdToFieldMap() {
        this._colIdToFieldMap.clear();
        return this._colIdToFieldMap;
    }

    private RowIterator createDynamicIndex(Database db, Table table, ColumnIdentifier columnId) throws AxionException {
        Column column = table.getColumn(columnId.getName());
        if (table.getIndexForColumn(column) == null) {
            Index index = db.getIndexFactory("default").makeNewSystemInstance(table, column, db.getDBDirectory() == null);
            db.addIndex(index, table, true);
            if (table instanceof ExternalDatabaseTable) {
                index = table.getIndexForColumn(column);
            }
            return new ChangingIndexedRowIterator(index, table, new EqualFunction());
        }
        return null;
    }

    private void createDynamicIndex(FromNode from, JoinCondition joinCondition, QueryPlannerJoinContext joinContext, Database db) throws AxionException {
        TableIdentifier ltid;
        Table leftTable;
        if (!from.isRightJoin() && from.getRight() instanceof TableIdentifier && !joinContext.swapRightToLeft()) {
            TableIdentifier rtid = (TableIdentifier)from.getRight();
            Table rightTable = db.getTable(rtid);
            if (!this.isTableView(rightTable)) {
                this.createDynamicIndexOnRightTable(from, rtid, joinCondition, joinContext, db, rightTable);
            }
        } else if (!from.isLeftJoin() && from.getLeft() instanceof TableIdentifier && !this.isTableView(leftTable = db.getTable(ltid = (TableIdentifier)from.getLeft()))) {
            this.createDynamicIndexOnLeftTable(from, ltid, joinCondition, joinContext, db, leftTable);
        }
    }

    private void createDynamicIndexOnLeftTable(FromNode from, TableIdentifier ltid, JoinCondition joinCondition, QueryPlannerJoinContext joinContext, Database db, Table table) throws AxionException {
        EqualFunction fn = AxionQueryOptimizer.findFirstEqualFunction(joinCondition.getNodes(), ltid, table, false);
        if (fn != null && !fn.getArgument(0).equals(fn.getArgument(1))) {
            ColumnIdentifier columnId;
            RowIterator leftIter;
            joinContext.setLeftTableKey((ColumnIdentifier)fn.getArgument(0));
            joinContext.setRightTablekey((ColumnIdentifier)fn.getArgument(1));
            if (!ltid.equals(joinContext.getLeftTableKey().getTableIdentifier())) {
                joinContext.flipKey();
            }
            if ((leftIter = this.createDynamicIndex(db, table, columnId = joinContext.getLeftTableKey())) != null) {
                this.addExplainRow(leftIter);
                joinContext.setLeftIterator(leftIter);
                this.swapKeyForSortingIfUSedInOrderByOrGroupBy(joinContext.getLeftTableKey(), joinContext.getRightTablekey());
                joinContext.setRowsAreSortedByJoinKey(true);
                joinCondition.getNodes().remove(fn);
                this.pushUnwantedConditions(from, joinCondition, ltid);
            }
        }
    }

    private void createDynamicIndexOnRightTable(FromNode from, TableIdentifier rtid, JoinCondition joinCondition, QueryPlannerJoinContext joinContext, Database db, Table table) throws AxionException {
        EqualFunction fn = AxionQueryOptimizer.findFirstEqualFunction(joinCondition.getNodes(), rtid, table, false);
        if (fn != null && !fn.getArgument(0).equals(fn.getArgument(1))) {
            ColumnIdentifier columnId;
            RowIterator rightIter;
            joinContext.setLeftTableKey((ColumnIdentifier)fn.getArgument(0));
            joinContext.setRightTablekey((ColumnIdentifier)fn.getArgument(1));
            if (!rtid.equals(joinContext.getRightTablekey().getTableIdentifier())) {
                joinContext.flipKey();
            }
            if ((rightIter = this.createDynamicIndex(db, table, columnId = joinContext.getRightTablekey())) != null) {
                this.addExplainRow(rightIter);
                joinContext.setRightIterator(rightIter);
                this.swapKeyForSortingIfUSedInOrderByOrGroupBy(joinContext.getRightTablekey(), joinContext.getLeftTableKey());
                joinContext.setRowsAreSortedByJoinKey(true);
                joinCondition.getNodes().remove(fn);
                this.pushUnwantedConditions(from, joinCondition, rtid);
            }
        }
    }

    private void dropViewIfSubQuery(FromNode from, Database db) throws AxionException {
        if (from == null) {
            return;
        }
        this.dropViewIfSubQuery(from.getLeft(), db);
        this.dropViewIfSubQuery(from.getRight(), db);
    }

    private void dropViewIfSubQuery(Object child, Database db) throws AxionException {
        if (child instanceof TableIdentifier) {
            TableIdentifier tid = (TableIdentifier)child;
            Table view = db.getTable(tid);
            if (view instanceof TransactableTableImpl) {
                view = ((TransactableTableImpl)view).getTable();
            }
            if (view instanceof TableView && ((TableView)view).getType().equals(TableView.SUBQUERY)) {
                db.dropTable(tid.getTableName());
            }
        } else if (child instanceof FromNode) {
            this.dropViewIfSubQuery((FromNode)child, db);
        }
    }

    private AxionQueryContext getContext() {
        return this._context;
    }

    private RowIterator getIndexedRows(Set conditions, ColumnIdentifier cid, Table table, boolean readOnly) throws AxionException {
        RowIterator rows = null;
        Function fn = AxionQueryOptimizer.findColumnLiteralFunction(cid.getTableIdentifier(), table, conditions, true);
        if (fn != null) {
            rows = table.getIndexedRows(fn, readOnly);
        }
        if (rows == null) {
            rows = table.getIndexedRows(cid, readOnly);
        }
        return rows;
    }

    private RowIterator getIndexedRowsIfSortingRequired(RowIterator rows, AxionQueryContext context, Table table, boolean readOnly, Set conditions) throws AxionException {
        OrderNode node;
        Selectable ordCol;
        ColumnIdentifier grpCol;
        if (null == rows && context.getGroupByCount() == 1 && (rows = this.getIndexedRows(conditions, grpCol = (ColumnIdentifier)context.getGroupBy(0), table, readOnly)) != null) {
            this.setIndexUsedForGroupBy(true);
            this.addExplainRow(rows);
        }
        if (null == rows && context.getOrderByCount() == 1 && (ordCol = (node = context.getOrderBy(0)).getSelectable()) instanceof ColumnIdentifier && (rows = this.getIndexedRows(conditions, (ColumnIdentifier)ordCol, table, readOnly)) != null) {
            this.setSkipSorting(true);
            this.addExplainRow(rows);
        }
        return rows;
    }

    private RowIterator getRowIteratorFromTable(Database db, TableIdentifier tid, Table table, RowIterator rows, boolean readOnly, Set conditions) throws AxionException {
        if (rows != null) {
            return rows;
        }
        Function fn = AxionQueryOptimizer.findColumnLiteralFunction(tid, table, conditions, true);
        if (fn != null && (rows = table.getIndexedRows(fn, readOnly)) != null) {
            conditions.remove(fn);
            this.addExplainRow(rows);
        }
        if (null == rows) {
            rows = table.getRowIterator(readOnly);
            this.addExplainRow(rows);
        }
        return rows;
    }

    private boolean wasSortedWhileGrouping(List groupByColumns, List orderByColumns, boolean isDescending) throws AxionException {
        int groupByCount = groupByColumns.size();
        int orderByCount = orderByColumns.size();
        if (groupByCount == 0 || groupByCount < orderByCount) {
            return false;
        }
        if (this.wasIndexUsedForGroupBy() && isDescending) {
            this._doReverseSorting = true;
        }
        return ((Object)groupByColumns).equals(orderByColumns);
    }

    private boolean isSortingRequired(AxionQueryContext context) throws AxionException {
        int orderByCount = context.getOrderByCount();
        int groupByCount = context.getGroupByCount();
        if (orderByCount == 0) {
            this._doReverseSorting = false;
            return false;
        }
        ArrayList<Selectable> orderByColumns = new ArrayList<Selectable>();
        boolean isDescending = true;
        for (int i = 0; i < orderByCount; ++i) {
            OrderNode node = context.getOrderBy(i);
            isDescending = node.isDescending() && isDescending;
            orderByColumns.add(node.getSelectable());
        }
        if (this.skipSorting() && isDescending) {
            this._doReverseSorting = true;
        }
        ArrayList groupByColumns = Collections.EMPTY_LIST;
        if (groupByCount > orderByCount) {
            groupByColumns = new ArrayList(context.getGroupBy().subList(0, context.getOrderByCount()));
        } else if (groupByCount > 0) {
            groupByColumns = context.getGroupBy();
        }
        return !this.skipSorting() && !this.wasSortedWhileGrouping(groupByColumns, orderByColumns, isDescending);
    }

    private boolean isTableView(Table table) {
        if (table instanceof TransactableTableImpl) {
            table = ((TransactableTableImpl)table).getTable();
        }
        return table instanceof TableView;
    }

    private RowIterator makeChangingIndexedRowIterator(Table table, Index index) throws AxionException {
        ChangingIndexedRowIterator iter = new ChangingIndexedRowIterator(index, table, new EqualFunction());
        this.addExplainRow(iter);
        return iter;
    }

    private RowIterator makeDistinctRowIterator(RowIterator rows, AxionQueryContext context) {
        if (context.getDistinct()) {
            rows = new DistinctRowIterator(rows, this.getColumnIdToFieldMap(), context.getSelected());
            this.addExplainRow(rows);
        }
        return rows;
    }

    private RowIterator makeFilteringRowIterator(TableIdentifier tid, Table table, RowIterator rows, AxionQueryContext context, Set conditions) throws AxionException {
        Iterator tableFilterIt = conditions.iterator();
        while (tableFilterIt.hasNext()) {
            HashMap localmap = new HashMap();
            ArrayList columns = new ArrayList();
            this.populateColumnList(columns, tid, table, context);
            this.populateColumnIdToFieldMap(columns, localmap);
            Selectable node = (Selectable)tableFilterIt.next();
            if (!AxionQueryOptimizer.onlyReferencesTable(tid, node)) continue;
            rows = rows instanceof MutableIndexedRowIterator ? new FilteringChangingIndexedRowIterator((MutableIndexedRowIterator)rows, new RowDecorator(localmap), node) : new FilteringRowIterator(rows, new RowDecorator(localmap), node);
            tableFilterIt.remove();
            this.addExplainRow(rows);
        }
        return rows;
    }

    private RowIterator makeGroupedIndexBasedRowIterator(boolean readOnly, AxionQueryContext context, Table table) throws AxionException {
        ColumnIdentifier cid = (ColumnIdentifier)context.getGroupBy(0);
        RowIterator rows = table.getIndexedRows(cid, readOnly);
        if (rows != null) {
            this.setIndexUsedForGroupBy(true);
            this.addExplainRow(rows);
            rows = new GroupedRowIterator(false, rows, this.getColumnIdToFieldMap(), context.getGroupBy(), context.getSelect(), context.getHaving(), context.getWhere(), context.getOrderBy());
            this.addExplainRow(rows);
        }
        return rows;
    }

    private RowIterator makeGroupedRowIterator(Database db, RowIterator rows, AxionQueryContext context, Map colIdToFieldMap) throws AxionException {
        GroupedRowIterator grpRows = null;
        if (context.foundAggregateFunction()) {
            if (this.wasIndexUsedForGroupBy()) {
                grpRows = new GroupedRowIterator(false, rows, colIdToFieldMap, context.getGroupBy(), context.getSelect(), context.getHaving(), null, context.getOrderBy());
                this.addExplainRow(grpRows);
                return grpRows;
            }
            grpRows = new GroupedRowIterator(rows, colIdToFieldMap, context.getGroupBy(), context.getSelect(), context.getHaving(), context.getOrderBy());
            this.addExplainRow(grpRows);
            return grpRows;
        }
        return rows;
    }

    private void makeIndexNestedLoopJoinedRowIterator(FromNode from, JoinCondition joinCondition, QueryPlannerJoinContext joinContext) throws AxionException {
        AbstractJoinedRowIterator joinedRowIterator = null;
        if (joinContext.getRightIterator() instanceof MutableIndexedRowIterator && !from.isRightJoin() && !joinContext.swapRightToLeft()) {
            joinedRowIterator = new IndexNestedLoopJoinedRowIterator(joinContext.getLeftIterator(), joinContext.getLeftColumnPosition(), (MutableIndexedRowIterator)joinContext.getRightIterator(), joinContext.getRightColumnCount(), !from.isInnerJoin(), from.isRightJoin());
        } else if (joinContext.getLeftIterator() instanceof MutableIndexedRowIterator && !from.isLeftJoin()) {
            joinedRowIterator = new IndexNestedLoopJoinedRowIterator(joinContext.getRightIterator(), joinContext.getRightColumnPosition(), (MutableIndexedRowIterator)joinContext.getLeftIterator(), joinContext.getLeftColumnCount(), !from.isInnerJoin(), true);
        }
        if (joinedRowIterator != null) {
            if (!joinCondition.isEmpty()) {
                joinedRowIterator.setJoinCondition(joinCondition.stitchAll(), new RowDecorator(joinContext.getColumnIdToFieldMap()));
                this._unappliedWhereNodes.removeAll(joinCondition.getNodes());
            }
            joinContext.setRowIterator(joinedRowIterator);
            this.addExplainRow(joinedRowIterator);
        }
    }

    private void makeLeftChangingIndexedRowIterator(FromNode from, JoinCondition joinCondition, Database db, QueryPlannerJoinContext joinContext) throws AxionException {
        if (joinContext.getRightIterator() == null && from.getLeft() instanceof TableIdentifier) {
            TableIdentifier ltid = (TableIdentifier)from.getLeft();
            Table table = db.getTable(ltid);
            ComparisonFunction fn = AxionQueryOptimizer.findFirstColumnColumnComparisonFunction(joinCondition.getNodes(), ltid, table, true);
            if (fn != null && !fn.getArgument(0).equals(fn.getArgument(1))) {
                joinContext.setLeftTableKey((ColumnIdentifier)fn.getArgument(0));
                joinContext.setRightTablekey((ColumnIdentifier)fn.getArgument(1));
                if (!ltid.equals(joinContext.getLeftTableKey().getTableIdentifier())) {
                    joinContext.flipKey();
                }
                if (joinContext.getLeftTableKey() != null && !from.isLeftJoin()) {
                    Index index = table.getIndexForColumn(table.getColumn(joinContext.getLeftTableKey().getName()));
                    joinContext.setLeftIterator(this.makeChangingIndexedRowIterator(table, index));
                    if (fn instanceof EqualFunction) {
                        this.swapKeyForSortingIfUSedInOrderByOrGroupBy(joinContext.getLeftTableKey(), joinContext.getRightTablekey());
                        joinContext.setRowsAreSortedByJoinKey(true);
                    }
                    joinCondition.getNodes().remove(fn);
                    this.pushUnwantedConditions(from, joinCondition, ltid);
                } else {
                    joinContext.setLeftTableKey(null);
                    joinContext.setRightTablekey(null);
                }
            }
        }
    }

    private void makeLeftRowIterator(FromNode from, JoinCondition joinCondition, Database db, QueryPlannerJoinContext joinContext, ColumnIdentifier lcol, AxionQueryContext context, boolean readOnly) throws AxionException {
        Object leftChild = from.getLeft();
        if (leftChild instanceof FromNode) {
            Integer colPos;
            QueryPlannerJoinContext nestedJoinContext = this.processFromTree((FromNode)leftChild, db, context, readOnly);
            joinContext.setLeftIterator(nestedJoinContext.getRowIterator());
            joinContext.addColumnIdentifiers(nestedJoinContext.getColumnIdentifiers());
            joinContext.setLeftColumnCount(nestedJoinContext.getTotalColumnCount());
            if (lcol != null && (colPos = (Integer)nestedJoinContext.getColumnIdToFieldMap().get(lcol.getCanonicalIdentifier())) != null) {
                joinContext.setLeftColumnPosition(colPos);
            }
        } else {
            TableIdentifier tid = (TableIdentifier)leftChild;
            Table left = db.getTable(tid);
            if (lcol != null) {
                joinContext.setLeftColumnPosition(left.getColumnIndex(lcol.getName()));
            }
            RowIterator rows = joinContext.getLeftIterator();
            if (joinContext.isRowsAreSortedByJoinKey()) {
                rows = this.getIndexedRowsIfSortingRequired(rows, context, left, readOnly, this._unappliedTableFilters);
            }
            rows = this.getRowIteratorFromTable(db, tid, left, rows, readOnly, this._unappliedTableFilters);
            rows = this.makeFilteringRowIterator(tid, left, rows, context, this._unappliedTableFilters);
            this.populateColumnList(joinContext.getColumnIdentifiers(), tid, left, context);
            joinContext.setLeftIterator(rows);
            joinContext.setLeftColumnCount(left.getColumnCount());
            this.pushUnwantedConditions(from, joinCondition, tid);
        }
    }

    private void pushUnwantedConditions(FromNode from, JoinCondition joinCondition, TableIdentifier tid) {
        if (from.isInnerJoin() && !joinCondition.isEmpty()) {
            LinkedHashSet<ComparisonFunction> conditions = new LinkedHashSet<ComparisonFunction>();
            for (ComparisonFunction fn : joinCondition.getNodes()) {
                if (!AxionQueryOptimizer.hasTableReference(fn, tid)) {
                    this._unappliedWhereNodes.add(fn);
                    continue;
                }
                conditions.add(fn);
            }
            joinCondition.setNodes(conditions);
        }
    }

    private RowIterator makeLimitingRowIterator(RowIterator rows, AxionQueryContext context, Map colIdToFieldMap) throws AxionException {
        if (null != context.getLimit() || null != context.getOffset()) {
            rows = new LimitingRowIterator(rows, context.getLimit(), context.getOffset());
            this.addExplainRow(rows);
        }
        return rows;
    }

    private RowIterator makeLiteralRowIterator(List columns) throws AxionException {
        SingleRowIterator literaliter = null;
        if (null != this._literals || this._parentRow != null) {
            int i;
            Iterator iter;
            int ltRowSize = null != this._literals ? this._literals.size() : 0;
            SimpleRow litrow = new SimpleRow(ltRowSize += null != this._parentRow ? this._parentRow.getRow().size() : 0);
            int pos = 0;
            if (null != this._literals) {
                iter = this._literals.iterator();
                i = 0;
                while (iter.hasNext()) {
                    Literal literal = (Literal)iter.next();
                    columns.add(literal);
                    litrow.set(pos++, literal);
                    ++i;
                }
            }
            if (null != this._parentRow) {
                iter = this._parentRow.getSelectableIterator();
                i = 0;
                while (iter.hasNext()) {
                    ColumnIdentifier parentCol = (ColumnIdentifier)iter.next();
                    if (!columns.contains(parentCol)) {
                        columns.add(parentCol);
                        litrow.set(pos++, this._parentRow.get(parentCol));
                    }
                    ++i;
                }
            }
            literaliter = new SingleRowIterator(litrow);
            this.addExplainRow(literaliter);
            this._literals = null;
            this._parentRow = null;
        }
        return literaliter;
    }

    private void makeNestedLoopJoinedIterator(FromNode from, JoinCondition joinCondition, QueryPlannerJoinContext joinContext) throws AxionException {
        NestedLoopJoinedRowIterator joinedRowIter = null;
        joinedRowIter = !from.isRightJoin() && !joinContext.swapRightToLeft() ? new NestedLoopJoinedRowIterator(joinContext.getLeftIterator(), joinContext.getRightIterator(), joinContext.getRightColumnCount(), !from.isInnerJoin(), from.isRightJoin()) : new NestedLoopJoinedRowIterator(joinContext.getRightIterator(), joinContext.getLeftIterator(), joinContext.getLeftColumnCount(), !from.isInnerJoin(), true);
        if (!joinCondition.isEmpty()) {
            joinedRowIter.setJoinCondition(joinCondition.stitchAll(), new RowDecorator(joinContext.getColumnIdToFieldMap()));
            this._unappliedWhereNodes.removeAll(joinCondition.getNodes());
        }
        joinContext.setRowIterator(joinedRowIter);
        this.addExplainRow(joinedRowIter);
    }

    private RowIterator makeOrderedIndexBasedRowIterator(boolean readOnly, AxionQueryContext context, Table table) throws AxionException {
        RowIterator orderedRows = null;
        OrderNode node = context.getOrderBy(0);
        ColumnIdentifier cid = null;
        Selectable where = context.getWhere();
        if (node.getSelectable() instanceof ColumnIdentifier) {
            cid = (ColumnIdentifier)node.getSelectable();
            Set conditions = AxionQueryOptimizer.flatConditionTree(where);
            orderedRows = this.getIndexedRows(conditions, cid, table, readOnly);
        }
        if (orderedRows != null) {
            this.setSkipSorting(true);
            this.addExplainRow(orderedRows);
            if (where != null) {
                orderedRows = new FilteringRowIterator(orderedRows, new RowDecorator(this.getColumnIdToFieldMap()), where);
                this.addExplainRow(orderedRows);
            }
        }
        return orderedRows;
    }

    private RowIterator makeOrderedRowIterator(Database db, RowIterator rows, Map colIdToFieldMap, AxionQueryContext context) throws AxionException {
        if (this.isSortingRequired(context)) {
            rows = new SortedRowIterator.MergeSort(rows, context.getOrderBy(), new RowDecorator(colIdToFieldMap));
            this.addExplainRow(rows);
        } else if (this._doReverseSorting) {
            rows = new ReverseSortedRowIterator(rows);
            this.addExplainRow(rows);
        }
        return rows;
    }

    private void makeRightChangingIndexedRowIterator(FromNode from, JoinCondition joinCondition, Database db, QueryPlannerJoinContext joinContext) throws AxionException {
        if (joinContext.getLeftIterator() == null && from.getRight() instanceof TableIdentifier) {
            TableIdentifier rtid = (TableIdentifier)from.getRight();
            Table table = db.getTable(rtid);
            ComparisonFunction fn = AxionQueryOptimizer.findFirstColumnColumnComparisonFunction(joinCondition.getNodes(), rtid, table, true);
            if (fn != null && !fn.getArgument(0).equals(fn.getArgument(1))) {
                joinContext.setLeftTableKey((ColumnIdentifier)fn.getArgument(0));
                joinContext.setRightTablekey((ColumnIdentifier)fn.getArgument(1));
                if (!rtid.equals(joinContext.getRightTablekey().getTableIdentifier())) {
                    joinContext.flipKey();
                }
                if (joinContext.getRightTablekey() != null && !from.isRightJoin()) {
                    Index index = table.getIndexForColumn(table.getColumn(joinContext.getRightTablekey().getName()));
                    joinContext.setRightIterator(this.makeChangingIndexedRowIterator(table, index));
                    if (fn instanceof EqualFunction) {
                        this.swapKeyForSortingIfUSedInOrderByOrGroupBy(joinContext.getRightTablekey(), joinContext.getLeftTableKey());
                        joinContext.setRowsAreSortedByJoinKey(true);
                    }
                    joinCondition.getNodes().remove(fn);
                    this.pushUnwantedConditions(from, joinCondition, rtid);
                } else {
                    joinContext.setLeftTableKey(null);
                    joinContext.setRightTablekey(null);
                }
            }
        }
    }

    private void makeRightRowIterator(FromNode from, JoinCondition joinCondition, Database db, QueryPlannerJoinContext joinContext, ColumnIdentifier rcol, AxionQueryContext context, boolean readOnly) throws AxionException {
        Object rightChild = from.getRight();
        if (rightChild instanceof FromNode) {
            Integer colPos;
            QueryPlannerJoinContext nestedJoinContext = this.processFromTree((FromNode)rightChild, db, context, readOnly);
            joinContext.setRightIterator(nestedJoinContext.getRowIterator());
            joinContext.addColumnIdentifiers(nestedJoinContext.getColumnIdentifiers());
            joinContext.setRightColumnCount(nestedJoinContext.getTotalColumnCount());
            if (rcol != null && (colPos = (Integer)nestedJoinContext.getColumnIdToFieldMap().get(rcol.getCanonicalIdentifier())) != null) {
                joinContext.setRightColumnPosition(colPos);
            }
        } else {
            TableIdentifier tid = (TableIdentifier)rightChild;
            Table right = db.getTable(tid);
            if (rcol != null) {
                joinContext.setRightColumnPosition(right.getColumnIndex(rcol.getName()));
            }
            RowIterator rows = joinContext.getRightIterator();
            if (joinContext.isRowsAreSortedByJoinKey()) {
                rows = this.getIndexedRowsIfSortingRequired(rows, context, right, readOnly, this._unappliedTableFilters);
            }
            rows = this.getRowIteratorFromTable(db, tid, right, rows, readOnly, this._unappliedTableFilters);
            rows = this.makeFilteringRowIterator(tid, right, rows, context, this._unappliedTableFilters);
            this.populateColumnList(joinContext.getColumnIdentifiers(), tid, right, context);
            joinContext.setRightIterator(rows);
            joinContext.setRightColumnCount(right.getColumnCount());
            this.pushUnwantedConditions(from, joinCondition, tid);
        }
    }

    private void populateColumnIdToFieldMap(List columnList, Map colIdToFieldMap) {
        int I = columnList.size();
        for (int i = 0; i < I; ++i) {
            colIdToFieldMap.put(columnList.get(i), ValuePool.getInt(i));
        }
    }

    private void populateColumnList(List colList, TableIdentifier tableIdent, Table table, AxionQueryContext context) throws AxionException {
        int J = table.getColumnCount();
        for (int j = 0; j < J; ++j) {
            ColumnIdentifier id = null;
            int K = context.getSelectCount();
            for (int k = 0; k < K; ++k) {
                ColumnIdentifier cSel;
                Selectable sel = context.getSelect(k);
                if (!(sel instanceof ColumnIdentifier) || !tableIdent.equals((cSel = (ColumnIdentifier)sel).getTableIdentifier()) || !cSel.getName().equals(table.getColumn(j).getName())) continue;
                id = cSel.getCanonicalIdentifier();
                break;
            }
            if (null == id) {
                id = new ColumnIdentifier(tableIdent, table.getColumn(j).getName());
            }
            colList.add(id);
        }
    }

    private QueryPlannerJoinContext processFromTree(FromNode from, Database db, AxionQueryContext context, boolean readOnly) throws AxionException {
        QueryPlannerJoinContext joinContext = new QueryPlannerJoinContext();
        JoinCondition joinCondition = this.processJoinConditionTree(from);
        if (!from.hasRight()) {
            this.makeLeftRowIterator(from, joinCondition, db, joinContext, joinContext.getLeftTableKey(), context, readOnly);
            joinContext.setRowIterator(joinContext.getLeftIterator());
            return joinContext;
        }
        if (!this.findFilterOnIndexColumnForRightTable(from, db, joinContext, joinCondition)) {
            this.makeRightChangingIndexedRowIterator(from, joinCondition, db, joinContext);
        }
        this.makeLeftChangingIndexedRowIterator(from, joinCondition, db, joinContext);
        if (from.getTableCount() > 1 && joinContext.getLeftIterator() == null && joinContext.getRightIterator() == null) {
            this.createDynamicIndex(from, joinCondition, joinContext, db);
        }
        this.makeLeftRowIterator(from, joinCondition, db, joinContext, joinContext.getLeftTableKey(), context, readOnly);
        joinContext.setIteratorCount(joinContext.getIteratorCount() + 1);
        this.makeRightRowIterator(from, joinCondition, db, joinContext, joinContext.getRightTablekey(), context, readOnly);
        joinContext.setIteratorCount(joinContext.getIteratorCount() + 1);
        this.makeIndexNestedLoopJoinedRowIterator(from, joinCondition, joinContext);
        if (joinContext.getRowIterator() == null) {
            this.makeNestedLoopJoinedIterator(from, joinCondition, joinContext);
        }
        return joinContext;
    }

    private boolean findFilterOnIndexColumnForRightTable(FromNode from, Database db, QueryPlannerJoinContext joinContext, JoinCondition joinCondition) throws AxionException {
        Table rightTable;
        TableIdentifier rtid;
        if (!this._isAllInnerJoin) {
            return false;
        }
        Function fn = null;
        if (from.isInnerJoin() && from.getRight() instanceof TableIdentifier && (fn = AxionQueryOptimizer.findColumnLiteralEqualFunction(rtid = (TableIdentifier)from.getRight(), rightTable = db.getTable(rtid), this._unappliedTableFilters, true)) != null && (fn = AxionQueryOptimizer.findFirstColumnColumnComparisonFunction(joinCondition.getNodes(), rtid, rightTable, false)) != null) {
            joinContext.setLeftTableKey((ColumnIdentifier)fn.getArgument(0));
            joinContext.setRightTablekey((ColumnIdentifier)fn.getArgument(1));
            if (!rtid.equals(joinContext.getRightTablekey().getTableIdentifier())) {
                joinContext.flipKey();
            }
            joinContext.setSwapRightToLeft(true);
            this.pushUnwantedConditions(from, joinCondition, rtid);
        }
        return fn != null;
    }

    private JoinCondition processJoinConditionTree(FromNode from) throws AxionException {
        Set joinConditions = AxionQueryOptimizer.flatConditionTree(from.getCondition());
        if (from.isInnerJoin()) {
            LinkedHashSet joinAndWhereConditions = new LinkedHashSet();
            joinAndWhereConditions.addAll(joinConditions);
            joinAndWhereConditions.addAll(this._unappliedWhereNodes);
            Set conditions = AxionQueryOptimizer.deriveTableFilter(joinAndWhereConditions, this._isAllInnerJoin);
            Set[] splitConditions = AxionQueryOptimizer.decomposeWhereConditionNodes(conditions, this._isAllInnerJoin);
            this._unappliedTableFilters.addAll(splitConditions[1]);
            this._unappliedWhereNodes = splitConditions[2];
            return new JoinCondition(splitConditions[0]);
        }
        return new JoinCondition(joinConditions);
    }

    private RowIterator processQuery(Database db, boolean readOnly, AxionQueryContext context) throws AxionException {
        this._unappliedWhereNodes = AxionQueryOptimizer.flatConditionTree(context.getWhere());
        this._isAllInnerJoin = AxionQueryOptimizer.isAllInnerJoin(context.getFrom());
        QueryPlannerJoinContext rootJoinContext = this.processFromTree(context.getFrom(), db, context, readOnly);
        RowIterator literaliter = this.makeLiteralRowIterator(rootJoinContext.getColumnIdentifiers());
        if (literaliter != null) {
            rootJoinContext.setIteratorCount(rootJoinContext.getIteratorCount() + 1);
            int literaliterRowCount = literaliter.first().size();
            NestedLoopJoinedRowIterator cpjRows = new NestedLoopJoinedRowIterator(rootJoinContext.getRowIterator(), literaliter, literaliterRowCount);
            rootJoinContext.setRowIterator(cpjRows);
        }
        RowIterator rows = rootJoinContext.getRowIterator();
        Map colIdToFieldMap = this.clearAndGetColumnIdToFieldMap();
        this.populateColumnIdToFieldMap(rootJoinContext.getColumnIdentifiers(), colIdToFieldMap);
        if (!this._unappliedWhereNodes.isEmpty() || !this._unappliedTableFilters.isEmpty()) {
            this._unappliedWhereNodes.addAll(this._unappliedTableFilters);
            Selectable unappliedWhere = AxionQueryOptimizer.createOneRootFunction(this._unappliedWhereNodes);
            rows = new FilteringRowIterator(rows, new RowDecorator(colIdToFieldMap), unappliedWhere);
            this.addExplainRow(rows);
        }
        return rows;
    }

    private RowIterator processQueryForSingleTable(Database db, boolean readOnly, AxionQueryContext context) throws AxionException {
        Map colIdToFieldMap = this.clearAndGetColumnIdToFieldMap();
        Table table = db.getTable(context.getTables(0));
        ArrayList columnList = new ArrayList();
        this.populateColumnList(columnList, context.getTables(0), table, context);
        RowIterator literaliter = this.makeLiteralRowIterator(columnList);
        this.populateColumnIdToFieldMap(columnList, colIdToFieldMap);
        RowIterator rows = null;
        if (context.getOrderByCount() == 1 && context.getGroupByCount() < 1) {
            rows = this.makeOrderedIndexBasedRowIterator(readOnly, context, table);
        } else if (context.getGroupByCount() == 1) {
            rows = this.makeGroupedIndexBasedRowIterator(readOnly, context, table);
        }
        if (rows == null) {
            this._unappliedWhereNodes = AxionQueryOptimizer.flatConditionTree(context.getWhere());
            rows = this.getRowIteratorFromTable(db, context.getTables(0), table, rows, readOnly, this._unappliedWhereNodes);
        }
        if (literaliter != null) {
            int literaliterRowCount = literaliter.first().size();
            rows = new NestedLoopJoinedRowIterator(rows, literaliter, literaliterRowCount);
            this.addExplainRow(rows);
        }
        if (this._unappliedWhereNodes != null && !this._unappliedWhereNodes.isEmpty()) {
            Selectable unappliedWhere = AxionQueryOptimizer.createOneRootFunction(this._unappliedWhereNodes);
            rows = new FilteringRowIterator(rows, new RowDecorator(colIdToFieldMap), unappliedWhere);
            this.addExplainRow(rows);
        }
        return rows;
    }

    private RowIterator processQueryWithNoTable(AxionQueryContext context) throws AxionException {
        Map colIdToFieldMap = this.clearAndGetColumnIdToFieldMap();
        ArrayList columnList = new ArrayList();
        RowIterator rows = this.makeLiteralRowIterator(columnList);
        this.populateColumnIdToFieldMap(columnList, colIdToFieldMap);
        if (rows == null) {
            rows = new SingleRowIterator(new SimpleRow(0));
        }
        if (context.getWhere() != null) {
            rows = new FilteringRowIterator(rows, new RowDecorator(colIdToFieldMap), context.getWhere());
        }
        return rows;
    }

    private void resolveOrderByAfterApplyingGroupBy(AxionQueryContext context, Selectable oldSel, Selectable newSel) {
        Selectable temp = null;
        int I = context.getOrderByCount();
        for (int i = 0; i < I; ++i) {
            temp = context.getOrderBy(i).getSelectable();
            if (!oldSel.equals(temp)) continue;
            context.getOrderBy(i).setSelectable(newSel);
        }
    }

    private void resolveSelectedAfterGrouping(AxionQueryContext context, Map colIdToFieldMap) throws AxionException {
        colIdToFieldMap.clear();
        Selectable[] newSelected = new Selectable[context.getSelectCount()];
        int I = context.getSelectCount();
        for (int i = 0; i < I; ++i) {
            Selectable sel = context.getSelect(i);
            TableIdentifier tid = null;
            tid = sel instanceof ColumnIdentifier ? ((ColumnIdentifier)sel).getTableIdentifier() : new TableIdentifier(context.getAliasName());
            newSelected[i] = new ColumnIdentifier(tid, sel.getLabel(), null, sel.getDataType());
            if (context.getGroupByCount() > 0) {
                this.resolveOrderByAfterApplyingGroupBy(context, sel, newSelected[i]);
            }
            colIdToFieldMap.put(newSelected[i], ValuePool.getInt(i));
        }
        context.setSelected(newSelected);
        context.setResolvedSelect(Arrays.asList(newSelected));
    }

    private boolean setIndexUsedForGroupBy(boolean indexUsed) {
        this._wasIndexUsedForGroupBy = indexUsed;
        return this._wasIndexUsedForGroupBy;
    }

    private void setSkipSorting(boolean skipSorting) {
        this._skipSorting = skipSorting;
    }

    private boolean skipSorting() {
        return this._skipSorting;
    }

    private void swapKeyForSortingIfUSedInOrderByOrGroupBy(ColumnIdentifier current, ColumnIdentifier swapWith) {
        OrderNode node;
        Selectable ordCol;
        ColumnIdentifier grpCol;
        AxionQueryContext context = this.getContext();
        if (context.getGroupByCount() == 1 && (grpCol = (ColumnIdentifier)context.getGroupBy(0)).equals(current)) {
            context.setGroupBy(0, swapWith);
        }
        if (context.getOrderByCount() == 1 && (ordCol = (node = context.getOrderBy(0)).getSelectable()) instanceof ColumnIdentifier && ordCol.equals(current)) {
            node.setSelectable(swapWith);
        }
    }

    private boolean wasIndexUsedForGroupBy() {
        return this._wasIndexUsedForGroupBy;
    }

    class QueryPlannerJoinContext {
        private List _columns = new ArrayList();
        private int _iteratorCount = 0;
        private int _leftColumnCount = -1;
        private int _leftColumnPosition = -1;
        private RowIterator _leftIterator;
        private ColumnIdentifier _leftTableKey;
        private int _rightColumnCount = -1;
        private int _rightColumnPosition = -1;
        private RowIterator _rightIterator;
        private ColumnIdentifier _rightTablekey;
        private RowIterator _rowIterator;
        private boolean _rowsAreSortedByJoinKey = false;
        private boolean _swapRightToLeft = false;

        public void addColumnIdentifiers(List columns) {
            this._columns.addAll(columns);
        }

        public void flipKey() {
            ColumnIdentifier temp = this._rightTablekey;
            this._rightTablekey = this._leftTableKey;
            this._leftTableKey = temp;
        }

        public List getColumnIdentifiers() {
            return this._columns;
        }

        public Map getColumnIdToFieldMap() {
            int size = this._columns.size();
            HashMap colIdToFieldMap = new HashMap(size);
            for (int i = 0; i < size; ++i) {
                colIdToFieldMap.put(this._columns.get(i), ValuePool.getInt(i));
            }
            return colIdToFieldMap;
        }

        public int getIteratorCount() {
            return this._iteratorCount;
        }

        public int getLeftColumnCount() {
            return this._leftColumnCount;
        }

        public int getLeftColumnPosition() {
            return this._leftColumnPosition;
        }

        public RowIterator getLeftIterator() {
            return this._leftIterator;
        }

        public ColumnIdentifier getLeftTableKey() {
            return this._leftTableKey;
        }

        public int getRightColumnCount() {
            return this._rightColumnCount;
        }

        public int getRightColumnPosition() {
            return this._rightColumnPosition;
        }

        public RowIterator getRightIterator() {
            return this._rightIterator;
        }

        public ColumnIdentifier getRightTablekey() {
            return this._rightTablekey;
        }

        public RowIterator getRowIterator() {
            return this._rowIterator;
        }

        public int getTotalColumnCount() {
            return this._leftColumnCount + this._rightColumnCount;
        }

        public void setIteratorCount(int iteratorCount) {
            this._iteratorCount = iteratorCount;
        }

        public void setLeftColumnCount(int leftColumnCount) {
            this._leftColumnCount = leftColumnCount;
        }

        public void setLeftColumnPosition(int leftColumnPosition) {
            this._leftColumnPosition = leftColumnPosition;
        }

        public void setLeftIterator(RowIterator leftIterator) {
            this._leftIterator = leftIterator;
        }

        public void setLeftTableKey(ColumnIdentifier leftTableKey) {
            this._leftTableKey = leftTableKey;
        }

        public void setRightColumnCount(int rightColumnCount) {
            this._rightColumnCount = rightColumnCount;
        }

        public void setRightColumnPosition(int rightColumnPosition) {
            this._rightColumnPosition = rightColumnPosition;
        }

        public void setRightIterator(RowIterator rightIterator) {
            this._rightIterator = rightIterator;
        }

        public void setRightTablekey(ColumnIdentifier rightTablekey) {
            this._rightTablekey = rightTablekey;
        }

        public void setRowIterator(RowIterator rowIterator) {
            this._rowIterator = rowIterator;
        }

        public boolean isRowsAreSortedByJoinKey() {
            return this._rowsAreSortedByJoinKey;
        }

        public void setRowsAreSortedByJoinKey(boolean areSortedByJoinKey) {
            this._rowsAreSortedByJoinKey = areSortedByJoinKey;
        }

        public boolean swapRightToLeft() {
            return this._swapRightToLeft;
        }

        public void setSwapRightToLeft(boolean swapRightToLeft) {
            this._swapRightToLeft = swapRightToLeft;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(20);
            buf.append("JoinContext{");
            buf.append("\niteratorCount=").append(this._iteratorCount);
            buf.append("\nrowIterator=").append(this._rowIterator);
            buf.append("\n\nleftColumnCount=").append(this._leftColumnCount);
            buf.append("\nleftColumnPosition=").append(this._leftColumnPosition);
            buf.append("\nleftIterator=").append(this._leftIterator);
            buf.append("\nleftTableKey=").append(this._leftTableKey);
            buf.append("\n\nrightColumnCount=").append(this._rightColumnCount);
            buf.append("\nrightColumnPosition=").append(this._rightColumnPosition);
            buf.append("\nrightIterator=").append(this._rightIterator);
            buf.append("\nrightTablekey=").append(this._rightTablekey);
            buf.append("\n\nrowsAreSortedByJoinKey=").append(this._rowsAreSortedByJoinKey);
            buf.append("}");
            return buf.toString();
        }
    }

    class JoinCondition {
        private Set _joinConditions;

        public JoinCondition(Set jConditions) {
            this._joinConditions = jConditions;
        }

        public Set getNodes() {
            return this._joinConditions;
        }

        public void setNodes(Set conditions) {
            this._joinConditions = conditions;
        }

        public boolean isEmpty() {
            return this._joinConditions == null || this._joinConditions.isEmpty();
        }

        public Selectable stitchAll() {
            return AxionQueryOptimizer.createOneRootFunction(this._joinConditions);
        }

        public String toString() {
            return "JoinCondition[" + this._joinConditions.toString() + "]";
        }
    }

    private class AxionQueryPlanNode {
        List _explainRows = new ArrayList(2);

        private AxionQueryPlanNode() {
        }

        public void addExplainRow(String value) {
            SimpleRow row = new SimpleRow(1);
            row.set(0, value);
            this._explainRows.add(row);
        }

        public RowIterator getRowIterator() {
            return new ListRowIterator(this._explainRows);
        }
    }
}

