/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.LinkedHashSet;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.FromNode;
import org.axiondb.Function;
import org.axiondb.FunctionFactory;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.visitors.FlattenWhereNodeVisitor;
import org.axiondb.engine.visitors.ReferencesOtherTablesWhereNodeVisitor;
import org.axiondb.functions.AndFunction;
import org.axiondb.functions.ComparisonFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.EqualFunction;
import org.axiondb.functions.IsNotNullFunction;
import org.axiondb.functions.IsNullFunction;

public class AxionQueryOptimizer {
    public static Selectable createOneRootFunction(Set conditions) {
        if (conditions == null || conditions.size() == 0) {
            return null;
        }
        if (conditions.size() == 1) {
            return (Selectable)conditions.iterator().next();
        }
        AndFunction previousAnd = new AndFunction();
        for (Selectable function : conditions) {
            if (previousAnd.getArgumentCount() != 2) {
                previousAnd.addArgument(function);
                continue;
            }
            AndFunction andFunction = new AndFunction();
            andFunction.addArgument(previousAnd);
            andFunction.addArgument(function);
            previousAnd = andFunction;
        }
        return previousAnd;
    }

    public static Set[] decomposeWhereConditionNodes(Set flattenConditionSet, boolean isAllInnerJoin) {
        LinkedHashSet<ComparisonFunction> columnColumnConditons = new LinkedHashSet<ComparisonFunction>();
        LinkedHashSet<ComparisonFunction> columnLiteralConditions = new LinkedHashSet<ComparisonFunction>();
        LinkedHashSet<ComparisonFunction> remaingConditionNodes = new LinkedHashSet<ComparisonFunction>();
        for (Object condition : flattenConditionSet) {
            if (condition instanceof ComparisonFunction) {
                ComparisonFunction fn = (ComparisonFunction)condition;
                if (fn.isColumnColumn()) {
                    columnColumnConditons.add(fn);
                    continue;
                }
                if (fn.isColumnLiteral()) {
                    columnLiteralConditions.add(fn);
                    continue;
                }
                remaingConditionNodes.add(fn);
                continue;
            }
            if (isAllInnerJoin && (condition instanceof IsNotNullFunction || condition instanceof IsNullFunction)) {
                columnLiteralConditions.add((ComparisonFunction)condition);
                continue;
            }
            remaingConditionNodes.add((ComparisonFunction)condition);
        }
        return new Set[]{columnColumnConditons, columnLiteralConditions, remaingConditionNodes};
    }

    public static boolean hasTableReference(ComparisonFunction fn, TableIdentifier tid) {
        return AxionQueryOptimizer.getColumnRefersTable(fn, tid) != null;
    }

    public static Selectable getColumnRefersTable(ComparisonFunction fn, TableIdentifier tid) {
        Selectable searchColumn = null;
        Selectable leftColumn = fn.getArgument(0);
        Selectable rightColumn = fn.getArgument(1);
        if (AxionQueryOptimizer.hasColumnForTable(leftColumn, tid)) {
            searchColumn = leftColumn;
        } else if (AxionQueryOptimizer.hasColumnForTable(rightColumn, tid)) {
            searchColumn = rightColumn;
        }
        return searchColumn;
    }

    private static boolean hasColumnForTable(Selectable column, TableIdentifier tid) {
        ColumnIdentifier col;
        return column instanceof ColumnIdentifier && tid.equals((col = (ColumnIdentifier)column).getTableIdentifier());
    }

    public static Set deriveTableFilter(Set flattenConditions, boolean isAllInnerJoin) throws AxionException {
        Set[] splitConditions = AxionQueryOptimizer.decomposeWhereConditionNodes(flattenConditions, isAllInnerJoin);
        Set columnColumns = splitConditions[0];
        Set columnLiterals = splitConditions[1];
        for (Function columnColumn : columnColumns) {
            if (!(columnColumn instanceof EqualFunction)) continue;
            for (Function columnLiteral : columnLiterals) {
                FunctionFactory fnFactory = (FunctionFactory)((Object)columnLiteral);
                ConcreteFunction derivedFunction = fnFactory.makeNewInstance();
                AxionQueryOptimizer.addDerivedFunction(flattenConditions, columnColumn, columnLiteral, derivedFunction);
            }
        }
        return flattenConditions;
    }

    public static Function findColumnLiteralFunction(TableIdentifier tid, Table table, Set conditions, boolean mustCheckForIndex) {
        Function result = null;
        for (Selectable condition : conditions) {
            Function fn = AxionQueryOptimizer.isColumnIndexed(tid, table, condition, mustCheckForIndex);
            if (fn == null) continue;
            if (fn instanceof EqualFunction) {
                return fn;
            }
            if (result != null) continue;
            result = fn;
        }
        return result;
    }

    public static Function findColumnLiteralEqualFunction(TableIdentifier tid, Table table, Set conditions, boolean mustCheckForIndex) {
        Function result = null;
        for (Selectable condition : conditions) {
            Function fn = AxionQueryOptimizer.isColumnIndexed(tid, table, condition, mustCheckForIndex);
            if (fn == null || !(fn instanceof EqualFunction)) continue;
            return fn;
        }
        return result;
    }

    public static Function isColumnIndexed(TableIdentifier tid, Table table, Selectable condition, boolean mustCheckForIndex) {
        Selectable searchColumn;
        Function fn;
        if (condition instanceof ComparisonFunction) {
            Selectable searchColumn2;
            ComparisonFunction fn2 = (ComparisonFunction)condition;
            if (fn2.isColumnLiteral() && AxionQueryOptimizer.onlyReferencesTable(tid, fn2) && AxionQueryOptimizer.isColumnIndexed(mustCheckForIndex, table, searchColumn2 = AxionQueryOptimizer.getColumnRefersTable(fn2, tid))) {
                return fn2;
            }
        } else if ((condition instanceof IsNotNullFunction || condition instanceof IsNullFunction) && AxionQueryOptimizer.onlyReferencesTable(tid, fn = (Function)condition) && AxionQueryOptimizer.isColumnIndexed(mustCheckForIndex, table, searchColumn = fn.getArgument(0))) {
            return fn;
        }
        return null;
    }

    private static boolean isColumnIndexed(boolean mustCheckForIndex, Table table, Selectable searchColumn) {
        if (mustCheckForIndex && searchColumn != null && table.isColumnIndexed(table.getColumn(searchColumn.getName()))) {
            return true;
        }
        return !mustCheckForIndex;
    }

    public static ComparisonFunction findFirstColumnColumnComparisonFunction(Set columnColumnConditions, TableIdentifier tid, Table table, boolean mustCheckForIndex) throws AxionException {
        ComparisonFunction result = null;
        for (Object condition : columnColumnConditions) {
            ComparisonFunction fn;
            if (!(condition instanceof ComparisonFunction) || !AxionQueryOptimizer.isColumnColumnComparisonFunction(fn = (ComparisonFunction)condition, columnColumnConditions, tid, table, mustCheckForIndex)) continue;
            if (fn instanceof EqualFunction) {
                return fn;
            }
            if (result != null) continue;
            result = fn;
        }
        return result;
    }

    public static EqualFunction findFirstEqualFunction(Set columnColumnConditions, TableIdentifier tid, Table table, boolean mustCheckForIndex) throws AxionException {
        for (Object condition : columnColumnConditions) {
            EqualFunction fn;
            if (!(condition instanceof EqualFunction) || !AxionQueryOptimizer.isColumnColumnComparisonFunction(fn = (EqualFunction)condition, columnColumnConditions, tid, table, mustCheckForIndex)) continue;
            return fn;
        }
        return null;
    }

    public static Set flatConditionTree(Selectable conditionTree) {
        if (null == conditionTree) {
            return new LinkedHashSet(1);
        }
        return new FlattenWhereNodeVisitor().getNodes(conditionTree);
    }

    public static boolean onlyReferencesTable(TableIdentifier table, Selectable conditionNode) {
        ReferencesOtherTablesWhereNodeVisitor v = new ReferencesOtherTablesWhereNodeVisitor(table);
        v.visit(conditionNode);
        return v.getResult();
    }

    private static void addDerivedFunction(Set flattenConditions, Function columnColumn, Function columnLiteral, Function derivedFunction) {
        if (columnLiteral.getArgumentCount() == 2) {
            if (columnColumn.getArgument(0).equals(columnLiteral.getArgument(0))) {
                derivedFunction.addArgument(columnColumn.getArgument(1));
                derivedFunction.addArgument(columnLiteral.getArgument(1));
            } else if (columnColumn.getArgument(0).equals(columnLiteral.getArgument(1))) {
                derivedFunction.addArgument(columnLiteral.getArgument(0));
                derivedFunction.addArgument(columnColumn.getArgument(1));
            } else if (columnColumn.getArgument(1).equals(columnLiteral.getArgument(0))) {
                derivedFunction.addArgument(columnColumn.getArgument(0));
                derivedFunction.addArgument(columnLiteral.getArgument(1));
            } else if (columnColumn.getArgument(1).equals(columnLiteral.getArgument(1))) {
                derivedFunction.addArgument(columnLiteral.getArgument(0));
                derivedFunction.addArgument(columnColumn.getArgument(0));
            }
        } else if (columnColumn.getArgument(0).equals(columnLiteral.getArgument(0))) {
            derivedFunction.addArgument(columnColumn.getArgument(1));
        } else if (columnColumn.getArgument(1).equals(columnLiteral.getArgument(0))) {
            derivedFunction.addArgument(columnColumn.getArgument(0));
        }
        if (derivedFunction.getArgumentCount() > 0) {
            flattenConditions.add(derivedFunction);
        }
    }

    private static boolean isColumnColumnComparisonFunction(ComparisonFunction fn, Set columnColumnConditions, TableIdentifier tid, Table table, boolean mustCheckForIndex) {
        Selectable searchColumn;
        return fn.isColumnColumn() && (mustCheckForIndex ? (searchColumn = AxionQueryOptimizer.getColumnRefersTable(fn, tid)) != null && table.isColumnIndexed(table.getColumn(searchColumn.getName())) : AxionQueryOptimizer.hasTableReference(fn, tid));
    }

    public static boolean isAllInnerJoin(Object node) {
        FromNode from = (FromNode)node;
        if (from.isInnerJoin()) {
            if (from.getRight() instanceof FromNode && !AxionQueryOptimizer.isAllInnerJoin(from.getRight())) {
                return false;
            }
            return !(from.getLeft() instanceof FromNode) || AxionQueryOptimizer.isAllInnerJoin(from.getLeft());
        }
        return false;
    }
}

