/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.DataTypeFactory;
import org.axiondb.Database;
import org.axiondb.DatabaseLink;
import org.axiondb.ExternalTable;
import org.axiondb.FunctionFactory;
import org.axiondb.Index;
import org.axiondb.IndexFactory;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableFactory;
import org.axiondb.TableIdentifier;
import org.axiondb.TransactionManager;
import org.axiondb.engine.Databases;
import org.axiondb.engine.TransactionManagerImpl;
import org.axiondb.engine.commands.DeleteCommand;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.engine.indexes.BaseBTreeIndex;
import org.axiondb.engine.metaupdaters.AxionColumnsMetaTableUpdater;
import org.axiondb.engine.metaupdaters.AxionDBLinksMetaTableUpdater;
import org.axiondb.engine.metaupdaters.AxionSequencesMetaTableUpdater;
import org.axiondb.engine.metaupdaters.AxionTablePropertiesMetaTableUpdater;
import org.axiondb.engine.metaupdaters.AxionTablesMetaTableUpdater;
import org.axiondb.engine.metaupdaters.AxionTypesMetaTableUpdater;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.BaseFlatfileTable;
import org.axiondb.engine.tables.ExternalAxionDBTable;
import org.axiondb.engine.tables.ExternalDatabaseTable;
import org.axiondb.engine.tables.TableView;
import org.axiondb.event.DatabaseLinkEvent;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.event.DatabaseModifiedEvent;
import org.axiondb.event.DatabaseSequenceEvent;
import org.axiondb.event.DatabaseTypeEvent;
import org.axiondb.event.SequenceModificationListener;
import org.axiondb.event.TableModificationListener;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.FunctionIdentifier;
import org.axiondb.types.BooleanType;
import org.axiondb.types.DateType;
import org.axiondb.types.IntegerType;
import org.axiondb.types.LOBType;
import org.axiondb.types.ShortType;
import org.axiondb.types.StringType;
import org.axiondb.types.TimeType;
import org.axiondb.types.TimestampType;

public abstract class BaseDatabase
implements Database {
    public static final String SYSTABLE_DB_LINKS = "AXION_DB_LINKS";
    public static final String SYSTABLE_INDEX_INFO = "AXION_INDEX_INFO";
    private static Logger _log = Logger.getLogger(BaseDatabase.class.getName());
    private static Properties _props;
    private Map _databaseLink = new HashMap();
    private Map _dataTypes = new HashMap();
    private Map _functions = new HashMap();
    private Map _globalVariables = new HashMap();
    private Map _indexTypes = new HashMap();
    private Map _indices = new HashMap();
    private List _listeners = new ArrayList();
    private String _name;
    private boolean _readOnly = false;
    private Map _sequences = new HashMap();
    private DatabaseModificationListener _colUpd = new AxionColumnsMetaTableUpdater(this);
    private DatabaseModificationListener _seqUpd = new AxionSequencesMetaTableUpdater(this);
    private Map _tables = new HashMap();
    private Map _tableTypes = new HashMap();
    private TransactionManager _transactionManager = new TransactionManagerImpl(this);

    public BaseDatabase(String name) {
        this._name = name;
    }

    public void addDatabaseModificationListener(DatabaseModificationListener l) {
        this._listeners.add(l);
    }

    public void addIndex(Index index, Table table) throws AxionException {
        this.addIndex(index, table, false);
    }

    public void addIndex(Index index, Table table, boolean doPopulate) throws AxionException {
        if (this._indices.containsKey(index.getName())) {
            throw new AxionException("An index named " + index.getName() + " already exists");
        }
        Column indexedColumn = index.getIndexedColumn();
        if (table.isColumnIndexed(indexedColumn)) {
            Iterator i = table.getIndices();
            while (i.hasNext()) {
                Index existing = (Index)i.next();
                if (!existing.getIndexedColumn().equals(indexedColumn) || index.getClass() != existing.getClass()) continue;
                throw new AxionException("Column " + indexedColumn + " is already indexed " + "by an existing index, " + existing.getName() + ", of the same type");
            }
        }
        table.addIndex(index);
        if (doPopulate) {
            try {
                table.populateIndex(index);
            }
            catch (AxionException e) {
                try {
                    table.removeIndex(index);
                }
                catch (AxionException ignore) {
                    // empty catch block
                }
                throw e;
            }
        }
        this._indices.put(index.getName(), new Object[]{index, table});
        this.addIndexMetaEntry(index, table);
    }

    public void addTable(Table t) throws AxionException {
        if (t != null) {
            String name = t.getName();
            if (this._tables.containsKey(name)) {
                throw new AxionException("A table named " + name + " already exists.");
            }
            this._tables.put(name, t);
            t.addTableModificationListener((TableModificationListener)((Object)this._colUpd));
            for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
                cur.tableAdded(new DatabaseModifiedEvent(t));
            }
        }
    }

    public void checkpoint() throws AxionException {
        for (Table table : this._tables.values()) {
            table.checkpoint();
        }
    }

    public void createDatabaseLink(DatabaseLink dblink) throws AxionException {
        String upName = dblink.getName().toUpperCase();
        this._databaseLink.put(upName, dblink);
        DatabaseLinkEvent e = new DatabaseLinkEvent(dblink);
        for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
            cur.serverAdded(e);
        }
    }

    public void createSequence(Sequence seq) throws AxionException {
        if (seq != null) {
            DatabaseSequenceEvent e = new DatabaseSequenceEvent(seq);
            for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
                cur.sequenceAdded(e);
            }
            this._sequences.put(seq.getName(), seq);
            seq.addSequenceModificationListener((SequenceModificationListener)((Object)this._seqUpd));
        }
    }

    public void defrag() throws AxionException {
        throw new UnsupportedOperationException("Defrag not supported in Memory DB.");
    }

    public int defragTable(String tableName) throws AxionException {
        throw new UnsupportedOperationException("Defrag not supported in Memory DB.");
    }

    public void dropDatabaseLink(String name) throws AxionException {
        String upName = name.toUpperCase();
        DatabaseLink dblink = (DatabaseLink)this._databaseLink.remove(upName);
        if (null == dblink) {
            throw new AxionException("No Database Link Server " + upName + " found");
        }
        DatabaseLinkEvent e = new DatabaseLinkEvent(dblink);
        for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
            cur.serverDropped(e);
        }
    }

    public void dropDependentExternalDBTable(List tables) throws AxionException {
        for (Table t : tables) {
            this.dropTable(t.getName());
            List v = this.getDependentExternalDBTable(t.getName());
            if (v.isEmpty()) continue;
            this.dropDependentExternalDBTable(v);
        }
    }

    public void dropDependentViews(List views) throws AxionException {
        for (Table t : views) {
            this.dropTable(t.getName());
            List v = this.getDependentViews(t.getName());
            if (v.isEmpty()) continue;
            this.dropDependentViews(v);
        }
    }

    public void dropIndex(String name) throws AxionException {
        String upName = name.toUpperCase();
        Object[] pair = (Object[])this._indices.remove(upName);
        if (null == pair) {
            throw new AxionException("No index " + upName + " found.");
        }
        Index index = (Index)pair[0];
        Table table = (Table)pair[1];
        table.removeIndex(index);
        this.removeIndexMetaEntry(index);
    }

    public void dropSequence(String name) throws AxionException {
        String upName = name.toUpperCase();
        Sequence seq = (Sequence)this._sequences.remove(upName);
        if (null == seq) {
            throw new AxionException("No sequence " + upName + " found");
        }
        DatabaseSequenceEvent e = new DatabaseSequenceEvent(seq);
        for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
            cur.sequenceDropped(e);
        }
    }

    public void dropTable(String name) throws AxionException {
        Table table;
        String upName = name.toUpperCase();
        if (this._tables.containsKey(upName)) {
            table = (Table)this._tables.remove(upName);
            Iterator i = table.getIndices();
            ArrayList indexesToDrop = new ArrayList();
            while (i.hasNext()) {
                indexesToDrop.add(i.next());
            }
            i = indexesToDrop.iterator();
            while (i.hasNext()) {
                this.dropIndex(((Index)i.next()).getName());
            }
            for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
                cur.tableDropped(new DatabaseModifiedEvent(table));
            }
        } else {
            throw new AxionException("No table " + upName + " found");
        }
        table.drop();
    }

    public DatabaseLink getDatabaseLink(String name) {
        return (DatabaseLink)this._databaseLink.get(name.toUpperCase());
    }

    public List getDatabaseModificationListeners() {
        return this._listeners;
    }

    public DataType getDataType(String name) {
        DataType type = (DataType)this._dataTypes.get(name.toUpperCase());
        if (type instanceof LOBType) {
            type = ((DataTypeFactory)((Object)type)).makeNewInstance();
        }
        return type;
    }

    public List getDependentExternalDBTable(String name) {
        String upName = name.toUpperCase();
        Iterator i = this.getTables();
        ArrayList<ExternalTable> tables = new ArrayList<ExternalTable>();
        while (i.hasNext()) {
            ExternalTable et;
            Table t = (Table)i.next();
            if (t instanceof ExternalDatabaseTable) {
                et = (ExternalDatabaseTable)t;
                if (!upName.equals(((ExternalDatabaseTable)et).getDBLinkName())) continue;
                tables.add(et);
                continue;
            }
            if (!(t instanceof ExternalAxionDBTable) || !upName.equals(((ExternalAxionDBTable)(et = (ExternalAxionDBTable)t)).getDBLinkName())) continue;
            tables.add(et);
        }
        return tables;
    }

    public List getDependentViews(String tableName) {
        String upName = tableName.toUpperCase();
        Iterator i = this.getTables();
        ArrayList<Table> views = new ArrayList<Table>();
        block0: while (i.hasNext()) {
            Table t = (Table)i.next();
            if (!(t instanceof TableView)) continue;
            Iterator i2 = ((TableView)t).getTables();
            while (i2.hasNext()) {
                String tName = ((TableIdentifier)i2.next()).getTableName();
                if (!upName.equals(tName)) continue;
                views.add(t);
                continue block0;
            }
        }
        return views;
    }

    public ConcreteFunction getFunction(String name) {
        FunctionFactory factory = (FunctionFactory)this._functions.get(name.toUpperCase());
        if (null != factory) {
            return factory.makeNewInstance();
        }
        return null;
    }

    public Object getGlobalVariable(String key) {
        return this._globalVariables.get(key.toUpperCase());
    }

    public IndexFactory getIndexFactory(String name) {
        return (IndexFactory)this._indexTypes.get(name.toUpperCase());
    }

    public String getName() {
        return this._name;
    }

    public Sequence getSequence(String name) {
        return (Sequence)this._sequences.get(name.toUpperCase());
    }

    public Table getTable(String name) throws AxionException {
        String upName = name.toUpperCase();
        return (Table)this._tables.get(upName);
    }

    public Table getTable(TableIdentifier table) throws AxionException {
        return (Table)this._tables.get(table.getTableName());
    }

    public TableFactory getTableFactory(String name) {
        return (TableFactory)this._tableTypes.get(name.toUpperCase());
    }

    public TransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    public boolean hasDatabaseLink(String name) throws AxionException {
        return this.getDatabaseLink(name) != null;
    }

    public boolean hasIndex(String name) throws AxionException {
        return this._indices.containsKey(name);
    }

    public boolean hasSequence(String name) throws AxionException {
        return this.getSequence(name) != null;
    }

    public boolean hasTable(String name) throws AxionException {
        return this.getTable(name) != null;
    }

    public boolean hasTable(TableIdentifier id) throws AxionException {
        return this.getTable(id) != null;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void migrate(int version) throws AxionException {
    }

    public void remount(File newdir) throws AxionException {
        for (Table table : this._tables.values()) {
            table.remount(new File(newdir, table.getName()), false);
        }
    }

    public void removeDatabaseModificationListener(DatabaseModificationListener l) {
        this._listeners.remove(l);
    }

    public void renameTable(String oldName, String newName, Properties newTableProp) throws AxionException {
        String upOldName = oldName.toUpperCase();
        String upNewName = newName.toUpperCase();
        if (this._tables.containsKey(upOldName)) {
            Table table = (Table)this._tables.remove(upOldName);
            for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
                cur.tableDropped(new DatabaseModifiedEvent(table));
            }
            if (table instanceof BaseFlatfileTable) {
                ((BaseFlatfileTable)table).rename(upOldName, upNewName, newTableProp);
            } else {
                table.rename(upOldName, upNewName);
            }
            this._tables.put(upNewName, table);
            table.addTableModificationListener((TableModificationListener)((Object)this._colUpd));
            for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
                cur.tableAdded(new DatabaseModifiedEvent(table));
            }
        } else {
            throw new AxionException("No table " + upOldName + " found");
        }
    }

    public void renameTable(String oldName, String newName) throws AxionException {
        this.renameTable(oldName, newName, null);
    }

    public Selectable resolveSelectSelectable(SubSelectCommand select, TableIdentifier[] tables) {
        select.setDB(this);
        select.setParentTables(tables);
        return select;
    }

    public void shutdown() throws AxionException {
        this.checkpoint();
        for (Table table : this._tables.values()) {
            table.shutdown();
        }
        Databases.forgetDatabase(this.getName());
    }

    public void tableAltered(Table t) throws AxionException {
        for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
            DatabaseModifiedEvent e = new DatabaseModifiedEvent(t);
            cur.tableDropped(e);
            cur.tableAdded(e);
        }
    }

    protected void createMetaDataTables() throws AxionException {
        Table columns = null;
        columns = this.createSystemTable("AXION_COLUMNS");
        columns.addColumn(new Column("TABLE_CAT", new StringType()));
        columns.addColumn(new Column("TABLE_SCHEM", new StringType()));
        columns.addColumn(new Column("TABLE_NAME", new StringType()));
        columns.addColumn(new Column("COLUMN_NAME", new StringType()));
        columns.addColumn(new Column("DATA_TYPE", new ShortType()));
        columns.addColumn(new Column("TYPE_NAME", new StringType()));
        columns.addColumn(new Column("COLUMN_SIZE", new IntegerType()));
        columns.addColumn(new Column("BUFFER_LENGTH", new IntegerType()));
        columns.addColumn(new Column("DECIMAL_DIGITS", new IntegerType()));
        columns.addColumn(new Column("NUM_PREC_RADIX", new IntegerType()));
        columns.addColumn(new Column("NULLABLE", new IntegerType()));
        columns.addColumn(new Column("REMARKS", new StringType()));
        columns.addColumn(new Column("COLUMN_DEF", new StringType()));
        columns.addColumn(new Column("SQL_DATA_TYPE", new IntegerType()));
        columns.addColumn(new Column("SQL_DATETIME_SUB", new IntegerType()));
        columns.addColumn(new Column("CHAR_OCTET_LENGTH", new IntegerType()));
        columns.addColumn(new Column("ORDINAL_POSITION", new IntegerType()));
        columns.addColumn(new Column("IS_NULLABLE", new StringType()));
        columns.addColumn(new Column("SCOPE_CATALOG", new StringType()));
        columns.addColumn(new Column("SCOPE_SCHEMA", new StringType()));
        columns.addColumn(new Column("SCOPE_TABLE", new StringType()));
        columns.addColumn(new Column("SOURCE_DATA_TYPE", new ShortType()));
        this.addDatabaseModificationListener(this._colUpd);
        this.addTable(columns);
        Table tables = null;
        AxionTablesMetaTableUpdater updTables = new AxionTablesMetaTableUpdater(this);
        tables = this.createSystemTable("AXION_TABLES");
        tables.addColumn(new Column("TABLE_CAT", new StringType()));
        tables.addColumn(new Column("TABLE_SCHEM", new StringType()));
        tables.addColumn(new Column("TABLE_NAME", new StringType()));
        tables.addColumn(new Column("TABLE_TYPE", new StringType()));
        tables.addColumn(new Column("REMARKS", new StringType()));
        Row row = updTables.createRowForAddedTable(columns);
        tables.addRow(row);
        this.addDatabaseModificationListener(updTables);
        this.addTable(tables);
        Table tableTypes = this.createSystemTable("AXION_TABLE_TYPES");
        tableTypes.addColumn(new Column("TABLE_TYPE", new StringType()));
        String[] types = new String[]{"TABLE", "SYSTEM TABLE"};
        for (int i = 0; i < types.length; ++i) {
            SimpleRow row2 = new SimpleRow(1);
            row2.set(0, types[i]);
            tableTypes.addRow(row2);
        }
        this.addTable(tableTypes);
        Table catalogs = this.createSystemTable("AXION_CATALOGS");
        catalogs.addColumn(new Column("TABLE_CAT", new StringType()));
        SimpleRow row3 = new SimpleRow(1);
        row3.set(0, "");
        catalogs.addRow(row3);
        this.addTable(catalogs);
        Table schemata = this.createSystemTable("AXION_SCHEMATA");
        schemata.addColumn(new Column("TABLE_CAT", new StringType()));
        schemata.addColumn(new Column("TABLE_SCHEM", new StringType()));
        row3 = new SimpleRow(2);
        row3.set(0, "");
        row3.set(1, "");
        schemata.addRow(row3);
        this.addTable(schemata);
        Table types2 = this.createSystemTable("AXION_TYPES");
        types2.addColumn(new Column("TYPE_NAME", new StringType()));
        types2.addColumn(new Column("DATA_TYPE", new ShortType()));
        types2.addColumn(new Column("PRECISION", new IntegerType()));
        types2.addColumn(new Column("LITERAL_PREFIX", new StringType()));
        types2.addColumn(new Column("LITERAL_SUFFIX", new StringType()));
        types2.addColumn(new Column("CREATE_PARAMS", new StringType()));
        types2.addColumn(new Column("NULLABLE", new IntegerType()));
        types2.addColumn(new Column("CASE_SENSITIVE", new BooleanType()));
        types2.addColumn(new Column("SEARCHABLE", new ShortType()));
        types2.addColumn(new Column("UNSIGNED_ATTRIBUTE", new BooleanType()));
        types2.addColumn(new Column("FIXED_PREC_SCALE", new BooleanType()));
        types2.addColumn(new Column("AUTO_INCREMENT", new BooleanType()));
        types2.addColumn(new Column("LOCAL_TYPE_NAME", new StringType()));
        types2.addColumn(new Column("MINIMUM_SCALE", new ShortType()));
        types2.addColumn(new Column("MAXIMUM_SCALE", new ShortType()));
        types2.addColumn(new Column("SQL_DATA_TYPE", new IntegerType()));
        types2.addColumn(new Column("SQL_DATETIME_SUB", new IntegerType()));
        types2.addColumn(new Column("NUM_PREC_RADIX", new IntegerType()));
        this.addTable(types2);
        this.addDatabaseModificationListener(new AxionTypesMetaTableUpdater(this));
        Table seqTable = this.createSystemTable("AXION_SEQUENCES");
        seqTable.addColumn(new Column("SEQUENCE_NAME", new StringType()));
        seqTable.addColumn(new Column("SEQUENCE_VALUE", new IntegerType()));
        this.addTable(seqTable);
        this.addDatabaseModificationListener(this._seqUpd);
        Table tableProps = this.createSystemTable("AXION_TABLE_PROPERTIES");
        tableProps.addColumn(new Column("TABLE_NAME", new StringType()));
        tableProps.addColumn(new Column("PROPERTY_NAME", new StringType()));
        tableProps.addColumn(new Column("PROPERTY_VALUE", new StringType()));
        this.addTable(tableProps);
        this.addDatabaseModificationListener(new AxionTablePropertiesMetaTableUpdater(this));
        Table tableLinks = this.createSystemTable(SYSTABLE_DB_LINKS);
        tableLinks.addColumn(new Column("LINK_NAME", new StringType()));
        tableLinks.addColumn(new Column("LINK_URL", new StringType()));
        tableLinks.addColumn(new Column("LINK_USERNAME", new StringType()));
        this.addTable(tableLinks);
        this.addDatabaseModificationListener(new AxionDBLinksMetaTableUpdater(this));
        Table tableIndices = this.createSystemTable(SYSTABLE_INDEX_INFO);
        tableIndices.addColumn(new Column("TABLE_CAT", new StringType()));
        tableIndices.addColumn(new Column("TABLE_SCHEM", new StringType()));
        tableIndices.addColumn(new Column("TABLE_NAME", new StringType()));
        tableIndices.addColumn(new Column("NON_UNIQUE", new BooleanType()));
        tableIndices.addColumn(new Column("INDEX_QUALIFIER", new StringType()));
        tableIndices.addColumn(new Column("INDEX_NAME", new StringType()));
        tableIndices.addColumn(new Column("TYPE", new ShortType()));
        tableIndices.addColumn(new Column("ORDINAL_POSITION", new ShortType()));
        tableIndices.addColumn(new Column("COLUMN_NAME", new StringType()));
        tableIndices.addColumn(new Column("ASC_OR_DESC", new StringType()));
        tableIndices.addColumn(new Column("CARDINALITY", new IntegerType()));
        tableIndices.addColumn(new Column("PAGES", new IntegerType()));
        tableIndices.addColumn(new Column("FILTER_CONDITION", new StringType()));
        tableIndices.addColumn(new Column("INDEX_TYPE", new StringType()));
        this.addTable(tableIndices);
    }

    protected abstract Table createSystemTable(String var1);

    protected int getSequenceCount() {
        return this._sequences.size();
    }

    protected Iterator getSequences() {
        return this._sequences.values().iterator();
    }

    protected Iterator getTables() {
        return this._tables.values().iterator();
    }

    protected void loadProperties(Properties props) throws AxionException {
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.startsWith("type.")) {
                this.addDataType(key.substring("type.".length()), props.getProperty(key));
                continue;
            }
            if (key.startsWith("function.")) {
                this.addFunction(key.substring("function.".length()), props.getProperty(key));
                continue;
            }
            if (key.startsWith("index.")) {
                this.addIndexType(key.substring("index.".length()), props.getProperty(key));
                continue;
            }
            if (key.startsWith("table.")) {
                this.addTableType(key.substring("table.".length()), props.getProperty(key));
                continue;
            }
            if (key.equals("readonly") || key.equals("database.readonly")) {
                String val = props.getProperty(key);
                if ("yes".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val)) {
                    this._readOnly = true;
                    continue;
                }
                this._readOnly = false;
                continue;
            }
            if (key.startsWith("database.timezone")) {
                TimestampType.setTimeZone(props.getProperty(key));
                DateType.setTimeZone(props.getProperty(key));
                TimeType.setTimeZone(props.getProperty(key));
                continue;
            }
            if (key.startsWith("database.")) {
                this._globalVariables.put(key.substring("database.".length()).toUpperCase(), props.getProperty(key));
                continue;
            }
            _log.log(Level.WARNING, "Unrecognized property \"" + key + "\".");
        }
    }

    private void addDataType(String typename, DataTypeFactory factory) throws AxionException {
        this.assertNotNull(typename, factory);
        if (null != this._dataTypes.get(typename.toUpperCase())) {
            throw new AxionException("A type named \"" + typename + "\" already exists (" + this._dataTypes.get(typename.toUpperCase()) + ")");
        }
        _log.log(Level.FINE, "Adding type \"" + typename + "\" (" + factory + ").");
        DataType type = factory.makeNewInstance();
        typename = typename.toUpperCase();
        this._dataTypes.put(typename, type);
        DatabaseTypeEvent e = new DatabaseTypeEvent(typename, type);
        for (DatabaseModificationListener cur : this.getDatabaseModificationListeners()) {
            cur.typeAdded(e);
        }
    }

    private void addDataType(String typename, String factoryclassname) throws AxionException {
        this.assertNotNull(typename, factoryclassname);
        try {
            DataTypeFactory factory = (DataTypeFactory)this.getInstanceForClassName(factoryclassname);
            this.addDataType(typename, factory);
        }
        catch (ClassCastException e) {
            throw new AxionException("Expected DataType for \"" + factoryclassname + "\".");
        }
    }

    private void addFunction(String fnname, FunctionFactory factory) throws AxionException {
        this.assertNotNull(fnname, factory);
        if (null != this._functions.get(fnname.toUpperCase())) {
            throw new AxionException("A function named \"" + fnname + "\" already exists (" + this._functions.get(fnname.toUpperCase()) + ")");
        }
        _log.log(Level.FINE, "Adding function \"" + fnname + "\" (" + factory + ").");
        this._functions.put(fnname.toUpperCase(), factory);
    }

    private void addFunction(String fnname, String factoryclassname) throws AxionException {
        this.assertNotNull(fnname, factoryclassname);
        try {
            FunctionFactory factory = (FunctionFactory)this.getInstanceForClassName(factoryclassname);
            this.addFunction(fnname, factory);
        }
        catch (ClassCastException e) {
            throw new AxionException("Expected FunctionFactory for \"" + factoryclassname + "\".");
        }
    }

    private void addIndexMetaEntry(Index index, Table table) throws AxionException {
        SimpleRow row = new SimpleRow(14);
        row.set(0, null);
        row.set(1, null);
        row.set(2, table.getName());
        row.set(3, index.isUnique());
        row.set(4, null);
        row.set(5, index.getName());
        row.set(6, new Short(3));
        row.set(7, Short.valueOf("1"));
        row.set(8, index.getIndexedColumn().getName());
        row.set(9, null);
        row.set(10, new Short(Short.MAX_VALUE));
        row.set(11, new Short(Short.MAX_VALUE));
        row.set(12, null);
        row.set(13, index instanceof BaseBTreeIndex ? "BTREE" : "ARRAY");
        this.getTable(SYSTABLE_INDEX_INFO).addRow(row);
    }

    private void addIndexType(String typename, IndexFactory factory) throws AxionException {
        this.assertNotNull(typename, factory);
        if (null != this._indexTypes.get(typename.toUpperCase())) {
            throw new AxionException("An index type named \"" + typename + "\" already exists (" + this._indexTypes.get(typename.toUpperCase()) + ")");
        }
        _log.log(Level.FINE, "Adding index type \"" + typename + "\" (" + factory + ").");
        this._indexTypes.put(typename.toUpperCase(), factory);
    }

    private void addIndexType(String typename, String factoryclassname) throws AxionException {
        this.assertNotNull(typename, factoryclassname);
        try {
            IndexFactory factory = (IndexFactory)this.getInstanceForClassName(factoryclassname);
            this.addIndexType(typename, factory);
        }
        catch (ClassCastException e) {
            throw new AxionException("Expected IndexFactory for \"" + factoryclassname + "\".");
        }
    }

    private void addTableType(String typename, String factoryclassname) throws AxionException {
        if (null == typename || null == factoryclassname) {
            throw new AxionException("Neither argument can be null.");
        }
        try {
            TableFactory factory = (TableFactory)this.getInstanceForClassName(factoryclassname);
            this.addTableType(typename, factory);
        }
        catch (ClassCastException e) {
            throw new AxionException("Expected IndexFactory for \"" + factoryclassname + "\".");
        }
    }

    private void addTableType(String typename, TableFactory factory) throws AxionException {
        if (null == typename || null == factory) {
            throw new AxionException("Neither argument can be null.");
        }
        if (null != this._tableTypes.get(typename.toUpperCase())) {
            throw new AxionException("An table type named \"" + typename + "\" already exists (" + this._tableTypes.get(typename.toUpperCase()) + ")");
        }
        _log.log(Level.FINE, "Adding table type \"" + typename + "\" (" + factory + ").");
        this._tableTypes.put(typename.toUpperCase(), factory);
    }

    private void assertNotNull(Object obj1, Object obj2) throws AxionException {
        if (null == obj1 || null == obj2) {
            throw new AxionException("Neither argument can be null.");
        }
    }

    private Object getInstanceForClassName(String classname) throws AxionException {
        try {
            Class<?> clazz = Class.forName(classname);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Class \"" + classname + "\" not found.");
        }
        catch (InstantiationException e) {
            throw new AxionException("Unable to instantiate class \"" + classname + "\" via a no-arg constructor.");
        }
        catch (IllegalAccessException e) {
            throw new AxionException("IllegalAccessException trying to instantiate class \"" + classname + "\" via a no-arg constructor.");
        }
    }

    private void removeIndexMetaEntry(Index index) throws AxionException {
        FunctionIdentifier fnIndexName = new FunctionIdentifier("=");
        fnIndexName.addArgument(new ColumnIdentifier("INDEX_NAME"));
        fnIndexName.addArgument(new Literal(index.getName()));
        DeleteCommand cmd = new DeleteCommand(SYSTABLE_INDEX_INFO, (Selectable)fnIndexName);
        try {
            cmd.execute(this);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to remove mention of index in system tables", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized Properties getBaseProperties() {
        if (null == _props) {
            _props = new Properties();
            InputStream in = null;
            try {
                in = BaseDatabase.getBasePropertyStream();
                if (null != in) {
                    _props.load(in);
                } else {
                    _log.log(Level.WARNING, "Could not find axiondb.properties on the classpath.");
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Exception while base properties", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return _props;
    }

    private static InputStream getBasePropertyStream() {
        InputStream in = BaseDatabase.getBasePropertyStreamFromProperty();
        if (null == in) {
            in = BaseDatabase.getBasePropertyStreamFromClassLoader();
        }
        if (null == in) {
            in = BaseDatabase.getBasePropertyStreamFromContextClassLoader();
        }
        return in;
    }

    private static InputStream getBasePropertyStreamFromClassLoader() {
        try {
            return BaseDatabase.getPropertyStream(BaseDatabase.class.getClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static InputStream getBasePropertyStreamFromContextClassLoader() {
        try {
            return BaseDatabase.getPropertyStream(Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static InputStream getBasePropertyStreamFromProperty() {
        FileInputStream in = null;
        String propfile = null;
        try {
            propfile = System.getProperty("org.axiondb.engine.BaseDatabase.properties");
        }
        catch (Throwable t) {
            propfile = null;
        }
        if (null != propfile) {
            try {
                File file = new File(propfile);
                if (file.exists()) {
                    in = new FileInputStream(file);
                }
            }
            catch (IOException e) {
                in = null;
            }
        }
        return in;
    }

    private static InputStream getPropertyStream(ClassLoader classLoader) {
        InputStream in = null;
        if (null != classLoader && null == (in = classLoader.getResourceAsStream("org/axiondb/axiondb.properties"))) {
            in = classLoader.getResourceAsStream("axiondb.properties");
        }
        return in;
    }
}

