/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.constraints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Index;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.constraints.BaseSelectableBasedConstraint;
import org.axiondb.engine.rowiterators.ChangingIndexedRowIterator;
import org.axiondb.engine.rowiterators.IndexNestedLoopJoinedRowIterator;
import org.axiondb.engine.rows.JoinedRow;
import org.axiondb.event.RowEvent;
import org.axiondb.event.RowInsertedEvent;
import org.axiondb.functions.EqualFunction;

public class UniqueConstraint
extends BaseSelectableBasedConstraint {
    private Set fkSet;
    private static final long serialVersionUID = -54506312013696264L;

    public UniqueConstraint(String name) {
        this(name, "UNIQUE");
    }

    public UniqueConstraint(String name, String type) {
        super(name, type);
    }

    public boolean evaluate(RowEvent event) throws AxionException {
        return this.evaluate(event, event.getTable().makeRowDecorator(), false);
    }

    public boolean evaluate(RowEvent event, RowDecorator dec) throws AxionException {
        return this.evaluate(event, dec, false);
    }

    public boolean evaluate(RowEvent event, RowDecorator dec, boolean wasDeferred) throws AxionException {
        if (null == event.getNewRow()) {
            return true;
        }
        Table table = event.getTable();
        dec.setRow(event.getNewRow());
        ArrayList<Object> values = new ArrayList<Object>(this.getSelectableCount());
        int c = this.getSelectableCount();
        for (int i = 0; i < c; ++i) {
            values.add(this.getSelectable(i).evaluate(dec));
        }
        int acceptableRowId = -1;
        if (null != event.getOldRow()) {
            acceptableRowId = event.getOldRow().getIdentifier();
        } else if (this.isDeferred() || wasDeferred) {
            acceptableRowId = event.getNewRow().getIdentifier();
        }
        RowIterator matching = table.getMatchingRows(this.getSelectableList(), values, true);
        while (matching.hasNext()) {
            Row row = matching.next();
            if (this.isDeferred() && matching.hasNext()) {
                return false;
            }
            if (-1 == acceptableRowId) {
                return false;
            }
            if (row.getIdentifier() == acceptableRowId) continue;
            return false;
        }
        return true;
    }

    public boolean evaluate(RowIterator oldRows, RowIterator newRows, Table table) throws AxionException {
        if (null == newRows || newRows.isEmpty()) {
            return true;
        }
        Selectable sel = this.getSelectable(0);
        if (sel instanceof ColumnIdentifier) {
            boolean update = oldRows != null;
            String key = sel.getName();
            int colPos = table.getColumnIndex(key);
            Index index = table.getIndexForColumn(table.getColumn(key));
            ChangingIndexedRowIterator currentRows = new ChangingIndexedRowIterator(index, table, new EqualFunction());
            IndexNestedLoopJoinedRowIterator matching = new IndexNestedLoopJoinedRowIterator(newRows, colPos, currentRows, colPos, false, false);
            int lastId = -1;
            matching.reset();
            while (matching.hasNext()) {
                JoinedRow joinRow = (JoinedRow)matching.next();
                if (!update && !this.checkOtherColumns(joinRow, table)) {
                    return false;
                }
                Row oldRow = joinRow.getRow(0);
                int acceptableRowId = oldRow.getIdentifier();
                if (-1 == acceptableRowId) {
                    return false;
                }
                if (acceptableRowId == lastId) {
                    return false;
                }
                lastId = oldRow.getIdentifier();
            }
        } else {
            newRows.reset();
            RowDecorator dec = table.makeRowDecorator();
            RowIterator iter = newRows;
            while (iter.hasNext()) {
                Row row = iter.next();
                RowInsertedEvent event = new RowInsertedEvent(table, null, row);
                if (this.evaluate(event, dec, true)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkOtherColumns(JoinedRow joinRow, Table table) throws AxionException {
        int I = this.getSelectableCount();
        for (int i = 1; i < I; ++i) {
            String key = this.getSelectable(i).getName();
            int colPos = table.getColumnIndex(key);
            Row oldRow = joinRow.getRow(0);
            Row newRow = joinRow.getRow(1);
            if (!oldRow.get(colPos).equals(newRow.get(colPos))) continue;
            return false;
        }
        return true;
    }

    public void addFK(String name) {
        if (this.fkSet == null) {
            this.fkSet = new HashSet(4);
        }
        this.fkSet.add(name);
    }

    public Iterator getFKs() {
        if (this.fkSet == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.fkSet.iterator();
    }
}

