/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class XmlStreamReader {
    protected final XmlPullParser xpp;

    public XmlStreamReader(XmlPullParser xpp) {
        this.xpp = xpp;
    }

    protected void ensureEndTag(String name) throws XmlPullParserException, IOException {
        int nextTag = this.xpp.nextTag();
        if (nextTag != 3 && !name.equals(this.xpp.getName())) {
            throw new IllegalStateException("Unexpected event. Expecting " + name + " end tag." + this.xpp.getName());
        }
    }

    protected int nextEvent() throws XmlPullParserException, IOException {
        int eventType = -1;
        while ((eventType = this.xpp.next()) == 4) {
        }
        return eventType;
    }

    protected String getAttributeValue(String attrName) {
        return this.xpp.getAttributeValue("", attrName);
    }

    protected int getAttributeIntValue(String attrName) {
        return Integer.parseInt(this.getAttributeValue(attrName));
    }

    protected boolean getAttributeBoolValue(String attrName) {
        return this.getAttributeValue(attrName).equals("true");
    }
}

