/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model.impl;

import com.sun.jbi.workflow.model.Message;
import com.sun.jbi.workflow.model.ModelElement;
import com.sun.jbi.workflow.model.ModelException;
import com.sun.jbi.workflow.model.Notification;
import com.sun.jbi.workflow.model.PartnerLinkType;
import com.sun.jbi.workflow.model.Recipient;
import com.sun.jbi.workflow.model.Subject;
import com.sun.jbi.workflow.model.Task;
import com.sun.jbi.workflow.model.impl.MessageImpl;
import com.sun.jbi.workflow.model.impl.ModelElementImpl;
import com.sun.jbi.workflow.model.impl.RecipientImpl;
import com.sun.jbi.workflow.model.impl.SubjectImpl;
import com.sun.jbi.workflow.model.impl.Util;
import com.sun.jbi.workflow.model.xmlbeans.TMessage;
import com.sun.jbi.workflow.model.xmlbeans.TNotification;
import com.sun.jbi.workflow.model.xmlbeans.TRecipient;
import com.sun.jbi.workflow.model.xmlbeans.TSubject;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationImpl
extends ModelElementImpl
implements Notification {
    private TNotification mNotificationType;
    private Operation mOperation;
    private PartnerLinkType mPartnerLinkType;
    private List<Recipient> recipients = new ArrayList<Recipient>();

    public NotificationImpl(TNotification notification, ModelElement parent) {
        super((XmlObject)notification, parent);
        this.mNotificationType = notification;
    }

    @Override
    public QName getQName() {
        QName qName = null;
        String name = this.getName();
        String ns = Util.getTargetNamesapce(this);
        if (name != null) {
            qName = new QName(ns, name);
        }
        return qName;
    }

    @Override
    public String getName() {
        return this.mNotificationType.getName();
    }

    @Override
    public String getPartnerLink() {
        return this.mNotificationType.getPartnerLink();
    }

    @Override
    public String getRole() {
        return this.mNotificationType.getRole();
    }

    @Override
    public Operation getWSDLOperation() throws ModelException {
        if (this.mOperation != null) {
            return this.mOperation;
        }
        this.mOperation = Util.getWSDLOperation(this.mNotificationType.getOperation(), this);
        return this.mOperation;
    }

    @Override
    public PartnerLinkType getWSDLPartnerLinkType() throws ModelException {
        if (this.mPartnerLinkType != null) {
            return this.mPartnerLinkType;
        }
        this.mPartnerLinkType = Util.getWSDLPartnerLinkType(this.mNotificationType.getPartnerLinkType(), this);
        return this.mPartnerLinkType;
    }

    @Override
    public PortType getPortType() throws ModelException {
        PortType portType = Util.getPortType(this.mNotificationType.getPartnerLinkType(), this.mNotificationType.getRole(), this);
        return portType;
    }

    @Override
    public List<Recipient> getRecipients() {
        if (this.recipients.size() > 0) {
            return this.recipients;
        }
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        List rList = this.mNotificationType.getRecipientList();
        for (TRecipient r : rList) {
            RecipientImpl recipient = new RecipientImpl(r, (ModelElement)this);
            recipients.add(recipient);
        }
        return recipients;
    }

    @Override
    public Subject getSubject() {
        TSubject sub = this.mNotificationType.getSubject();
        SubjectImpl subject = new SubjectImpl(sub, (ModelElement)this);
        return subject;
    }

    @Override
    public Message getMessage() {
        TMessage msg = this.mNotificationType.getMessage();
        MessageImpl message = new MessageImpl(msg, (ModelElement)this);
        return message;
    }

    @Override
    public Task getTask() {
        return (Task)this.getParent();
    }
}

