/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.service.connector.JNIConnectionHandler;
import org.apache.tomcat.util.StringManager;

class JNIRequestAdapter
extends RequestImpl {
    static StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    ContextManager contextM;
    boolean shutdown = false;
    JNIConnectionHandler h;
    long s;
    long l;

    public JNIRequestAdapter(ContextManager cm, JNIConnectionHandler h) {
        this.contextM = cm;
        this.h = h;
    }

    public int doRead() throws IOException {
        byte[] b = new byte[1];
        int rc = this.doRead(b, 0, 1);
        if (rc <= 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        int rc = 0;
        while (rc == 0) {
            rc = this.h.read(this.s, this.l, b, off, len);
            if (rc != 0) continue;
            Thread.currentThread();
            Thread.yield();
        }
        return rc;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.contentLength <= 0) {
            throw new IOException("Empty input stream");
        }
        this.in = new BufferedServletInputStream(this);
        return this.in;
    }

    protected void readNextRequest(long s, long l) throws IOException {
        int idQ;
        String[] env = new String[15];
        int i = 0;
        this.s = s;
        this.l = l;
        i = 0;
        while (i < 12) {
            env[i] = null;
            ++i;
        }
        if (this.h.readEnvironment(s, l, env) > 0) {
            this.method = env[0];
            this.requestURI = env[1];
            this.queryString = env[2];
            this.remoteAddr = env[3];
            this.remoteHost = env[4];
            this.serverName = env[5];
            this.serverPort = Integer.parseInt(env[6]);
            this.authType = env[7];
            this.remoteUser = env[8];
            this.scheme = env[9];
            this.protocol = env[10];
            if (this.scheme.equalsIgnoreCase("https")) {
                if (env[12] != null) {
                    this.attributes.put("javax.servlet.request.X509Certificate", env[12]);
                }
                if (env[13] != null) {
                    this.attributes.put("javax.servlet.request.cipher_suite", env[13]);
                }
                if (env[14] != null) {
                    this.attributes.put("javax.servlet.request.ssl_session", env[14]);
                }
            }
        } else {
            throw new IOException("Error: JNI implementation error");
        }
        int nheaders = this.h.getNumberOfHeaders(s, l);
        if (nheaders > 0) {
            String[] names = new String[nheaders];
            String[] values = new String[nheaders];
            if (this.h.readHeaders(s, l, names, values) > 0) {
                i = 0;
                while (i < nheaders) {
                    this.headers.putHeader(names[i].toLowerCase(), values[i]);
                    ++i;
                }
            } else {
                throw new IOException("Error: JNI implementation error");
            }
        }
        if ((idQ = this.requestURI.indexOf("?")) > -1) {
            this.requestURI = this.requestURI.substring(0, idQ);
        }
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
    }
}

