/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;

class JspInfo {
    String uri;
    int version;
    String pkg;
    String pkgDir;
    String baseClassN;
    String fullClassN;
    String classN;
    String ext;
    String outputDir;
    String javaFilePath;
    String realClassPath;
    String mapPath;
    File jspSource;
    long compileTime;

    JspInfo(Request req) {
        this.init(req);
    }

    void init(Request req) {
        int extIdx;
        this.uri = req.getServletPath();
        Context ctx = req.getContext();
        this.outputDir = ctx.getWorkDir().getAbsolutePath();
        String jspFilePath = ctx.getRealPath(this.uri);
        this.jspSource = new File(jspFilePath);
        int lastComp = this.uri.lastIndexOf("/");
        String endUnproc = null;
        if (lastComp > 0) {
            this.pkgDir = this.uri.substring(1, lastComp);
            endUnproc = this.uri.substring(lastComp + 1);
        } else {
            endUnproc = this.uri.substring(1);
        }
        if (this.pkgDir != null) {
            this.pkgDir = this.pkgDir.replace('.', '_');
            this.pkg = this.pkgDir.replace('/', '.');
        }
        if ((extIdx = endUnproc.lastIndexOf(".")) >= 0) {
            this.baseClassN = endUnproc.substring(0, extIdx);
            this.ext = endUnproc.substring(extIdx);
        } else {
            this.baseClassN = endUnproc;
        }
        this.mapPath = String.valueOf(this.outputDir) + "/" + this.pkgDir + "/" + this.baseClassN + ".ver";
        File mapFile = new File(this.mapPath);
        if (mapFile.exists()) {
            this.readVersion();
            this.updateVersionedPaths();
            this.updateCompileTime();
        } else {
            this.version = 0;
            this.updateVersionedPaths();
        }
    }

    public void nextVersion() {
        ++this.version;
        this.updateVersionedPaths();
    }

    void readVersion() {
        File mapFile = new File(this.mapPath);
        this.version = 0;
        this.compileTime = 0L;
        try {
            FileInputStream fis = new FileInputStream(mapFile);
            this.version = fis.read();
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return String.valueOf(this.uri) + " " + this.version;
    }

    public void touch() {
        this.compileTime = System.currentTimeMillis();
    }

    void updateCompileTime() {
        File f = new File(this.realClassPath);
        this.compileTime = 0L;
        if (!f.exists()) {
            return;
        }
        this.compileTime = f.lastModified();
    }

    void updateVersionedPaths() {
        this.classN = String.valueOf(this.baseClassN) + "_" + this.version;
        this.realClassPath = String.valueOf(this.outputDir) + "/" + this.pkgDir + "/" + this.classN + ".class";
        this.javaFilePath = String.valueOf(this.outputDir) + "/" + this.pkgDir + "/" + this.classN + ".java";
        this.fullClassN = String.valueOf(this.pkg) + "." + this.classN;
        this.writeVersion();
    }

    void writeVersion() {
        File mapFile = new File(this.mapPath);
        try {
            FileOutputStream fis = new FileOutputStream(mapFile);
            fis.write(this.version);
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

