/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.Main;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.parser.DocCommentScanner;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Version;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)JavaCompiler.java\t1.117 07/06/14")
public class JavaCompiler
implements ClassReader.SourceCompleter {
    protected static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    private static final String versionRBName = "com.sun.tools.javac.resources.version";
    private static ResourceBundle versionRB;
    private static CompilePolicy DEFAULT_COMPILE_POLICY;
    public Log log;
    protected TreeMaker make;
    protected ClassReader reader;
    protected ClassWriter writer;
    protected Enter enter;
    protected Symtab syms;
    protected Source source;
    protected Gen gen;
    protected Name.Table names;
    protected Attr attr;
    protected Check chk;
    protected Flow flow;
    TransTypes transTypes;
    Lower lower;
    protected Annotate annotate;
    protected final Name completionFailureName;
    protected Types types;
    protected JavaFileManager fileManager;
    protected Parser.Factory parserFactory;
    protected TaskListener taskListener;
    protected JavaCompiler delegateCompiler;
    protected boolean annotationProcessingOccurred;
    protected boolean implicitSourceFilesRead;
    protected Context context;
    protected Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean stubOutput;
    public boolean attrParseOnly;
    boolean relax;
    public boolean printFlat;
    public String encoding;
    public boolean lineDebugInfo;
    public boolean genEndPos;
    protected boolean devVerbose;
    protected boolean processPcks;
    protected boolean explicitAnnotationProcessingRequested;
    protected CompilePolicy compilePolicy;
    protected ImplicitSourcePolicy implicitSourcePolicy;
    public boolean verboseCompilePolicy;
    public Todo todo;
    private Set<Env<AttrContext>> deferredSugar;
    protected Set<JavaFileObject> inputFiles;
    public boolean keepComments;
    private boolean hasBeenUsed;
    private long start_msec;
    public long elapsed_msec;
    private boolean parseErrors;
    private List<JCTree.JCClassDecl> rootClasses;
    boolean processAnnotations;
    JavacProcessingEnvironment procEnvImpl;

    public static JavaCompiler instance(Context context) {
        JavaCompiler instance = context.get(compilerKey);
        if (instance == null) {
            instance = new JavaCompiler(context);
        }
        return instance;
    }

    public static String version() {
        return JavaCompiler.version("release");
    }

    public static String fullVersion() {
        return JavaCompiler.version("full");
    }

    private static String version(String key) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException e) {
                return Log.getLocalizedString("version.resource.missing", System.getProperty("java.version"));
            }
        }
        try {
            return versionRB.getString(key);
        }
        catch (MissingResourceException e) {
            return Log.getLocalizedString("version.unknown", System.getProperty("java.version"));
        }
    }

    public JavaCompiler(Context context) {
        block3: {
            this.explicitAnnotationProcessingRequested = false;
            this.deferredSugar = new HashSet<Env<AttrContext>>();
            this.inputFiles = new HashSet<JavaFileObject>();
            this.keepComments = false;
            this.hasBeenUsed = false;
            this.start_msec = 0L;
            this.elapsed_msec = 0L;
            this.parseErrors = false;
            this.processAnnotations = false;
            this.procEnvImpl = null;
            this.context = context;
            context.put(compilerKey, this);
            if (context.get(JavaFileManager.class) == null) {
                JavacFileManager.preRegister(context);
            }
            this.names = Name.Table.instance(context);
            this.log = Log.instance(context);
            this.reader = ClassReader.instance(context);
            this.make = TreeMaker.instance(context);
            this.writer = ClassWriter.instance(context);
            this.enter = Enter.instance(context);
            this.todo = Todo.instance(context);
            this.fileManager = context.get(JavaFileManager.class);
            this.parserFactory = Parser.Factory.instance(context);
            try {
                this.syms = Symtab.instance(context);
            }
            catch (Symbol.CompletionFailure ex) {
                this.log.error("cant.access", ex.sym, ex.errmsg);
                if (!(ex instanceof ClassReader.BadClassFile)) break block3;
                throw new Abort();
            }
        }
        this.source = Source.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.taskListener = context.get(TaskListener.class);
        this.reader.sourceCompleter = this;
        Options options = Options.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.sourceOutput = options.get("-printsource") != null;
        this.stubOutput = options.get("-stubs") != null;
        this.relax = options.get("-relax") != null;
        this.printFlat = options.get("-printflat") != null;
        this.attrParseOnly = options.get("-attrparseonly") != null;
        this.encoding = options.get("-encoding");
        this.lineDebugInfo = options.get("-g:") == null || options.get("-g:lines") != null;
        this.genEndPos = options.get("-Xjcov") != null || context.get(DiagnosticListener.class) != null && options.get("backgroundCompilation") == null;
        this.devVerbose = options.get("dev") != null;
        this.processPcks = options.get("process.packages") != null;
        this.verboseCompilePolicy = options.get("verboseCompilePolicy") != null;
        this.compilePolicy = this.attrParseOnly ? CompilePolicy.ATTR_ONLY : CompilePolicy.decode(options.get("compilePolicy"));
        this.implicitSourcePolicy = ImplicitSourcePolicy.decode(options.get("-implicit"));
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString(options.get("failcomplete")) : null;
    }

    public int errorCount() {
        if (this.delegateCompiler != null && this.delegateCompiler != this) {
            return this.delegateCompiler.errorCount();
        }
        return this.log.nerrors;
    }

    protected final <T> List<T> stopIfError(ListBuffer<T> listBuffer) {
        if (this.errorCount() == 0) {
            return listBuffer.toList();
        }
        return List.nil();
    }

    protected final <T> List<T> stopIfError(List<T> list) {
        if (this.errorCount() == 0) {
            return list;
        }
        return List.nil();
    }

    public int warningCount() {
        if (this.delegateCompiler != null && this.delegateCompiler != this) {
            return this.delegateCompiler.warningCount();
        }
        return this.log.nwarnings;
    }

    public boolean parseErrors() {
        return this.parseErrors;
    }

    protected Scanner.Factory getScannerFactory() {
        return Scanner.Factory.instance(this.context);
    }

    public CharSequence readSource(JavaFileObject filename) {
        try {
            this.inputFiles.add(filename);
            return filename.getCharContent(false);
        }
        catch (IOException e) {
            this.log.error("error.reading.file", filename, e.getLocalizedMessage());
            return null;
        }
    }

    protected JCTree.JCCompilationUnit parse(JavaFileObject filename, CharSequence content) {
        long msec = JavaCompiler.now();
        JCTree.JCCompilationUnit tree = this.make.TopLevel(List.<JCTree.JCAnnotation>nil(), null, List.<JCTree>nil());
        if (content != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", filename);
            }
            if (this.taskListener != null) {
                TaskEvent e = new TaskEvent(TaskEvent.Kind.PARSE, filename);
                this.taskListener.started(e);
            }
            int initialErrorCount = this.log.nerrors;
            Scanner scanner = this.getScannerFactory().newScanner(content);
            Parser parser = this.parserFactory.newParser(scanner, this.keepComments(), this.genEndPos);
            tree = parser.compilationUnit();
            this.parseErrors |= this.log.nerrors > initialErrorCount;
            if (this.lineDebugInfo) {
                tree.lineMap = scanner.getLineMap();
            }
            if (this.verbose) {
                this.printVerbose("parsing.done", Long.toString(JavaCompiler.elapsed(msec)));
            }
        }
        tree.sourcefile = filename;
        if (content != null && this.taskListener != null) {
            TaskEvent e = new TaskEvent(TaskEvent.Kind.PARSE, tree);
            this.taskListener.finished(e);
        }
        return tree;
    }

    protected boolean keepComments() {
        return this.keepComments || this.sourceOutput || this.stubOutput;
    }

    @Deprecated
    public JCTree.JCCompilationUnit parse(String filename) throws IOException {
        JavacFileManager fm = (JavacFileManager)this.fileManager;
        return this.parse(fm.getJavaFileObjectsFromStrings(List.of(filename)).iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCCompilationUnit parse(JavaFileObject filename) {
        JavaFileObject prev = this.log.useSource(filename);
        try {
            JCTree.JCCompilationUnit t = this.parse(filename, this.readSource(filename));
            if (t.endPositions != null) {
                this.log.setEndPosTable(filename, t.endPositions);
            }
            JCTree.JCCompilationUnit jCCompilationUnit = t;
            return jCCompilationUnit;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol resolveIdent(String name) {
        if (name.equals("")) {
            return this.syms.errSymbol;
        }
        JavaFileObject prev = this.log.useSource(null);
        try {
            JCTree.JCExpression tree = null;
            for (String s : name.split("\\.", -1)) {
                if (!SourceVersion.isIdentifier(s)) {
                    Symbol.ClassSymbol classSymbol = this.syms.errSymbol;
                    return classSymbol;
                }
                tree = tree == null ? this.make.Ident(this.names.fromString(s)) : this.make.Select(tree, this.names.fromString(s));
            }
            JCTree.JCCompilationUnit toplevel = this.make.TopLevel(List.<JCTree.JCAnnotation>nil(), null, List.<JCTree>nil());
            toplevel.packge = this.syms.unnamedPackage;
            Symbol symbol = this.attr.attribIdent(tree, toplevel);
            return symbol;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaFileObject printSource(Env<AttrContext> env, JCTree.JCClassDecl cdef) throws IOException {
        JavaFileObject outFile = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, cdef.sym.flatname.toString(), JavaFileObject.Kind.SOURCE, null);
        if (this.inputFiles.contains(outFile)) {
            this.log.error(cdef.pos(), "source.cant.overwrite.input.file", outFile);
            return null;
        }
        BufferedWriter out = new BufferedWriter(outFile.openWriter());
        try {
            new Pretty(out, true).printUnit(env.toplevel, cdef);
            if (this.verbose) {
                this.printVerbose("wrote.file", outFile);
            }
        }
        finally {
            out.close();
        }
        return outFile;
    }

    JavaFileObject genCode(Env<AttrContext> env, JCTree.JCClassDecl cdef) throws IOException {
        try {
            if (this.gen.genClass(env, cdef)) {
                return this.writer.writeClass(cdef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow ex) {
            this.log.error(cdef.pos(), "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow ex) {
            this.log.error(cdef.pos(), "limit.string.overflow", ex.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(cdef.pos(), ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol.ClassSymbol c) throws Symbol.CompletionFailure {
        TaskEvent e;
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure(c, "user-selected completion failure by class name");
        }
        JCTree.JCCompilationUnit tree = null;
        JavaFileObject filename = c.classfile;
        JavaFileObject prev = this.log.useSource(filename);
        try {
            if (this.notYetEntered != null) {
                tree = this.notYetEntered.remove(filename);
            }
            if (tree == null) {
                tree = this.parse(filename, filename.getCharContent(false));
            }
        }
        catch (IOException e2) {
            this.log.error("error.reading.file", filename, e2);
            tree = this.make.TopLevel(List.<JCTree.JCAnnotation>nil(), null, List.<JCTree>nil());
            tree.sourcefile = filename;
        }
        finally {
            this.log.useSource(prev);
        }
        if (this.taskListener != null) {
            e = new TaskEvent(TaskEvent.Kind.ENTER, tree);
            this.taskListener.started(e);
        }
        this.enter.complete(List.of(tree), c);
        if (this.taskListener != null) {
            e = new TaskEvent(TaskEvent.Kind.ENTER, tree);
            this.taskListener.finished(e);
        }
        if (this.enter.getEnv(c) == null) {
            boolean isPkgInfo = tree.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            if (isPkgInfo) {
                if (this.enter.getEnv(tree.packge) == null) {
                    String msg = Log.getLocalizedString("file.does.not.contain.package", c.location());
                    throw new ClassReader.BadClassFile(c, filename, msg);
                }
            } else {
                throw new ClassReader.BadClassFile(c, filename, Log.getLocalizedString("file.doesnt.contain.class", c.fullname));
            }
        }
        this.implicitSourceFilesRead = true;
    }

    public void compile(List<JavaFileObject> sourceFileObject) throws Throwable {
        this.compile(sourceFileObject, List.<String>nil(), null);
    }

    public void compile(List<JavaFileObject> sourceFileObjects, List<String> classnames, Iterable<? extends Processor> processors) throws IOException {
        block4: {
            if (processors != null && processors.iterator().hasNext()) {
                this.explicitAnnotationProcessingRequested = true;
            }
            if (this.hasBeenUsed) {
                throw new AssertionError((Object)"attempt to reuse JavaCompiler");
            }
            this.hasBeenUsed = true;
            this.start_msec = JavaCompiler.now();
            try {
                this.initProcessAnnotations(processors);
                this.delegateCompiler = this.processAnnotations(this.enterTrees(this.stopIfError(this.parseFiles(sourceFileObjects))), classnames);
                this.delegateCompiler.compile2();
                this.delegateCompiler.close();
                this.elapsed_msec = this.delegateCompiler.elapsed_msec;
            }
            catch (Abort ex) {
                if (!this.devVerbose) break block4;
                ex.printStackTrace();
            }
        }
    }

    private void compile2() {
        block14: {
            try {
                switch (this.compilePolicy) {
                    case ATTR_ONLY: {
                        this.attribute(this.todo);
                        break;
                    }
                    case CHECK_ONLY: {
                        this.flow(this.attribute(this.todo));
                        break;
                    }
                    case SIMPLE: {
                        this.generate(this.desugar(this.flow(this.attribute(this.todo))));
                        break;
                    }
                    case BY_FILE: {
                        for (List<Env<AttrContext>> list : this.groupByFile(this.flow(this.attribute(this.todo))).values()) {
                            this.generate(this.desugar(list));
                        }
                        break;
                    }
                    case BY_TODO: {
                        while (this.todo.nonEmpty()) {
                            this.generate(this.desugar(this.flow(this.attribute((Env)this.todo.next()))));
                        }
                        break;
                    }
                    default: {
                        assert (false) : "unknown compile policy";
                        break;
                    }
                }
            }
            catch (Abort ex) {
                if (!this.devVerbose) break block14;
                ex.printStackTrace();
            }
        }
        if (this.verbose) {
            this.elapsed_msec = JavaCompiler.elapsed(this.start_msec);
            this.printVerbose("total", Long.toString(this.elapsed_msec));
        }
        this.reportDeferredDiagnostics();
        if (!this.log.hasDiagnosticListener()) {
            this.printCount("error", this.errorCount());
            this.printCount("warn", this.warningCount());
        }
    }

    public List<JCTree.JCCompilationUnit> parseFiles(List<JavaFileObject> fileObjects) throws IOException {
        if (this.errorCount() > 0) {
            return List.nil();
        }
        ListBuffer trees = ListBuffer.lb();
        for (JavaFileObject fileObject : fileObjects) {
            trees.append(this.parse(fileObject));
        }
        return trees.toList();
    }

    public List<JCTree.JCCompilationUnit> enterTrees(List<JCTree.JCCompilationUnit> roots) {
        TaskEvent e;
        if (this.taskListener != null) {
            for (JCTree.JCCompilationUnit unit : roots) {
                e = new TaskEvent(TaskEvent.Kind.ENTER, unit);
                this.taskListener.started(e);
            }
        }
        this.enter.main(roots);
        if (this.taskListener != null) {
            for (JCTree.JCCompilationUnit unit : roots) {
                e = new TaskEvent(TaskEvent.Kind.ENTER, unit);
                this.taskListener.finished(e);
            }
        }
        if (this.sourceOutput || this.stubOutput) {
            ListBuffer cdefs = ListBuffer.lb();
            for (JCTree.JCCompilationUnit unit : roots) {
                List<JCTree> defs = unit.defs;
                while (defs.nonEmpty()) {
                    if (defs.head instanceof JCTree.JCClassDecl) {
                        cdefs.append((JCTree.JCClassDecl)defs.head);
                    }
                    defs = defs.tail;
                }
            }
            this.rootClasses = cdefs.toList();
        }
        return roots;
    }

    public void initNotYetEntered(Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered) {
        this.notYetEntered = notYetEntered;
    }

    public void initProcessAnnotations(Iterable<? extends Processor> processors) {
        Options options = Options.instance(this.context);
        if (options.get("-proc:none") != null) {
            this.processAnnotations = false;
        } else if (this.procEnvImpl == null) {
            this.procEnvImpl = new JavacProcessingEnvironment(this.context, processors);
            this.processAnnotations = this.procEnvImpl.atLeastOneProcessor();
            if (this.processAnnotations) {
                if (this.context.get(Scanner.Factory.scannerFactoryKey) == null) {
                    DocCommentScanner.Factory.preRegister(this.context);
                }
                options.put("save-parameter-names", "save-parameter-names");
                this.reader.saveParameterNames = true;
                this.keepComments = true;
                if (this.taskListener != null) {
                    this.taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
                }
            } else {
                this.procEnvImpl.close();
            }
        }
    }

    public JavaCompiler processAnnotations(List<JCTree.JCCompilationUnit> roots) throws IOException {
        return this.processAnnotations(roots, List.<String>nil());
    }

    public JavaCompiler processAnnotations(List<JCTree.JCCompilationUnit> roots, List<String> classnames) throws IOException {
        if (this.errorCount() != 0 && this.todo.isEmpty()) {
            return this;
        }
        if (!this.processAnnotations) {
            Options options = Options.instance(this.context);
            if (options.get("-proc:only") != null) {
                this.log.warning("proc.proc-only.requested.no.procs", new Object[0]);
                this.todo.clear();
            }
            if (!classnames.isEmpty()) {
                this.log.error("proc.no.explicit.annotation.processing.requested", classnames);
            }
            return this;
        }
        try {
            JavaCompiler c;
            List<Symbol.ClassSymbol> classSymbols = List.nil();
            List<Symbol.PackageSymbol> pckSymbols = List.nil();
            if (!classnames.isEmpty()) {
                if (!this.explicitAnnotationProcessingRequested()) {
                    this.log.error("proc.no.explicit.annotation.processing.requested", classnames);
                    return this;
                }
                boolean errors = false;
                for (String nameStr : classnames) {
                    Symbol sym = this.resolveIdent(nameStr);
                    if (sym == null || sym.kind == 1 && !this.processPcks) {
                        this.log.error("proc.cant.find.class", nameStr);
                        errors = true;
                        continue;
                    }
                    try {
                        if (sym.kind == 1) {
                            sym.complete();
                        }
                        if (sym.exists()) {
                            Name name = this.names.fromString(nameStr);
                            if (sym.kind == 1) {
                                pckSymbols = pckSymbols.prepend((Symbol.PackageSymbol)sym);
                                continue;
                            }
                            classSymbols = classSymbols.prepend((Symbol.ClassSymbol)sym);
                            continue;
                        }
                        assert (sym.kind == 1);
                        this.log.warning("proc.package.does.not.exist", nameStr);
                        pckSymbols = pckSymbols.prepend((Symbol.PackageSymbol)sym);
                    }
                    catch (Symbol.CompletionFailure e) {
                        this.log.error("proc.cant.find.class", nameStr);
                        errors = true;
                    }
                }
                if (errors) {
                    return this;
                }
            }
            if ((c = this.procEnvImpl.doProcessing(this.context, roots, classSymbols, pckSymbols)) != this) {
                c.annotationProcessingOccurred = true;
                this.annotationProcessingOccurred = true;
            }
            return c;
        }
        catch (Symbol.CompletionFailure ex) {
            this.log.error("cant.access", ex.sym, ex.errmsg);
            return this;
        }
    }

    boolean explicitAnnotationProcessingRequested() {
        Options options = Options.instance(this.context);
        return this.explicitAnnotationProcessingRequested || options.get("-processor") != null || options.get("-processorpath") != null || options.get("-proc:only") != null || options.get("-Xprint") != null;
    }

    public List<Env<AttrContext>> attribute(ListBuffer<Env<AttrContext>> envs) {
        ListBuffer results = ListBuffer.lb();
        while (envs.nonEmpty()) {
            results.append(this.attribute(envs.next()));
        }
        return results.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Env<AttrContext> attribute(Env<AttrContext> env) {
        if (this.verboseCompilePolicy) {
            Log.printLines(this.log.noticeWriter, "[attribute " + env.enclClass.sym + "]");
        }
        if (this.verbose) {
            this.printVerbose("checking.attribution", env.enclClass.sym);
        }
        if (this.taskListener != null) {
            TaskEvent e = new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym);
            this.taskListener.started(e);
        }
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            this.attr.attribClass(env.tree.pos(), env.enclClass.sym);
        }
        finally {
            this.log.useSource(prev);
        }
        return env;
    }

    public List<Env<AttrContext>> flow(List<Env<AttrContext>> envs) {
        ListBuffer<Env<AttrContext>> results = ListBuffer.lb();
        List<Env<AttrContext>> l = envs;
        while (l.nonEmpty()) {
            this.flow((Env)l.head, results);
            l = l.tail;
        }
        return this.stopIfError(results);
    }

    public List<Env<AttrContext>> flow(Env<AttrContext> env) {
        ListBuffer<Env<AttrContext>> results = ListBuffer.lb();
        this.flow(env, results);
        return this.stopIfError(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flow(Env<AttrContext> env, ListBuffer<Env<AttrContext>> results) {
        try {
            if (this.errorCount() > 0) {
                return;
            }
            if (this.relax || this.deferredSugar.contains(env)) {
                results.append(env);
                return;
            }
            if (this.verboseCompilePolicy) {
                Log.printLines(this.log.noticeWriter, "[flow " + env.enclClass.sym + "]");
            }
            JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                this.make.at(0);
                TreeMaker localMake = this.make.forToplevel(env.toplevel);
                this.flow.analyzeTree(env.tree, localMake);
                if (this.errorCount() > 0) {
                    return;
                }
                results.append(env);
            }
            finally {
                this.log.useSource(prev);
            }
        }
        finally {
            if (this.taskListener != null) {
                TaskEvent e = new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym);
                this.taskListener.finished(e);
            }
        }
    }

    public List<Pair<Env<AttrContext>, JCTree.JCClassDecl>> desugar(List<Env<AttrContext>> envs) {
        ListBuffer<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results = ListBuffer.lb();
        List<Env<AttrContext>> l = envs;
        while (l.nonEmpty()) {
            this.desugar((Env)l.head, results);
            l = l.tail;
        }
        return this.stopIfError(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void desugar(Env<AttrContext> env, ListBuffer<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results) {
        if (this.errorCount() > 0) {
            return;
        }
        if (this.implicitSourcePolicy == ImplicitSourcePolicy.NONE && !this.inputFiles.contains(env.toplevel.sourcefile)) {
            return;
        }
        if (this.desugarLater(env)) {
            if (this.verboseCompilePolicy) {
                Log.printLines(this.log.noticeWriter, "[defer " + env.enclClass.sym + "]");
            }
            this.todo.append(env);
            return;
        }
        this.deferredSugar.remove(env);
        if (this.verboseCompilePolicy) {
            Log.printLines(this.log.noticeWriter, "[desugar " + env.enclClass.sym + "]");
        }
        JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
        try {
            JCTree untranslated = env.tree;
            this.make.at(0);
            TreeMaker localMake = this.make.forToplevel(env.toplevel);
            if (env.tree instanceof JCTree.JCCompilationUnit) {
                if (!(this.stubOutput || this.sourceOutput || this.printFlat)) {
                    List<JCTree> pdef = this.lower.translateTopLevelClass(env, env.tree, localMake);
                    if (pdef.head != null) {
                        assert (pdef.tail.isEmpty());
                        results.append(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, (JCTree.JCClassDecl)pdef.head));
                    }
                }
                return;
            }
            if (this.stubOutput) {
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                if (untranslated instanceof JCTree.JCClassDecl && this.rootClasses.contains((JCTree.JCClassDecl)untranslated) && ((cdef.mods.flags & 5L) != 0L || cdef.sym.packge().getQualifiedName() == this.names.java_lang)) {
                    results.append(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, this.removeMethodBodies(cdef)));
                }
                return;
            }
            env.tree = this.transTypes.translateTopLevelClass(env.tree, localMake);
            if (this.errorCount() != 0) {
                return;
            }
            if (this.sourceOutput) {
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                if (untranslated instanceof JCTree.JCClassDecl && this.rootClasses.contains((JCTree.JCClassDecl)untranslated)) {
                    results.append(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, cdef));
                }
                return;
            }
            List<JCTree> cdefs = this.lower.translateTopLevelClass(env, env.tree, localMake);
            if (this.errorCount() != 0) {
                return;
            }
            List<JCTree> l = cdefs;
            while (l.nonEmpty()) {
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)l.head;
                results.append(new Pair<Env<AttrContext>, JCTree.JCClassDecl>(env, cdef));
                l = l.tail;
            }
        }
        finally {
            this.log.useSource(prev);
        }
    }

    public boolean desugarLater(final Env<AttrContext> env) {
        if (this.compilePolicy == CompilePolicy.BY_FILE) {
            return false;
        }
        if (!this.devVerbose && this.deferredSugar.contains(env)) {
            return false;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ScanNested
        extends TreeScanner {
            Set<Symbol> externalSupers = new HashSet<Symbol>();

            ScanNested() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl node) {
                Symbol.ClassSymbol c;
                Env<AttrContext> stEnv;
                Type st = JavaCompiler.this.types.supertype(node.sym.type);
                if (st.tag == 10 && (stEnv = JavaCompiler.this.enter.getEnv(c = st.tsym.outermostClass())) != null && env != stEnv) {
                    this.externalSupers.add(st.tsym);
                }
                super.visitClassDef(node);
            }
        }
        ScanNested scanner = new ScanNested();
        scanner.scan(env.tree);
        if (scanner.externalSupers.isEmpty()) {
            return false;
        }
        if (!this.deferredSugar.add(env) && this.devVerbose) {
            throw new AssertionError((Object)(env.enclClass.sym + " was deferred, " + "second time has these external super types " + scanner.externalSupers));
        }
        return true;
    }

    public void generate(List<Pair<Env<AttrContext>, JCTree.JCClassDecl>> list) {
        this.generate(list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(List<Pair<Env<AttrContext>, JCTree.JCClassDecl>> list, ListBuffer<JavaFileObject> results) {
        boolean usePrintSource = this.stubOutput || this.sourceOutput || this.printFlat;
        List<Pair<Env<AttrContext>, JCTree.JCClassDecl>> l = list;
        while (l.nonEmpty()) {
            Pair x = (Pair)l.head;
            Env env = (Env)x.fst;
            JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)x.snd;
            if (this.verboseCompilePolicy) {
                Log.printLines(this.log.noticeWriter, "[generate " + (usePrintSource ? " source" : "code") + " " + env.enclClass.sym + "]");
            }
            if (this.taskListener != null) {
                TaskEvent e = new TaskEvent(TaskEvent.Kind.GENERATE, env.toplevel, cdef.sym);
                this.taskListener.started(e);
            }
            JavaFileObject prev = this.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                JavaFileObject file = usePrintSource ? this.printSource(env, cdef) : this.genCode(env, cdef);
                if (results != null && file != null) {
                    results.append(file);
                }
            }
            catch (IOException ex) {
                this.log.error(cdef.pos(), "class.cant.write", cdef.sym, ex.getMessage());
                return;
            }
            finally {
                this.log.useSource(prev);
            }
            if (this.taskListener != null) {
                TaskEvent e = new TaskEvent(TaskEvent.Kind.GENERATE, env.toplevel, cdef.sym);
                this.taskListener.finished(e);
            }
            l = l.tail;
        }
    }

    Map<JCTree.JCCompilationUnit, List<Env<AttrContext>>> groupByFile(List<Env<AttrContext>> list) {
        LinkedHashMap<JCTree.JCCompilationUnit, List<Env<AttrContext>>> map = new LinkedHashMap<JCTree.JCCompilationUnit, List<Env<AttrContext>>>();
        HashSet<JCTree.JCCompilationUnit> fixupSet = new HashSet<JCTree.JCCompilationUnit>();
        List<Env<AttrContext>> l = list;
        while (l.nonEmpty()) {
            Env env = (Env)l.head;
            List<Env> sublist = (List<Env>)map.get(env.toplevel);
            if (sublist == null) {
                sublist = List.of(env);
            } else {
                sublist = sublist.prepend(env);
                fixupSet.add(env.toplevel);
            }
            map.put(env.toplevel, sublist);
            l = l.tail;
        }
        for (JCTree.JCCompilationUnit tree : fixupSet) {
            map.put(tree, ((List)map.get(tree)).reverse());
        }
        return map;
    }

    JCTree.JCClassDecl removeMethodBodies(JCTree.JCClassDecl cdef) {
        final boolean isInterface = (cdef.mods.flags & 0x200L) != 0L;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                tree.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (JCTree.JCVariableDecl vd : tree.params) {
                    vd.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                tree.body = null;
                super.visitMethodDef(tree);
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                if (tree.init != null && tree.init.type.constValue() == null) {
                    tree.init = null;
                }
                super.visitVarDef(tree);
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                ListBuffer newdefs = ListBuffer.lb();
                List<JCTree> it = tree.defs;
                while (it.tail != null) {
                    JCTree t = (JCTree)it.head;
                    switch (t.getTag()) {
                        case 3: {
                            if (!isInterface && (((JCTree.JCClassDecl)t).mods.flags & 5L) == 0L && ((((JCTree.JCClassDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCClassDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case 4: {
                            if (!isInterface && (((JCTree.JCMethodDecl)t).mods.flags & 5L) == 0L && ((JCTree.JCMethodDecl)t).sym.name != JavaCompiler.this.names.init && ((((JCTree.JCMethodDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCMethodDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case 5: {
                            if (!isInterface && (((JCTree.JCVariableDecl)t).mods.flags & 5L) == 0L && ((((JCTree.JCVariableDecl)t).mods.flags & 2L) != 0L || ((JCTree.JCVariableDecl)t).sym.packge().getQualifiedName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                    }
                    it = it.tail;
                }
                tree.defs = newdefs.toList();
                super.visitClassDef(tree);
            }
        }
        MethodBodyRemover r = new MethodBodyRemover();
        return r.translate(cdef);
    }

    public void reportDeferredDiagnostics() {
        if (this.annotationProcessingOccurred && this.implicitSourceFilesRead && this.implicitSourcePolicy == ImplicitSourcePolicy.UNSET) {
            if (this.explicitAnnotationProcessingRequested()) {
                this.log.warning("proc.use.implicit", new Object[0]);
            } else {
                this.log.warning("proc.use.proc.or.implicit", new Object[0]);
            }
        }
        this.chk.reportDeferredDiagnostics();
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean disposeNames) {
        this.rootClasses = null;
        this.reader = null;
        this.make = null;
        this.writer = null;
        this.enter = null;
        if (this.todo != null) {
            this.todo.clear();
        }
        this.todo = null;
        this.parserFactory = null;
        this.syms = null;
        this.source = null;
        this.attr = null;
        this.chk = null;
        this.gen = null;
        this.flow = null;
        this.transTypes = null;
        this.lower = null;
        this.annotate = null;
        this.types = null;
        this.log.flush();
        try {
            this.fileManager.flush();
        }
        catch (IOException e) {
            throw new Abort(e);
        }
        finally {
            if (this.names != null && disposeNames) {
                this.names.dispose();
            }
            this.names = null;
        }
    }

    protected void printVerbose(String key, Object arg) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + key, arg));
    }

    protected void printCount(String kind, int count) {
        if (count != 0) {
            String text = count == 1 ? Log.getLocalizedString("count." + kind, String.valueOf(count)) : Log.getLocalizedString("count." + kind + ".plural", String.valueOf(count));
            Log.printLines(this.log.errWriter, text);
            this.log.errWriter.flush();
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static long elapsed(long then) {
        return JavaCompiler.now() - then;
    }

    public void initRound(JavaCompiler prev) {
        this.keepComments = prev.keepComments;
        this.start_msec = prev.start_msec;
        this.hasBeenUsed = true;
    }

    public static void enableLogging() {
        Logger logger = Logger.getLogger(Main.class.getPackage().getName());
        logger.setLevel(Level.ALL);
        for (Handler h : logger.getParent().getHandlers()) {
            h.setLevel(Level.ALL);
        }
    }

    static {
        DEFAULT_COMPILE_POLICY = CompilePolicy.BY_TODO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImplicitSourcePolicy {
        NONE,
        CLASS,
        UNSET;


        static ImplicitSourcePolicy decode(String option) {
            if (option == null) {
                return UNSET;
            }
            if (option.equals("none")) {
                return NONE;
            }
            if (option.equals("class")) {
                return CLASS;
            }
            return UNSET;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompilePolicy {
        ATTR_ONLY,
        CHECK_ONLY,
        SIMPLE,
        BY_FILE,
        BY_TODO;


        static CompilePolicy decode(String option) {
            if (option == null) {
                return DEFAULT_COMPILE_POLICY;
            }
            if (option.equals("attr")) {
                return ATTR_ONLY;
            }
            if (option.equals("check")) {
                return CHECK_ONLY;
            }
            if (option.equals("simple")) {
                return SIMPLE;
            }
            if (option.equals("byfile")) {
                return BY_FILE;
            }
            if (option.equals("bytodo")) {
                return BY_TODO;
            }
            return DEFAULT_COMPILE_POLICY;
        }
    }
}

