/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.webservice.generator;

import com.ibm.wsdl.factory.WSDLFactoryImpl;
import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.configuration.InterfaceExtractorUtil;
import it.imolinfo.jbi4ejb.exception.ClassGenerationException;
import it.imolinfo.jbi4ejb.exception.EJBWSDLGenerationException;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbAddress;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbBinding;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbExtension;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbTypes;
import it.imolinfo.jbi4ejb.webservice.generator.EJBUtils;
import it.imolinfo.jbi4ejb.webservice.generator.JarUtil;
import it.imolinfo.jbi4ejb.webservice.generator.Util;
import it.imolinfo.jbi4ejb.webservice.generator.WSDLDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.Configuration;
import org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.util.ServiceUtils;

public final class WSDLGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(EJBUtils.class);

    private WSDLGenerator() {
    }

    public static File createWsdlFromJar(String className, String ejbJarPath, String wsdlFileName, WSDLDescriptor descriptor, File tempDir) throws EJBWSDLGenerationException {
        try {
            JarUtil.unjar(new File(ejbJarPath), tempDir);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        return WSDLGenerator.createWsdlFromClassesDirectory(className, tempDir, wsdlFileName, descriptor);
    }

    public static File createWsdlFromEar(String className, String earJarPath, String wsdlFileName, WSDLDescriptor descriptor) throws EJBWSDLGenerationException {
        String tempDirPath = InterfaceExtractorUtil.extractEarClassesInTempDirectory(earJarPath);
        return WSDLGenerator.createWsdlFromClassesDirectory(className, new File(tempDirPath), wsdlFileName, descriptor);
    }

    public static File createWsdlFromClassesDirectory(String className, File classesDirectory, String wsdlFileName, WSDLDescriptor descriptor, File tempDir) throws EJBWSDLGenerationException {
        try {
            EJBUtils.copyDirectory(classesDirectory, tempDir);
            return WSDLGenerator.createWsdlFromClassesDirectory(className, tempDir, wsdlFileName, descriptor);
        }
        catch (IOException ioex) {
            LOG.error(ioex.getMessage());
            throw new EJBWSDLGenerationException(ioex);
        }
    }

    private static File createWsdlFromClassesDirectory(String className, File classesDirectory, String wsdlFileName, WSDLDescriptor descriptor) throws EJBWSDLGenerationException {
        try {
            Properties classesIDs = WSDLGenerator.getClassesID(className, classesDirectory);
            EJBUtils.removeEJBRemoteInterface(className, classesDirectory.getAbsolutePath());
            URLClassLoader classLoader = null;
            try {
                classLoader = Util.getURLClassLoader(classesDirectory.getAbsolutePath(), null);
            }
            catch (MalformedURLException ex) {
                String msg = ex.getMessage();
                LOG.error(msg);
                throw new ClassGenerationException(msg);
            }
            LOG.debug("Class name: " + className);
            Class<?> remoteInterfaceClass = classLoader.loadClass(className);
            return WSDLGenerator.createWsdlFromClass(remoteInterfaceClass, wsdlFileName, descriptor, classesIDs);
        }
        catch (ClassNotFoundException cex) {
            LOG.error(cex.getMessage());
            throw new EJBWSDLGenerationException(cex);
        }
        catch (ClassGenerationException cex) {
            LOG.error(cex.getMessage());
            throw new EJBWSDLGenerationException(cex);
        }
    }

    private static File createWsdlFromClass(Class remoteInterfaceClass, String wsdlFileName, WSDLDescriptor descriptor, Properties classesId) throws EJBWSDLGenerationException {
        try {
            ObjectServiceFactory factory = new ObjectServiceFactory();
            HashMap<String, Object> props = new HashMap<String, Object>();
            QName interfaceName = ServiceUtils.makeQualifiedNameFromClass((Class)remoteInterfaceClass);
            props.put("objectServiceFactory.portType", interfaceName);
            props.put("wsdlBuilder.generateImports", "true");
            props.put("objectServiceFactory.style", "wrapped");
            props.put("objectServiceFactory.use", "literal");
            factory.getSoap11Transports().clear();
            factory.getSoap12Transports().clear();
            AegisBindingProvider binder = (AegisBindingProvider)factory.getBindingProvider();
            DefaultTypeMappingRegistry tmr = (DefaultTypeMappingRegistry)binder.getTypeMappingRegistry();
            Configuration configuration = tmr.getConfiguration();
            configuration.setDefaultMinOccurs(1);
            configuration.setDefaultNillable(true);
            Service service = factory.create(remoteInterfaceClass, interfaceName.getLocalPart(), interfaceName.getNamespaceURI(), props);
            File wsdlFile = new File(wsdlFileName);
            wsdlFile.createNewFile();
            FileOutputStream f = new FileOutputStream(wsdlFile);
            service.getWSDLWriter().write((OutputStream)f);
            WSDLGenerator.addJbi4EjbExtensionsToWSDL(wsdlFile, descriptor, classesId, service);
            return wsdlFile;
        }
        catch (MalformedURLException mex) {
            LOG.error(mex.getMessage());
            throw new EJBWSDLGenerationException(mex);
        }
        catch (IOException ioex) {
            LOG.error(ioex.getMessage());
            throw new EJBWSDLGenerationException(ioex);
        }
        catch (WSDLException ex) {
            LOG.error(ex.getMessage());
            throw new EJBWSDLGenerationException(ex);
        }
    }

    private static void addJbi4EjbExtensionsToWSDL(File wsdlFile, WSDLDescriptor wsdlDescriptor, Properties classesId, Service xfireService) throws EJBWSDLGenerationException, WSDLException {
        Jbi4EjbAddress ejbAddress = new Jbi4EjbAddress();
        ejbAddress.setName(wsdlDescriptor.getName());
        ejbAddress.setLocalizationType(wsdlDescriptor.getLocalizationType());
        ejbAddress.setElementType(Jbi4EjbExtension.Q_ELEM_JBI4EJB_ADDRESS);
        Jbi4EjbBinding ejbBinding = new Jbi4EjbBinding();
        if (wsdlDescriptor.isCorbaName()) {
            ejbBinding.setOrbProperties(wsdlDescriptor.getOrbProperties());
        } else {
            ejbBinding.setJndiProperties(wsdlDescriptor.getJndiProperties());
        }
        ejbBinding.setElementType(Jbi4EjbExtension.Q_ELEM_JBI4EJB_BINDING);
        Jbi4EjbTypes ejbTypes = new Jbi4EjbTypes();
        ejbTypes.setTypesSerialVersionUIDs(classesId);
        ejbTypes.setElementType(Jbi4EjbExtension.Q_ELEM_JBI4EJB_TYPES);
        Definition wsdl = WSDLGenerator.readWsdl(wsdlFile);
        wsdl.addNamespace("imolaejb", "uri://schemas.imola.it/jbi/wsdl-extensions/ejb/");
        javax.wsdl.Service service = wsdl.getService(xfireService.getName());
        String portName = service.getQName().getLocalPart() + "Port";
        Port port = wsdl.createPort();
        port.setName(portName);
        service.addPort(port);
        String bindingName = service.getQName().getLocalPart() + "Binding";
        Binding binding = wsdl.createBinding();
        wsdl.addBinding(binding);
        QName bindingQName = new QName(service.getQName().getNamespaceURI(), bindingName);
        binding.setQName(bindingQName);
        port.setBinding(binding);
        QName portTypeQName = xfireService.getServiceInfo().getPortType();
        PortType portType = wsdl.getPortType(portTypeQName);
        if (portType == null) {
            String msg = "No PortType found wth name: " + portTypeQName;
            LOG.error(msg);
            throw new EJBWSDLGenerationException(msg);
        }
        binding.setPortType(portType);
        List operations = portType.getOperations();
        for (Operation operation : operations) {
            Output output;
            BindingOperation bop = wsdl.createBindingOperation();
            bop.setName(operation.getName());
            Input input = operation.getInput();
            if (input != null) {
                BindingInput bindingInput = wsdl.createBindingInput();
                bindingInput.setName(input.getName());
                bop.setBindingInput(bindingInput);
            }
            if ((output = operation.getOutput()) != null) {
                BindingOutput bindingOutput = wsdl.createBindingOutput();
                bindingOutput.setName(output.getName());
                bop.setBindingOutput(bindingOutput);
            }
            Map faults = operation.getFaults();
            Iterator faultIt = faults.entrySet().iterator();
            while (faultIt.hasNext()) {
                Fault fault = (Fault)faultIt.next().getValue();
                BindingFault bindingFault = wsdl.createBindingFault();
                bindingFault.setName(fault.getName());
                bop.addBindingFault(bindingFault);
            }
            binding.addBindingOperation(bop);
        }
        binding.setUndefined(false);
        port.addExtensibilityElement((ExtensibilityElement)ejbAddress);
        binding.addExtensibilityElement((ExtensibilityElement)ejbBinding);
        wsdl.addExtensibilityElement((ExtensibilityElement)ejbTypes);
        wsdlFile.delete();
        try {
            WSDLGenerator.writeWsdl(wsdl, wsdlFile);
        }
        catch (IOException e) {
            String msg = "Error in writing definition on file system";
            LOG.error(msg);
            throw new EJBWSDLGenerationException(msg);
        }
    }

    private static Definition readWsdl(File f) throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
        WSDLReader reader = ((WSDLFactoryImpl)wsdlFactory).newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Jbi4EjbExtension.register(registry);
        LOG.debug("Extension QName: uri://schemas.imola.it/jbi/wsdl-extensions/ejb/");
        reader.setExtensionRegistry(registry);
        Definition def = reader.readWSDL(f.getAbsolutePath());
        return def;
    }

    private static void writeWsdl(Definition wsdl, File wsdlFile) throws WSDLException, IOException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
        Jbi4EjbExtension.register(registry);
        wsdl.setExtensionRegistry(registry);
        WSDLWriter writer = wsdlFactory.newWSDLWriter();
        writer.writeWSDL(wsdl, (Writer)new FileWriter(wsdlFile));
    }

    public static Properties getClassesID(String remoteInterface, File classesDir) throws EJBWSDLGenerationException {
        Set<Class> classesToSerialize;
        LOG.debug("looking for " + remoteInterface + " in directory: " + classesDir.getAbsolutePath());
        Properties classesID = new Properties();
        String remoteInterfaceFileName = remoteInterface.replace('.', File.separatorChar);
        LOG.debug("remoteInterfaceFileName: " + remoteInterfaceFileName);
        ArrayList<File> list = new ArrayList<File>();
        list.add(new File(classesDir.getAbsolutePath() + File.separatorChar + remoteInterfaceFileName));
        try {
            classesToSerialize = Util.findClassUsed(classesDir.getAbsolutePath(), list);
        }
        catch (ClassGenerationException e) {
            LOG.error(e.getMessage());
            throw new EJBWSDLGenerationException(e);
        }
        for (Class classToSerialize : classesToSerialize) {
            LOG.debug("Looking for class: " + classToSerialize.getName());
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(classToSerialize);
            if (objectStreamClass == null) {
                LOG.warn("The objectStreamClass is null for class: " + classToSerialize.getName() + " the class is Serializable?");
            }
            if (objectStreamClass == null) continue;
            long uid = objectStreamClass.getSerialVersionUID();
            LOG.debug(classToSerialize.getName() + " uid: " + uid);
            classesID.put(classToSerialize.getName(), (Object)uid);
        }
        return classesID;
    }
}

