/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.runtime;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4ejb.exception.EJBInvokeException;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.StatelessEJBProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.invoker.Invoker;

public class ProviderServiceInvoker
implements Invoker {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderServiceInvoker.class);
    private ProviderServiceDescriptor serviceDescriptor;

    public ProviderServiceInvoker(ProviderServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public Object invoke(Method method, Object[] args, MessageContext messageContext) throws XFireFault {
        LOG.debug(">>>>> invoke - begin");
        StatelessEJBProxy ejbProxy = this.serviceDescriptor.getEjbProxy();
        Object result = null;
        try {
            result = ejbProxy.invokeMethod(method, args);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Result: " + ReflectionToStringBuilder.toString((Object)result));
            }
        }
        catch (IllegalAccessException e) {
            String msg = "Error in invoking the method: " + method + " on the remote object: " + ejbProxy.getRemoteInterfaceClassName();
            LOG.error(e.getMessage());
            throw new XFireFault(msg, e.getCause(), XFireFault.SOAP11_SERVER);
        }
        catch (InvocationTargetException e) {
            String msg = "Error in invoking the method: " + method + " on the remote object: " + ejbProxy.getRemoteInterfaceClassName();
            LOG.error(e.getMessage());
            throw new XFireFault(msg, e.getCause(), XFireFault.SOAP11_SERVER);
        }
        catch (EJBInvokeException ex) {
            String msg = "Error in invoking the method: " + method + " on the remote object: " + ejbProxy.getRemoteInterfaceClassName();
            LOG.error(ex.getMessage());
            throw new XFireFault(msg, ex.getCause(), XFireFault.SOAP11_SERVER);
        }
        finally {
            LOG.debug(">>>>> invoke - end");
        }
        return result;
    }
}

