/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.wsdl;

import com.ibm.wsdl.util.xml.DOMUtils;
import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbBinding;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;

public class Jbi4EjbBindingSerializer
implements ExtensionSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4EjbBindingSerializer.class);

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String prefix = DOMUtils.getPrefix((String)"uri://schemas.imola.it/jbi/wsdl-extensions/ejb/", (Definition)def);
        if (prefix == null) {
            prefix = "imolaejb";
            def.addNamespace("imolaejb", "uri://schemas.imola.it/jbi/wsdl-extensions/ejb/");
        }
        prefix = prefix + ":";
        LOG.debug("prefix found: " + prefix);
        if (extension instanceof Jbi4EjbBinding) {
            Jbi4EjbBinding jbi4EjbBinding = (Jbi4EjbBinding)extension;
            pw.print("<" + prefix + "binding");
            pw.print(">\n");
            this.printJNDIElement(jbi4EjbBinding, pw, prefix);
            this.printORBElement(jbi4EjbBinding, pw, prefix);
            pw.print("</" + prefix + "binding" + ">\n");
        } else {
            String msg = "The extension element is not a binding";
            LOG.warn(msg);
        }
    }

    private void printJNDIElement(Jbi4EjbBinding jbi4EjbBinding, PrintWriter pw, String prefix) {
        if (jbi4EjbBinding.getJndiProperties() != null && !jbi4EjbBinding.getJndiProperties().isEmpty()) {
            pw.print("<" + prefix + "jndi" + ">\n");
            Properties jndiProperties = jbi4EjbBinding.getJndiProperties();
            Enumeration<Object> enKeys = jndiProperties.keys();
            while (enKeys.hasMoreElements()) {
                String key = (String)enKeys.nextElement();
                String prop = (String)jndiProperties.get(key);
                pw.print("<" + prefix + "property");
                DOMUtils.printAttribute((String)"name", (String)key, (PrintWriter)pw);
                DOMUtils.printAttribute((String)"value", (String)prop, (PrintWriter)pw);
                pw.print("/>\n");
            }
            pw.print("</" + prefix + "jndi" + ">\n");
        }
    }

    private void printORBElement(Jbi4EjbBinding jbi4EjbBinding, PrintWriter pw, String prefix) {
        if (jbi4EjbBinding.getOrbProperties() != null) {
            pw.print("<" + prefix + "orb" + ">\n");
            Properties orbProperties = jbi4EjbBinding.getOrbProperties();
            Enumeration<Object> enKeys = orbProperties.keys();
            while (enKeys.hasMoreElements()) {
                String key = (String)enKeys.nextElement();
                String prop = (String)orbProperties.get(key);
                pw.print("<" + prefix + "property");
                DOMUtils.printAttribute((String)"name", (String)key, (PrintWriter)pw);
                DOMUtils.printAttribute((String)"value", (String)prop, (PrintWriter)pw);
                pw.print("/>\n");
            }
            pw.print("</" + prefix + "orb" + ">\n");
        }
    }
}

