/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.svg;

import com.nwoods.jgo.DomCDATASection;
import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.DomText;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoEllipse;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoXMLSaveRestore;
import com.nwoods.jgo.svg.DefaultCDATASection;
import com.nwoods.jgo.svg.DefaultElement;
import com.nwoods.jgo.svg.DefaultText;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DefaultDocument
implements DomDoc {
    private Document myDoc;
    private JGoLayer myCurrentLayer;
    private double myJGoSVGVersion;
    private boolean myDisabledDrawing;
    private boolean myGenerateJGoXML = true;
    private boolean myGenerateSVG = true;
    private boolean myReadSVG = false;
    private boolean mySVGTooltips = true;
    private HashMap myJGoObjectToSVGNodeMap;
    private Vector myReferencingNode;
    private Vector myReferenceName;
    private Vector myReferencedObj;
    private HashMap myTagToJGoObjectMap;
    private Vector myReferencingObject;
    private Vector myReferencingAttr;
    private Vector myReferencedTag;

    public DefaultDocument() {
        this.resetDocument();
    }

    public void resetDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.myDoc = builder.newDocument();
            this.myJGoObjectToSVGNodeMap = new HashMap();
            this.myReferencingNode = new Vector();
            this.myReferenceName = new Vector();
            this.myReferencedObj = new Vector();
            this.myReferencedTag = new Vector();
            this.myReferencingAttr = new Vector();
            this.myReferencingObject = new Vector();
            this.myTagToJGoObjectMap = new HashMap();
            this.myJGoSVGVersion = 3.0;
            this.myDisabledDrawing = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DomElement createElement(String s) {
        return new DefaultElement(this.myDoc.createElement(s));
    }

    public DomText createText(String s) {
        return new DefaultText(this.myDoc.createTextNode(s));
    }

    public DomCDATASection createCDATASection(String s) {
        return new DefaultCDATASection(this.myDoc.createCDATASection(s));
    }

    private DomElement appendChild(DomElement newChild) {
        DefaultElement child = (DefaultElement)newChild;
        Node node = this.myDoc.appendChild(child.getElement());
        Element element = (Element)node;
        DefaultElement newElement = new DefaultElement(element);
        return newElement;
    }

    private void writeFile(Writer outw) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer serializer = transformerFactory.newTransformer();
            serializer.setOutputProperty("method", "xml");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("omit-xml-declaration", "no");
            serializer.transform(new DOMSource(this.myDoc), new StreamResult(outw));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void readFile(Reader inr) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.myDoc = builder.parse(new InputSource(inr));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public DomElement getDocumentElement() {
        Element element = this.myDoc.getDocumentElement();
        return new DefaultElement(element);
    }

    public void registerObject(Object obj, DomElement node) {
        this.myJGoObjectToSVGNodeMap.put(obj, node);
    }

    private DomElement getNode(Object obj) {
        return (DomElement)this.myJGoObjectToSVGNodeMap.get(obj);
    }

    public void registerReferencingNode(DomElement referencingNode, String refName, Object referencedObj) {
        this.myReferencingNode.addElement(referencingNode);
        this.myReferenceName.addElement(refName);
        this.myReferencedObj.addElement(referencedObj);
    }

    public boolean isRegisteredReference(Object obj) {
        for (int i = 0; i < this.myReferencedObj.size(); ++i) {
            Object refObj = this.myReferencedObj.elementAt(i);
            if (refObj != obj) continue;
            return true;
        }
        return false;
    }

    private DomElement getReferencingNode(int idx) {
        if (idx >= this.myReferencingNode.size()) {
            return null;
        }
        return (DomElement)this.myReferencingNode.get(idx);
    }

    private String getReferenceName(int idx) {
        return (String)this.myReferenceName.get(idx);
    }

    private Object getReferencedObject(int idx) {
        return this.myReferencedObj.get(idx);
    }

    public void registerTag(String tag, Object obj) {
        this.myTagToJGoObjectMap.put(tag, obj);
    }

    private Object getRegisteredTagObj(String tag) {
        return this.myTagToJGoObjectMap.get(tag);
    }

    public void registerReferencingObject(Object obj, String attr, String refTag) {
        if (refTag.length() <= 0) {
            return;
        }
        this.myReferencingObject.addElement(obj);
        this.myReferencingAttr.addElement(attr);
        this.myReferencedTag.addElement(refTag);
    }

    private Object getReferencingObject(int idx) {
        if (idx >= this.myReferencingObject.size()) {
            return null;
        }
        return this.myReferencingObject.get(idx);
    }

    private String getReferencingAttr(int idx) {
        return (String)this.myReferencingAttr.get(idx);
    }

    private String getReferencedTag(int idx) {
        return (String)this.myReferencedTag.get(idx);
    }

    public void SVGWriteDoc(OutputStream outs, JGoDocument jGoDoc) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outs));
        this.SVGWriteDoc(writer, jGoDoc);
    }

    public void SVGWriteDoc(Writer outw, JGoDocument jGoDoc) {
        this.resetDocument();
        this.buildSVGDoc(jGoDoc);
        this.writeFile(outw);
    }

    public void SVGReadDoc(InputStream ins, JGoDocument jGoDoc) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
        this.SVGReadDoc(reader, jGoDoc);
    }

    public void SVGReadDoc(Reader inr, JGoDocument jGoDoc) throws Exception {
        jGoDoc.deleteContents();
        this.readFile(inr);
        this.buildJGoDoc(jGoDoc);
        jGoDoc.removeLayer(jGoDoc.getFirstLayer());
    }

    public void buildSVGDoc(JGoDocument jGoDoc) {
        DomElement referencingNode;
        DomElement element = null;
        if (this.isGenerateSVG()) {
            element = this.createElement("svg");
            element.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        } else {
            element = this.createElement("xml");
        }
        if (this.isGenerateJGoXML()) {
            element.setAttribute("xmlns:jgoxml", "http://www.nwoods.com/jgoxml");
            element.setAttribute("jgosvgversion", Double.toString(this.myJGoSVGVersion));
        }
        element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.appendChild(element);
        if (this.isGenerateJGoXML()) {
            DomElement docSubGroup = this.createElement("g");
            element.appendChild(docSubGroup);
            jGoDoc.SVGWriteObject(this, docSubGroup);
        }
        DomElement subGroup = element;
        JGoLayer layer = jGoDoc.getFirstLayer();
        while (layer != null) {
            if (this.isGenerateJGoXML()) {
                subGroup = this.createElement("g");
                element.appendChild(subGroup);
            }
            jGoDoc.SVGWriteLayer(this, subGroup, layer);
            layer = jGoDoc.getNextLayer(layer);
        }
        int nextRefId = 1;
        int i = 0;
        while ((referencingNode = this.getReferencingNode(i)) != null) {
            String sExistingRef;
            String sRefName = this.getReferenceName(i);
            Object jGoObj = this.getReferencedObject(i);
            DomElement referencedNode = this.getNode(jGoObj);
            String sRefId = "null";
            if (referencedNode != null && (sRefId = referencedNode.getAttribute("id")).length() == 0) {
                sRefId = "jgoid" + Integer.toString(nextRefId++);
                referencedNode.setAttribute("id", sRefId);
            }
            if ((sExistingRef = referencingNode.getAttribute(sRefName)).length() == 0) {
                referencingNode.setAttribute(sRefName, sRefId);
            } else {
                referencingNode.setAttribute(sRefName, sExistingRef + " " + sRefId);
            }
            ++i;
        }
        this.GenerateTooltipInitialization(element);
        this.GenerateTooltipScript(element);
        this.RenderTooltip(element);
    }

    public void buildJGoDoc(JGoDocument jGoDoc) {
        Object referencingObject;
        DomElement topElement = this.getDocumentElement();
        String sversion = topElement.getAttribute("jgosvgversion");
        if (sversion.length() > 0) {
            this.myJGoSVGVersion = Double.parseDouble(topElement.getAttribute("jgosvgversion"));
            if (this.myJGoSVGVersion > 3.0) {
                System.out.println("Warning: attempting to read unknown future version JGo SVG.");
                System.out.println("This application supports version 3.0 and earlier.");
            }
        }
        this.SVGTraverseChildren(jGoDoc, topElement, null, true);
        boolean nextRefId = true;
        int i = 0;
        while ((referencingObject = this.getReferencingObject(i)) != null) {
            String referencingAttr = this.getReferencingAttr(i);
            String referencedTag = this.getReferencedTag(i);
            this.SVGUpdateReferences(referencingAttr, referencedTag, referencingObject);
            ++i;
        }
    }

    private void SVGUpdateReferences(String referencingAttr, String referencedTag, Object referencingObject) {
        if (referencingObject instanceof JGoObject) {
            JGoObject jGoObj = (JGoObject)referencingObject;
            jGoObj.SVGUpdateReference(referencingAttr, this.getRegisteredTagObj(referencedTag));
        }
    }

    public void SVGTraverseChildren(JGoDocument jGoDoc, DomNode svgNode, JGoArea parent, boolean addToDoc) {
        DomNode node = svgNode.getFirstChild();
        while (node != null) {
            try {
                node = this.SVGVisitNode(jGoDoc, node, parent, addToDoc);
            }
            catch (Exception e) {
                e.printStackTrace();
                node = svgNode.getNextSibling();
            }
        }
    }

    private DomNode SVGVisitNode(JGoDocument jGoDoc, DomNode svgNode, JGoArea parent, boolean addToDoc) {
        if (svgNode.isElement()) {
            DomElement element = svgNode.elementCast();
            DomElement jGoChildElement = null;
            String sTag = element.getLocalName();
            String sFirstChildTag = "";
            if (sTag.equalsIgnoreCase("g")) {
                DomNode node = svgNode.getFirstChild();
                if ((node = node.getNextSibling()) != null && node.isElement()) {
                    jGoChildElement = node.elementCast();
                    sFirstChildTag = jGoChildElement.getLocalName();
                }
            }
            return this.SVGReadElement(jGoDoc, sTag, element, sFirstChildTag, jGoChildElement, parent, addToDoc);
        }
        return svgNode.getNextSibling();
    }

    public DomNode SVGReadElement(JGoDocument jGoDoc, String sTag, DomElement element, String sFirstChildTag, DomElement jGoChildElement, JGoArea parent, boolean addToDoc) {
        JGoObject jGoObj = null;
        DomNode nextNode = null;
        if (sFirstChildTag.equals("JGoClass")) {
            Object obj = null;
            String className = jGoChildElement.getAttribute("class");
            try {
                if (this.getJGoSVGVersion() < 2.0) {
                    if (className.equals("com.nwoods.jgo.examples.TextNode")) {
                        className = "com.nwoods.jgo.JGoTextNode";
                    }
                    if (className.equals("com.nwoods.jgo.examples.BasicNode")) {
                        className = "com.nwoods.jgo.JGoBasicNode";
                    }
                    if (className.equals("com.nwoods.jgo.examples.IconicNode")) {
                        className = "com.nwoods.jgo.JGoIconicNode";
                    }
                    if (className.equals("com.nwoods.jgo.examples.IconicNodePort")) {
                        return this.SVGReadElement(jGoDoc, sTag, element, jGoChildElement.getNextSiblingElement().getLocalName(), jGoChildElement.getNextSiblingElement(), parent, addToDoc);
                    }
                    if (className.equals("com.nwoods.jgo.examples.BasicNodePort")) {
                        return this.SVGReadElement(jGoDoc, sTag, element, jGoChildElement.getNextSiblingElement().getLocalName(), jGoChildElement.getNextSiblingElement(), parent, addToDoc);
                    }
                    if (className.equals("com.nwoods.jgo.examples.SubGraph")) {
                        className = "com.nwoods.jgo.JGoSubGraph";
                    }
                }
                Class<?> elementClass = Class.forName(className);
                obj = elementClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (obj != null) {
                if (obj instanceof JGoObject) {
                    jGoObj = obj;
                    nextNode = jGoObj.SVGReadObject(this, jGoDoc, element, jGoChildElement);
                } else {
                    DomNode nextElement = this.initializeObjectFromXML(jGoDoc, element, jGoChildElement, obj);
                    if (nextElement != null) {
                        return nextElement;
                    }
                }
            }
        } else {
            if (sTag.equalsIgnoreCase("g")) {
                this.SVGTraverseChildren(jGoDoc, element, null, true);
            }
            if (this.isReadSVG()) {
                if (sTag.equalsIgnoreCase("rect")) {
                    jGoObj = new JGoRectangle();
                    nextNode = jGoObj.SVGReadObject(this, jGoDoc, element, null);
                } else if (sTag.equalsIgnoreCase("ellipse")) {
                    jGoObj = new JGoEllipse();
                    nextNode = jGoObj.SVGReadObject(this, jGoDoc, element, null);
                } else if (sTag.equalsIgnoreCase("circle")) {
                    jGoObj = new JGoEllipse();
                    nextNode = jGoObj.SVGReadObject(this, jGoDoc, element, null);
                } else if (sTag.equalsIgnoreCase("text")) {
                    jGoObj = new JGoText();
                    nextNode = jGoObj.SVGReadObject(this, jGoDoc, element, null);
                } else if (sTag.equalsIgnoreCase("line")) {
                    jGoObj = new JGoStroke();
                    nextNode = jGoObj.SVGReadObject(this, jGoDoc, element, null);
                } else if (sTag.equalsIgnoreCase("image")) {
                    jGoObj = new JGoImage();
                    nextNode = jGoObj.SVGReadObject(this, jGoDoc, element, null);
                }
            }
        }
        if (jGoObj != null) {
            if (parent != null) {
                parent.addObjectAtTail(jGoObj);
            } else if (addToDoc) {
                if (this.myCurrentLayer != null) {
                    this.myCurrentLayer.addObjectAtTail(jGoObj);
                } else {
                    jGoDoc.addObjectAtTail(jGoObj);
                }
            }
            return nextNode;
        }
        return element.getNextSibling();
    }

    public DomNode initializeObjectFromXML(JGoDocument jGoDoc, DomElement element, DomElement jGoChildElement, Object obj) {
        if (obj instanceof JGoLayer) {
            this.myCurrentLayer = jGoDoc.addLayerAfter(null);
            jGoDoc.SVGReadLayer(this, jGoDoc, element, jGoChildElement, this.myCurrentLayer);
            return element.getNextSiblingElement();
        }
        if (obj instanceof JGoXMLSaveRestore) {
            JGoXMLSaveRestore x = (JGoXMLSaveRestore)obj;
            x.SVGReadObject(this, jGoDoc, element, jGoChildElement);
            return element.getNextSiblingElement();
        }
        return null;
    }

    public DomElement createJGoClassElement(String className, DomElement parent) {
        DomElement classElement = this.createElement("jgoxml:JGoClass");
        classElement.setAttribute("class", className);
        parent.appendChild(classElement);
        return classElement;
    }

    public void setDisabledDrawing(boolean disable) {
        this.myDisabledDrawing = disable;
    }

    public boolean isDisabledDrawing() {
        return this.myDisabledDrawing;
    }

    public double getJGoSVGVersion() {
        return this.myJGoSVGVersion;
    }

    public void setGenerateJGoXML(boolean enable) {
        this.myGenerateJGoXML = enable;
    }

    public boolean isGenerateJGoXML() {
        return this.myGenerateJGoXML;
    }

    public void setGenerateSVG(boolean enable) {
        this.myGenerateSVG = enable;
    }

    public boolean isGenerateSVG() {
        return this.myGenerateSVG;
    }

    public void setReadSVG(boolean enable) {
        this.myReadSVG = enable;
    }

    public boolean isReadSVG() {
        return this.myReadSVG;
    }

    public void setSVGTooltips(boolean enable) {
        this.mySVGTooltips = enable;
    }

    public boolean isSVGTooltips() {
        return this.mySVGTooltips;
    }

    public boolean SVGOutputEnabled() {
        return this.isGenerateSVG() && !this.isDisabledDrawing();
    }

    public boolean JGoXMLOutputEnabled() {
        return this.isGenerateJGoXML();
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.myDoc.importNode(importedNode, deep);
    }

    public Document getDocument() {
        return this.myDoc;
    }

    protected void GenerateTooltipInitialization(DomElement parent) {
        if (!this.isGenerateSVG() || !this.isSVGTooltips()) {
            return;
        }
        parent.setAttribute("contentScriptType", "text/ecmascript");
        parent.setAttribute("onload", "AddTitleEvents(GetSvgDoc(evt).getDocumentElement())");
    }

    protected void RenderTooltip(DomElement parent) {
        if (!this.isGenerateSVG() || !this.isSVGTooltips()) {
            return;
        }
        DomElement g = this.createElement("g");
        g.setAttribute("id", "GoSvgTooltip");
        g.setAttribute("display", "none");
        g.setAttribute("onmouseover", "ShowTooltip(evt)");
        g.setAttribute("onmouseout", "HideTooltip(evt)");
        parent.appendChild(g);
        DomElement rect = this.createElement("rect");
        rect.setAttribute("id", "GoSvgTooltipRect");
        rect.setAttribute("fill", "rgb(255,255,220)");
        rect.setAttribute("stroke", "rgb(0,0,0)");
        rect.setAttribute("height", "20");
        g.appendChild(rect);
        DomElement text = this.createElement("text");
        text.setAttribute("id", "GoSvgTooltipText");
        text.setAttribute("x", "5");
        text.setAttribute("y", "14");
        g.appendChild(text);
        DomText ttt = this.createText("ttt");
        text.appendChild(ttt);
    }

    protected void GenerateTooltipScript(DomElement parent) {
        if (!this.isGenerateSVG() || !this.isSVGTooltips()) {
            return;
        }
        String s = "";
        s = s + "\nvar goLastTitle = null;";
        s = s + "\nfunction ShowTooltip(e) {";
        s = s + "\n  var d = GetSvgDoc(e);";
        s = s + "\n  var tt = d.getElementById('GoSvgTooltip');";
        s = s + "\n  if (tt != null) {";
        s = s + "\n    var title = TitleElementOf(e.getCurrentTarget());";
        s = s + "\n    if (title != null) {";
        s = s + "\n      var ttText = d.getElementById('GoSvgTooltipText');";
        s = s + "\n      if (ttText != null && goLastTitle != title) {";
        s = s + "\n        goLastTitle = title;";
        s = s + "\n        var newtextnode = d.createTextNode(TextOf(title));";
        s = s + "\n        ttText.replaceChild(newtextnode, ttText.getFirstChild());";
        s = s + "\n        var ttRect = d.getElementById('GoSvgTooltipRect');";
        s = s + "\n        if (ttRect != null) {";
        s = s + "\n          ttRect.setAttribute('width', ttText.getComputedTextLength() + 2*ttText.getAttribute('x'));";
        s = s + "\n        }";
        s = s + "\n        var newy = e.getClientY()-20;";
        s = s + "\n        tt.setAttribute('transform', 'translate(' + e.getClientX() + ',' + newy + ')');";
        s = s + "\n      }";
        s = s + "\n    }";
        s = s + "\n    tt.setAttribute('display', 'inherit')";
        s = s + "\n  }";
        s = s + "\n}";
        s = s + "\nfunction HideTooltip(e) {";
        s = s + "\n  var d = GetSvgDoc(e);";
        s = s + "\n  var tt = d.getElementById('GoSvgTooltip');";
        s = s + "\n  if (tt != null) {";
        s = s + "\n    tt.setAttribute('display', 'none')";
        s = s + "\n  }";
        s = s + "\n}";
        s = s + "\nfunction GetSvgDoc(e) {";
        s = s + "\n  var t = e.getTarget();";
        s = s + "\n  if (t.getNodeType() != 9)";
        s = s + "\n    return t.getOwnerDocument();";
        s = s + "\n  else";
        s = s + "\n    return t;";
        s = s + "\n}";
        s = s + "\nfunction AddTitleEvents(elt) {";
        s = s + "\n  var c = elt.getChildNodes();";
        s = s + "\n  for (var i = 0; i < c.getLength(); i++) {";
        s = s + "\n    if (c.item(i).getNodeType() == 1)";
        s = s + "\n      AddTitleEvents(c.item(i));";
        s = s + "\n  }";
        s = s + "\n  if (TitleElementOf(elt) != null) {";
        s = s + "\n    elt.addEventListener('mouseover', ShowTooltip, false);";
        s = s + "\n    elt.addEventListener('mouseout', HideTooltip, false);";
        s = s + "\n  }";
        s = s + "\n}";
        s = s + "\nfunction TitleElementOf(elt) {";
        s = s + "\n  var c = elt.getChildNodes();";
        s = s + "\n  for (var i = 0; i < c.getLength(); i++)";
        s = s + "\n    if (c.item(i).getNodeType() == 1 && c.item(i).getNodeName() == 'title')";
        s = s + "\n      return c.item(i);";
        s = s + "\n  return null;";
        s = s + "\n}";
        s = s + "\nfunction TextOf(elt) {";
        s = s + "\n  var c = elt.getChildNodes();";
        s = s + "\n  for (var i = 0; c && i < c.getLength(); i++)";
        s = s + "\n    if (c.item(i).getNodeType() == 3)";
        s = s + "\n      return c.item(i).getNodeValue();";
        s = s + "\n  return '';";
        s = s + "\n}";
        DomElement script = this.createElement("script");
        parent.appendChild(script);
        DomText text = this.createText(s);
        script.appendChild(text);
    }
}

