/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoXMLSaveRestore;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.io.Serializable;

public class JGoPen
implements Serializable,
JGoXMLSaveRestore {
    public static final int NONE = 0;
    public static final int SOLID = 65535;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int DASHDOT = 3;
    public static final int DASHDOTDOT = 4;
    public static final int CUSTOM = 65534;
    public static final JGoPen black = new JGoPen(65535, 1, JGoBrush.ColorBlack);
    public static final JGoPen darkGray = new JGoPen(65535, 1, JGoBrush.ColorDarkGray);
    public static final JGoPen gray = new JGoPen(65535, 1, JGoBrush.ColorGray);
    public static final JGoPen lightGray = new JGoPen(65535, 1, JGoBrush.ColorLightGray);
    public static final JGoPen white = new JGoPen(65535, 1, JGoBrush.ColorWhite);
    public static final JGoPen red = new JGoPen(65535, 1, JGoBrush.ColorRed);
    public static final JGoPen magenta = new JGoPen(65535, 1, JGoBrush.ColorMagenta);
    public static final JGoPen yellow = new JGoPen(65535, 1, JGoBrush.ColorYellow);
    public static final JGoPen green = new JGoPen(65535, 1, JGoBrush.ColorGreen);
    public static final JGoPen cyan = new JGoPen(65535, 1, JGoBrush.ColorCyan);
    public static final JGoPen blue = new JGoPen(65535, 1, JGoBrush.ColorBlue);
    public static final JGoPen orange = new JGoPen(65535, 1, JGoBrush.ColorOrange);
    public static final JGoPen pink = new JGoPen(65535, 1, JGoBrush.ColorPink);
    public static final JGoPen Null = new JGoPen(0, 1, JGoBrush.ColorBlack);
    private int myStyle;
    private int myWidth;
    private Color myColor;
    private transient Stroke myStroke = null;

    public JGoPen() {
        this.myStyle = 65535;
        this.myWidth = 1;
        this.myColor = JGoBrush.ColorBlack;
        this.myStroke = null;
    }

    public JGoPen(int style, int width, Color color) {
        this.myStyle = style;
        this.myWidth = style == 0 ? 0 : Math.max(width, 1);
        this.myColor = color;
        this.myStroke = null;
    }

    public JGoPen(Stroke stroke, Color color) {
        this.myStyle = 65534;
        this.myWidth = stroke != null && stroke instanceof BasicStroke ? (int)((BasicStroke)stroke).getLineWidth() : 1;
        this.myColor = color;
        this.myStroke = stroke;
    }

    public static JGoPen makeStockPen(Color color) {
        if (color.equals(JGoBrush.ColorBlack)) {
            return black;
        }
        if (color.equals(JGoBrush.ColorDarkGray)) {
            return darkGray;
        }
        if (color.equals(JGoBrush.ColorGray)) {
            return gray;
        }
        if (color.equals(JGoBrush.ColorLightGray)) {
            return lightGray;
        }
        if (color.equals(JGoBrush.ColorWhite)) {
            return white;
        }
        if (color.equals(JGoBrush.ColorRed)) {
            return red;
        }
        if (color.equals(JGoBrush.ColorMagenta)) {
            return magenta;
        }
        if (color.equals(JGoBrush.ColorYellow)) {
            return yellow;
        }
        if (color.equals(JGoBrush.ColorGreen)) {
            return green;
        }
        if (color.equals(JGoBrush.ColorCyan)) {
            return cyan;
        }
        if (color.equals(JGoBrush.ColorBlue)) {
            return blue;
        }
        if (color.equals(JGoBrush.ColorOrange)) {
            return orange;
        }
        if (color.equals(JGoBrush.ColorPink)) {
            return pink;
        }
        return new JGoPen(65535, 1, color);
    }

    public static JGoPen make(int style, int width, Color color) {
        if (style == 0) {
            return Null;
        }
        if (style == 65535 && width == 1) {
            return JGoPen.makeStockPen(color);
        }
        return new JGoPen(style, width, color);
    }

    public int getStyle() {
        return this.myStyle;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public Color getColor() {
        return this.myColor;
    }

    public Stroke getStroke() {
        if (this.myStroke == null) {
            switch (this.getStyle()) {
                default: {
                    this.myStroke = null;
                    break;
                }
                case 65535: {
                    int width = this.getWidth();
                    this.myStroke = new BasicStroke(width, 0, 0, 10.0f);
                    break;
                }
                case 1: {
                    float w = this.getWidth();
                    float[] segs = new float[]{3.0f * w, w};
                    this.myStroke = new BasicStroke(w, 0, 0, 10.0f, segs, 0.0f);
                    break;
                }
                case 2: {
                    float w = this.getWidth();
                    float[] segs = new float[]{w, w};
                    this.myStroke = new BasicStroke(w, 0, 0, 10.0f, segs, 0.0f);
                    break;
                }
                case 3: {
                    float w = this.getWidth();
                    float[] segs = new float[]{3.0f * w, w, w, w};
                    this.myStroke = new BasicStroke(w, 0, 0, 10.0f, segs, 0.0f);
                    break;
                }
                case 4: {
                    float w = this.getWidth();
                    float[] segs = new float[]{3.0f * w, w, w, w, w, w};
                    this.myStroke = new BasicStroke(w, 0, 0, 10.0f, segs, 0.0f);
                    break;
                }
            }
        }
        return this.myStroke;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoPen = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoPen", jGoElementGroup);
            this.SVGWriteJGoElementAttributes(jGoPen);
            svgDoc.registerObject(this, jGoPen);
        }
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            this.SVGReadJGoElementAttributes(jGoChildElement);
            String sID = jGoChildElement.getAttribute("id");
            if (sID.length() > 0) {
                svgDoc.registerTag(sID, this);
            }
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        String sPen = "";
        if (this.getStyle() == 0) {
            sPen = "stroke:none;";
        } else {
            int nWidth = this.getWidth();
            sPen = "stroke-width:" + Integer.toString(nWidth) + ";";
            if (this.getStyle() == 1) {
                sPen = sPen + "stroke-dasharray:" + Integer.toString(nWidth * 3) + "," + Integer.toString(nWidth) + ";";
            } else if (this.getStyle() == 2) {
                sPen = sPen + "stroke-dasharray:" + Integer.toString(nWidth) + "," + Integer.toString(nWidth) + ";";
            } else if (this.getStyle() == 3) {
                sPen = sPen + "stroke-dasharray:" + Integer.toString(nWidth * 3) + "," + Integer.toString(nWidth) + "," + Integer.toString(nWidth) + "," + Integer.toString(nWidth) + ";";
            } else if (this.getStyle() == 4) {
                sPen = sPen + "stroke-dasharray:" + Integer.toString(nWidth * 3) + "," + Integer.toString(nWidth) + "," + Integer.toString(nWidth) + "," + Integer.toString(nWidth) + "," + Integer.toString(nWidth) + "," + Integer.toString(nWidth) + ";";
            }
            Color color = this.getColor();
            if (color == Color.black) {
                sPen = sPen + "stroke:black;";
            } else {
                int nRed = color.getRed();
                int nGreen = color.getGreen();
                int nBlue = color.getBlue();
                sPen = sPen + "stroke:rgb(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + ");";
            }
        }
        String sStyle = svgElement.getAttribute("style");
        sStyle = sStyle + sPen;
        svgElement.setAttribute("style", sStyle);
    }

    public void SVGReadAttributes(DomElement svgElement) {
        String style = svgElement.getAttribute("style");
        String strokeWidth = svgElement.getSubAttribute(style, "stroke-width");
        String stroke = svgElement.getSubAttribute(style, "stroke");
        String strokeDasharray = svgElement.getSubAttribute(style, "stroke-dasharray");
        for (DomNode parentNode = svgElement.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            if (!parentNode.isElement()) continue;
            DomElement parentElement = parentNode.elementCast();
            String parentStyle = parentElement.getAttribute("style");
            if (strokeWidth.length() == 0) {
                strokeWidth = parentElement.getSubAttribute(parentStyle, "stroke-width");
            }
            if (stroke.length() == 0) {
                stroke = parentElement.getSubAttribute(parentStyle, "stroke");
            }
            if (strokeDasharray.length() != 0) continue;
            strokeDasharray = parentElement.getSubAttribute(parentStyle, "stroke-dasharray");
        }
        int penWidth = 1;
        if (strokeWidth.length() > 0) {
            penWidth = Integer.parseInt(strokeWidth);
        }
        int penType = 65535;
        Color penColor = JGoBrush.ColorBlack;
        if (stroke.length() > 0) {
            if (stroke.equals("none")) {
                penType = 0;
            } else if (stroke.equalsIgnoreCase("black")) {
                penColor = JGoBrush.ColorBlack;
            } else if (stroke.equalsIgnoreCase("darkGray")) {
                penColor = JGoBrush.ColorDarkGray;
            } else if (stroke.equalsIgnoreCase("gray")) {
                penColor = JGoBrush.ColorGray;
            } else if (stroke.equalsIgnoreCase("lightGray")) {
                penColor = JGoBrush.ColorLightGray;
            } else if (stroke.equalsIgnoreCase("white")) {
                penColor = JGoBrush.ColorWhite;
            } else if (stroke.equalsIgnoreCase("red")) {
                penColor = JGoBrush.ColorRed;
            } else if (stroke.equalsIgnoreCase("magenta")) {
                penColor = JGoBrush.ColorMagenta;
            } else if (stroke.equalsIgnoreCase("yellow")) {
                penColor = JGoBrush.ColorYellow;
            } else if (stroke.equalsIgnoreCase("green")) {
                penColor = JGoBrush.ColorGreen;
            } else if (stroke.equalsIgnoreCase("cyan")) {
                penColor = JGoBrush.ColorCyan;
            } else if (stroke.equalsIgnoreCase("blue")) {
                penColor = JGoBrush.ColorBlue;
            } else if (stroke.equalsIgnoreCase("orange")) {
                penColor = JGoBrush.ColorOrange;
            } else if (stroke.equalsIgnoreCase("pink")) {
                penColor = JGoBrush.ColorPink;
            } else if (stroke.startsWith("rgb")) {
                int nAttStart = stroke.indexOf("(") + 1;
                int nAttEnd = stroke.indexOf(",", nAttStart);
                String red = stroke.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = stroke.indexOf(",", nAttStart);
                String green = stroke.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = stroke.indexOf(")", nAttStart);
                String blue = stroke.substring(nAttStart, nAttEnd);
                penColor = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue));
            }
        }
        this.myStyle = penType;
        this.myWidth = penWidth;
        this.myColor = penColor;
    }

    private void SVGWriteJGoElementAttributes(DomElement svgElement) {
        svgElement.setAttribute("penstyle", Integer.toString(this.myStyle));
        svgElement.setAttribute("penwidth", Integer.toString(this.myWidth));
        String pencolor = "black";
        if (this.myColor == JGoBrush.ColorBlack) {
            pencolor = "black";
        } else if (this.myColor == JGoBrush.ColorLightGray) {
            pencolor = "lightGray";
        } else if (this.myColor == JGoBrush.ColorDarkGray) {
            pencolor = "darkGray";
        } else if (this.myColor == JGoBrush.ColorGray) {
            pencolor = "gray";
        } else if (this.myColor == JGoBrush.ColorWhite) {
            pencolor = "white";
        } else if (this.myColor == JGoBrush.ColorRed) {
            pencolor = "red";
        } else if (this.myColor == JGoBrush.ColorMagenta) {
            pencolor = "magenta";
        } else if (this.myColor == JGoBrush.ColorYellow) {
            pencolor = "yellow";
        } else if (this.myColor == JGoBrush.ColorGreen) {
            pencolor = "green";
        } else if (this.myColor == JGoBrush.ColorCyan) {
            pencolor = "cyan";
        } else if (this.myColor == JGoBrush.ColorBlue) {
            pencolor = "blue";
        } else if (this.myColor == JGoBrush.ColorOrange) {
            pencolor = "orange";
        } else if (this.myColor == JGoBrush.ColorPink) {
            pencolor = "pink";
        } else {
            int nRed = this.myColor.getRed();
            int nGreen = this.myColor.getGreen();
            int nBlue = this.myColor.getBlue();
            int nAlpha = this.myColor.getAlpha();
            pencolor = "rgbalpha(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + "," + Integer.toString(nAlpha) + ")";
        }
        svgElement.setAttribute("pencolor", pencolor);
    }

    private void SVGReadJGoElementAttributes(DomElement svgElement) {
        String penstyle = svgElement.getAttribute("penstyle");
        this.myStyle = Integer.parseInt(penstyle);
        String penwidth = svgElement.getAttribute("penwidth");
        this.myWidth = Integer.parseInt(penwidth);
        String pencolor = svgElement.getAttribute("pencolor");
        if (pencolor.equals("black")) {
            this.myColor = JGoBrush.ColorBlack;
        } else if (pencolor.equals("darkGray")) {
            this.myColor = JGoBrush.ColorDarkGray;
        } else if (pencolor.equals("gray")) {
            this.myColor = JGoBrush.ColorGray;
        } else if (pencolor.equals("lightGray")) {
            this.myColor = JGoBrush.ColorLightGray;
        } else if (pencolor.equals("white")) {
            this.myColor = JGoBrush.ColorWhite;
        } else if (pencolor.equals("red")) {
            this.myColor = JGoBrush.ColorRed;
        } else if (pencolor.equals("magenta")) {
            this.myColor = JGoBrush.ColorMagenta;
        } else if (pencolor.equals("yellow")) {
            this.myColor = JGoBrush.ColorYellow;
        } else if (pencolor.equals("green")) {
            this.myColor = JGoBrush.ColorGreen;
        } else if (pencolor.equals("cyan")) {
            this.myColor = JGoBrush.ColorCyan;
        } else if (pencolor.equals("blue")) {
            this.myColor = JGoBrush.ColorBlue;
        } else if (pencolor.equals("orange")) {
            this.myColor = JGoBrush.ColorOrange;
        } else if (pencolor.equals("pink")) {
            this.myColor = JGoBrush.ColorPink;
        } else if (pencolor.startsWith("rgbalpha")) {
            int nAttStart = pencolor.indexOf("(") + 1;
            int nAttEnd = pencolor.indexOf(",", nAttStart);
            String red = pencolor.substring(nAttStart, nAttEnd);
            nAttStart = nAttEnd + 1;
            nAttEnd = pencolor.indexOf(",", nAttStart);
            String green = pencolor.substring(nAttStart, nAttEnd);
            nAttStart = nAttEnd + 1;
            nAttEnd = pencolor.indexOf(",", nAttStart);
            String blue = pencolor.substring(nAttStart, nAttEnd);
            nAttStart = nAttEnd + 1;
            nAttEnd = pencolor.indexOf(")", nAttStart);
            String alpha = pencolor.substring(nAttStart, nAttEnd);
            this.myColor = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue), Integer.parseInt(alpha));
        }
    }
}

