/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoXMLSaveRestore;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;

public class JGoBrush
implements Serializable,
JGoXMLSaveRestore {
    public static final Color ColorBlack = Color.black;
    public static final Color ColorDarkGray = Color.darkGray;
    public static final Color ColorGray = Color.gray;
    public static final Color ColorLightGray = Color.lightGray;
    public static final Color ColorWhite = Color.white;
    public static final Color ColorRed = Color.red;
    public static final Color ColorMagenta = Color.magenta;
    public static final Color ColorYellow = Color.yellow;
    public static final Color ColorGreen = Color.green;
    public static final Color ColorCyan = Color.cyan;
    public static final Color ColorBlue = Color.blue;
    public static final Color ColorOrange = Color.orange;
    public static final Color ColorPink = Color.pink;
    public static final int NONE = 0;
    public static final int SOLID = 65535;
    public static final int CUSTOM = 65534;
    public static final JGoBrush black = new JGoBrush(65535, ColorBlack);
    public static final JGoBrush darkGray = new JGoBrush(65535, ColorDarkGray);
    public static final JGoBrush gray = new JGoBrush(65535, ColorGray);
    public static final JGoBrush lightGray = new JGoBrush(65535, ColorLightGray);
    public static final JGoBrush white = new JGoBrush(65535, ColorWhite);
    public static final JGoBrush red = new JGoBrush(65535, ColorRed);
    public static final JGoBrush magenta = new JGoBrush(65535, ColorMagenta);
    public static final JGoBrush yellow = new JGoBrush(65535, ColorYellow);
    public static final JGoBrush green = new JGoBrush(65535, ColorGreen);
    public static final JGoBrush cyan = new JGoBrush(65535, ColorCyan);
    public static final JGoBrush blue = new JGoBrush(65535, ColorBlue);
    public static final JGoBrush orange = new JGoBrush(65535, ColorOrange);
    public static final JGoBrush pink = new JGoBrush(65535, ColorPink);
    public static final JGoBrush Null = new JGoBrush(0, null);
    private int myStyle;
    private Color myColor;
    private transient Paint myPaint = null;

    public JGoBrush() {
        this.myStyle = 0;
        this.myColor = null;
        this.myPaint = null;
    }

    public JGoBrush(int style, Color color) {
        this.myStyle = style;
        this.myColor = color;
        this.myPaint = color;
    }

    public JGoBrush(Paint paint) {
        this.myPaint = paint;
        if (paint instanceof Color) {
            this.myStyle = 65535;
            this.myColor = (Color)paint;
        } else {
            this.myStyle = 65534;
            this.myColor = null;
        }
    }

    public static JGoBrush makeStockBrush(Color color) {
        if (color.equals(ColorBlack)) {
            return black;
        }
        if (color.equals(ColorDarkGray)) {
            return darkGray;
        }
        if (color.equals(ColorGray)) {
            return gray;
        }
        if (color.equals(ColorLightGray)) {
            return lightGray;
        }
        if (color.equals(ColorWhite)) {
            return white;
        }
        if (color.equals(ColorRed)) {
            return red;
        }
        if (color.equals(ColorMagenta)) {
            return magenta;
        }
        if (color.equals(ColorYellow)) {
            return yellow;
        }
        if (color.equals(ColorGreen)) {
            return green;
        }
        if (color.equals(ColorCyan)) {
            return cyan;
        }
        if (color.equals(ColorBlue)) {
            return blue;
        }
        if (color.equals(ColorOrange)) {
            return orange;
        }
        if (color.equals(ColorPink)) {
            return pink;
        }
        return new JGoBrush(65535, color);
    }

    public static JGoBrush make(int style, Color color) {
        if (style == 65535) {
            return JGoBrush.makeStockBrush(color);
        }
        return Null;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoBrush = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoBrush", jGoElementGroup);
            this.SVGWriteJGoElementAttributes(jGoBrush);
            svgDoc.registerObject(this, jGoBrush);
        }
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            this.SVGReadJGoElementAttributes(jGoChildElement);
            String sID = jGoChildElement.getAttribute("id");
            if (sID.length() > 0) {
                svgDoc.registerTag(sID, this);
            }
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        String sFill = "fill:none;";
        if (this.getStyle() == 0) {
            sFill = "fill:none;";
        } else if (this.getStyle() == 65535) {
            Color color = this.getColor();
            int nRed = color.getRed();
            int nGreen = color.getGreen();
            int nBlue = color.getBlue();
            sFill = "fill:rgb(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + ");";
        }
        String sStyle = svgElement.getAttribute("style");
        sStyle = sStyle + sFill;
        svgElement.setAttribute("style", sStyle);
    }

    public void SVGReadAttributes(DomElement svgElement) {
        String style = svgElement.getAttribute("style");
        String fill = svgElement.getSubAttribute(style, "fill");
        for (DomNode parentNode = svgElement.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            if (!parentNode.isElement()) continue;
            DomElement parentElement = parentNode.elementCast();
            String parentStyle = parentElement.getAttribute("style");
            if (fill.length() != 0) continue;
            fill = parentElement.getSubAttribute(parentStyle, "fill");
        }
        boolean brushType = false;
        Color brushColor = null;
        if (fill.length() > 0) {
            if (fill.equals("none")) {
                brushType = false;
            } else if (fill.equalsIgnoreCase("black")) {
                brushColor = ColorBlack;
            } else if (fill.equalsIgnoreCase("darkGray")) {
                brushColor = ColorDarkGray;
            } else if (fill.equalsIgnoreCase("gray")) {
                brushColor = ColorGray;
            } else if (fill.equalsIgnoreCase("lightGray")) {
                brushColor = ColorLightGray;
            } else if (fill.equalsIgnoreCase("white")) {
                brushColor = ColorWhite;
            } else if (fill.equalsIgnoreCase("red")) {
                brushColor = ColorRed;
            } else if (fill.equalsIgnoreCase("magenta")) {
                brushColor = ColorMagenta;
            } else if (fill.equalsIgnoreCase("yellow")) {
                brushColor = ColorYellow;
            } else if (fill.equalsIgnoreCase("green")) {
                brushColor = ColorGreen;
            } else if (fill.equalsIgnoreCase("cyan")) {
                brushColor = ColorCyan;
            } else if (fill.equalsIgnoreCase("blue")) {
                brushColor = ColorBlue;
            } else if (fill.equalsIgnoreCase("orange")) {
                brushColor = ColorOrange;
            } else if (fill.equalsIgnoreCase("pink")) {
                brushColor = ColorPink;
            } else if (fill.startsWith("rgb")) {
                int nAttStart = fill.indexOf("(") + 1;
                int nAttEnd = fill.indexOf(",", nAttStart);
                String red = fill.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = fill.indexOf(",", nAttStart);
                String green = fill.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = fill.indexOf(")", nAttStart);
                String blue = fill.substring(nAttStart, nAttEnd);
                brushColor = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue));
            }
            if (brushColor != null) {
                this.myStyle = 65535;
                this.myColor = brushColor;
            }
        }
    }

    private void SVGWriteJGoElementAttributes(DomElement svgElement) {
        svgElement.setAttribute("brushstyle", Integer.toString(this.myStyle));
        if (this.myColor != null) {
            String brushcolor = "black";
            if (this.myColor == ColorBlack) {
                brushcolor = "black";
            } else if (this.myColor == ColorDarkGray) {
                brushcolor = "darkGray";
            } else if (this.myColor == ColorGray) {
                brushcolor = "gray";
            } else if (this.myColor == ColorLightGray) {
                brushcolor = "lightGray";
            } else if (this.myColor == ColorWhite) {
                brushcolor = "white";
            } else if (this.myColor == ColorRed) {
                brushcolor = "red";
            } else if (this.myColor == ColorMagenta) {
                brushcolor = "magenta";
            } else if (this.myColor == ColorYellow) {
                brushcolor = "yellow";
            } else if (this.myColor == ColorGreen) {
                brushcolor = "green";
            } else if (this.myColor == ColorCyan) {
                brushcolor = "cyan";
            } else if (this.myColor == ColorBlue) {
                brushcolor = "blue";
            } else if (this.myColor == ColorOrange) {
                brushcolor = "orange";
            } else if (this.myColor == ColorPink) {
                brushcolor = "pink";
            } else {
                int nRed = this.myColor.getRed();
                int nGreen = this.myColor.getGreen();
                int nBlue = this.myColor.getBlue();
                int nAlpha = this.myColor.getAlpha();
                brushcolor = "rgbalpha(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + "," + Integer.toString(nAlpha) + ")";
            }
            svgElement.setAttribute("brushcolor", brushcolor);
        }
    }

    private void SVGReadJGoElementAttributes(DomElement svgElement) {
        String brushstyle = svgElement.getAttribute("brushstyle");
        this.myStyle = Integer.parseInt(brushstyle);
        String brushcolor = svgElement.getAttribute("brushcolor");
        if (brushcolor.length() > 0) {
            if (brushcolor.equals("black")) {
                this.myColor = ColorBlack;
            } else if (brushcolor.equals("darkGray")) {
                this.myColor = ColorDarkGray;
            } else if (brushcolor.equals("gray")) {
                this.myColor = ColorGray;
            } else if (brushcolor.equals("lightGray")) {
                this.myColor = ColorLightGray;
            } else if (brushcolor.equals("white")) {
                this.myColor = ColorWhite;
            } else if (brushcolor.equals("red")) {
                this.myColor = ColorRed;
            } else if (brushcolor.equals("magenta")) {
                this.myColor = ColorMagenta;
            } else if (brushcolor.equals("yellow")) {
                this.myColor = ColorYellow;
            } else if (brushcolor.equals("green")) {
                this.myColor = ColorGreen;
            } else if (brushcolor.equals("cyan")) {
                this.myColor = ColorCyan;
            } else if (brushcolor.equals("blue")) {
                this.myColor = ColorBlue;
            } else if (brushcolor.equals("orange")) {
                this.myColor = ColorOrange;
            } else if (brushcolor.equals("pink")) {
                this.myColor = ColorPink;
            } else if (brushcolor.startsWith("rgbalpha")) {
                int nAttStart = brushcolor.indexOf("(") + 1;
                int nAttEnd = brushcolor.indexOf(",", nAttStart);
                String red = brushcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = brushcolor.indexOf(",", nAttStart);
                String green = brushcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = brushcolor.indexOf(",", nAttStart);
                String blue = brushcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = brushcolor.indexOf(")", nAttStart);
                String alpha = brushcolor.substring(nAttStart, nAttEnd);
                this.myColor = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue), Integer.parseInt(alpha));
            }
        }
    }

    public int getStyle() {
        return this.myStyle;
    }

    public Paint getPaint() {
        if (this.myPaint == null) {
            switch (this.getStyle()) {
                default: {
                    this.myPaint = null;
                    break;
                }
                case 65535: {
                    this.myPaint = this.myColor;
                }
            }
        }
        return this.myPaint;
    }

    public Color getColor() {
        return this.myColor;
    }
}

