/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.util;

public class Cord {
    protected final int[] mValue;
    public static final int MAX_CODE = 0x10FFFF;
    public static final int MAX_CHAR = 65535;
    private static final int SUR_HI_MIN = 55296;
    private static final int SUR_HI_MAX = 56319;
    private static final int SUR_LO_MIN = 56320;
    private static final int SUR_LO_MAX = 57343;

    public Cord(int[] value) {
        if (value == null) {
            throw new NullPointerException("no value");
        }
        for (int i = 0; i < value.length; ++i) {
            int c = value[i];
            if (c >= 0 && 0x10FFFF >= c) continue;
            throw new IllegalArgumentException("invalid char[" + i + "]:" + c);
        }
        this.mValue = value;
    }

    public Cord(String value) {
        if (value == null) {
            throw new NullPointerException("no value");
        }
        int len = value.length();
        int pos = 0;
        int[] v = new int[value.length()];
        for (int i = 0; i < len; ++i) {
            char d;
            int c = value.charAt(i);
            if (55296 <= c && c <= 56319 && i + 1 < len && '\udc00' <= (d = value.charAt(i + 1)) && d <= '\udfff') {
                ++i;
                if (0x10FFFF < (c = ((c & 0x3FF) << 10) + (d & 0x3FF))) {
                    throw new IllegalArgumentException("invalid composite char[" + i + "]:" + c);
                }
            }
            v[pos++] = c;
        }
        if (pos < len) {
            int[] copy = new int[pos];
            while (pos-- > 0) {
                copy[pos] = v[pos];
            }
            v = copy;
        }
        this.mValue = v;
    }

    public int charAt(int index) {
        if (index < 0 || this.mValue.length <= index) {
            throw new IndexOutOfBoundsException("index " + index + " not in range 0..." + (this.mValue.length - 1));
        }
        return this.mValue[index];
    }

    public int length() {
        return this.mValue.length;
    }

    public Cord concat(Cord cord) {
        if (cord == null || cord.mValue.length == 0) {
            return this;
        }
        if (this.mValue.length == 0) {
            return cord;
        }
        int[] value = new int[this.mValue.length + cord.mValue.length];
        System.arraycopy(this.mValue, 0, value, 0, this.mValue.length);
        System.arraycopy(cord.mValue, 0, value, this.mValue.length, cord.mValue.length);
        return new Cord(value);
    }

    public static Cord copyValueOf(int[] data) {
        return Cord.copyValueOf(data, 0, data == null ? 0 : data.length);
    }

    public static Cord copyValueOf(int[] data, int offset, int count) {
        if (offset < 0) {
            throw new IllegalArgumentException("negative offset: " + offset);
        }
        if (count < 0) {
            throw new IllegalArgumentException("negative count: " + count);
        }
        if (data == null) {
            return null;
        }
        int[] value = new int[count];
        System.arraycopy(data, offset, value, 0, count);
        return new Cord(value);
    }

    public boolean endsWith(Cord suffix) {
        if (suffix == null) {
            return false;
        }
        int off = this.mValue.length - suffix.mValue.length;
        if (off < 0) {
            return false;
        }
        int i = suffix.mValue.length;
        while (i-- > 0) {
            if (suffix.mValue[i] == this.mValue[off + i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Cord cord) {
        if (cord == null || cord.length() != this.mValue.length) {
            return false;
        }
        for (int i = 0; i < this.mValue.length; ++i) {
            if (this.mValue[i] == cord.mValue[i]) continue;
            return false;
        }
        return true;
    }

    public int indexOf(int c, int from) {
        if (from < 0) {
            from = 0;
        }
        while (from < this.mValue.length) {
            if (this.mValue[from] == c) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public int lastIndexOf(int c, int from) {
        if (from >= this.mValue.length) {
            from = this.mValue.length - 1;
        }
        while (from >= 0) {
            if (this.mValue[from] == c) {
                return from;
            }
            --from;
        }
        return -1;
    }

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.mValue.length - 1);
    }

    public boolean startsWith(Cord prefix) {
        if (prefix == null || this.mValue.length < prefix.mValue.length) {
            return false;
        }
        int i = prefix.mValue.length;
        while (i-- > 0) {
            if (prefix.mValue[i] == this.mValue[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int size = this.mValue.length;
        for (int i = 0; i < this.mValue.length; ++i) {
            if (65535 >= this.mValue[i]) continue;
            ++size;
        }
        char[] s = new char[size];
        size = 0;
        for (int i = 0; i < this.mValue.length; ++i) {
            int c = this.mValue[i];
            if (65535 < c) {
                s[size++] = (char)(55296 + (c >> 10));
                s[size++] = (char)(56320 + (c & 0x3FF));
                continue;
            }
            s[size++] = (char)c;
        }
        return new String(s);
    }
}

