/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder;

import com.sun.encoder.DataNature;
import com.sun.encoder.EncoderProperties;
import java.io.Serializable;

public class EncoderType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EncoderType mBasicType;
    private final String mIdentification;
    private final DataNature mDataNature;
    private final EncoderProperties mProperties;

    EncoderType(String identification, DataNature dataNature) {
        if (identification == null) {
            throw new IllegalArgumentException("null identification");
        }
        if (dataNature == null) {
            throw new IllegalArgumentException("null data nature");
        }
        this.mBasicType = null;
        this.mIdentification = identification;
        this.mDataNature = dataNature;
        this.mProperties = null;
    }

    EncoderType(EncoderType basicType, EncoderProperties properties) {
        if (basicType == null) {
            throw new IllegalArgumentException("null basic encoder type");
        }
        this.mBasicType = basicType;
        this.mIdentification = basicType.getIdentification();
        this.mDataNature = basicType.getDataNature();
        this.mProperties = properties;
    }

    public boolean isBasic() {
        return this.mBasicType == null;
    }

    public String getIdentification() {
        return this.mIdentification;
    }

    public DataNature getDataNature() {
        return this.mDataNature;
    }

    public EncoderType getBasicType() {
        if (this.mBasicType == null) {
            return this;
        }
        return this.mBasicType;
    }

    public EncoderProperties getEncoderProperties() {
        return this.mProperties;
    }
}

