/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.runtime;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ServiceCreationException;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.DefaultServiceConfiguration;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceBuilder;

public class Jbi4CorbaServiceConfiguration
extends DefaultServiceConfiguration {
    protected List wsdlServices;
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CorbaServiceConfiguration.class);

    public Jbi4CorbaServiceConfiguration(Definition wsdlDefinition) throws ServiceCreationException {
        WSDLServiceBuilder wsdlServiceBuilder = new WSDLServiceBuilder(wsdlDefinition);
        this.debug(wsdlDefinition);
        try {
            wsdlServiceBuilder.build();
        }
        catch (Exception e) {
            LOG.error("Error in loading service from WSDL");
            throw new ServiceCreationException(e);
        }
        this.wsdlServices = wsdlServiceBuilder.getAllServices();
    }

    protected void debug(Definition def) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        for (Object s : def.getServices().keySet()) {
            javax.wsdl.Service se = (javax.wsdl.Service)def.getServices().get(s);
            LOG.debug("___ SERVICE. key=" + s + "; object=" + se + "; class=" + se.getClass());
            for (Object p : se.getPorts().keySet()) {
                Port port = (Port)se.getPorts().get(p);
                LOG.debug("___ PORT. key=" + p + "; object=" + port + "; class=" + port.getClass());
                Binding binding = port.getBinding();
                List bindingOperations = binding.getBindingOperations();
                for (int i = 0; i < bindingOperations.size(); ++i) {
                    LOG.debug("__ I=" + i);
                    BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(i);
                    LOG.debug("__ BindingOperation=" + bindingOperation);
                    LOG.debug("__ OpInfo=" + bindingOperation.getOperation());
                    String opName = bindingOperation.getOperation() == null ? "NullPointer" : bindingOperation.getOperation().getName();
                    LOG.debug("__ OpInfo.name=" + opName);
                }
            }
        }
    }

    protected void initMEP() {
        if (this.wsdlServices == null || this.wsdlServices.size() == 0) {
            LOG.debug("NO SERVICE");
            return;
        }
        for (Object sx : this.wsdlServices) {
            Service service = (Service)sx;
            for (Object opx : service.getServiceInfo().getOperations()) {
                OperationInfo opInfo = (OperationInfo)opx;
                if (opInfo.hasOutput()) {
                    LOG.debug("Service=" + service.getSimpleName() + "; OperationInfo=" + opInfo.getName() + "; JbiMep=InOut");
                    continue;
                }
                if (!opInfo.getFaults().isEmpty()) continue;
                LOG.debug("Service=" + service.getSimpleName() + "; OperationInfo=" + opInfo.getName() + "; JbiMep=InOnly");
                opInfo.setMEP("urn:xfire:mep:in");
                opInfo.setAsync(true);
            }
        }
    }

    public QName getInputMessageName(OperationInfo op) {
        Service wsdlService = this.getService(op);
        LOG.debug("Service=" + wsdlService);
        OperationInfo opInfo = wsdlService.getServiceInfo().getOperation(op.getName());
        LOG.debug("OperationInfo=" + opInfo);
        LOG.debug("Requesting operation with name: " + op.getName());
        LOG.debug("=============================================");
        LOG.debug("The input message is 1:" + opInfo);
        LOG.debug("The input message is 2:" + opInfo.getInputMessage());
        LOG.debug("The input message is 3:" + opInfo.getInputMessage().getName());
        LOG.debug("=============================================");
        return opInfo.getInputMessage().getName();
    }

    public QName getOutputMessageName(OperationInfo op) {
        LOG.debug("______________ getOutputMessageName. op=" + op);
        Service wsdlService = this.getService(op);
        OperationInfo opInfo = wsdlService.getServiceInfo().getOperation(op.getName());
        LOG.debug("Requesting operation with name: " + op.getName());
        if (opInfo.getOutputMessage() == null) {
            LOG.debug("The output message is null ... probably a oneway operation.");
            return new QName("", "");
        }
        LOG.debug("The output message is: " + opInfo.getOutputMessage().getName());
        return opInfo.getOutputMessage().getName();
    }

    private Service getService(OperationInfo op) {
        String serviceName = op.getService().getService().getSimpleName();
        LOG.debug("serviceName=" + serviceName);
        for (int i = 0; i < this.wsdlServices.size(); ++i) {
            String simpleName = ((Service)this.wsdlServices.get(i)).getSimpleName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("simpleName[" + i + "]=" + simpleName + "(serviceName should be:" + serviceName + ")");
            }
            if (!simpleName.equals(serviceName)) continue;
            return (Service)this.wsdlServices.get(i);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No service found with name: " + serviceName + " returning: " + ((Service)this.wsdlServices.get(0)).getSimpleName());
        }
        return (Service)this.wsdlServices.get(0);
    }
}

