/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ValueTypeAdapter
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ValueTypeAdapter.class);
    protected ClassWriter classWriter = null;
    protected String className = null;

    public ValueTypeAdapter(ClassVisitor cv, ClassWriter cw, String cn) {
        super(cv);
        this.classWriter = cw;
        this.className = cn;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug(">>>>> visit - begin");
        LOG.debug("VISIT.\n version=" + version + ";\n access=" + access + ";\n name=" + name + ";\n signature=" + signature + ";\n superName=" + superName + ";\n interfaces=" + interfaces);
        if (interfaces == null || interfaces.length == 0) {
            interfaces = new String[]{"java/io/Serializable"};
        } else {
            String[] temp = new String[interfaces.length + 1];
            System.arraycopy(interfaces, 0, temp, 0, interfaces.length);
            temp[interfaces.length] = "java/io/Serializable";
            interfaces = temp;
        }
        LOG.debug("<<<<< visit - end");
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        LOG.debug(">>>>> visitField - begin");
        if ((8 & access) != 8) {
            access = 1;
        }
        LOG.debug("The field " + name + " will be 'public'.");
        LOG.debug(">>>>> visitField - end");
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        LOG.debug(">>>>> visitMethod - begin");
        LOG.debug("visitMethod. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; exceptions=" + exceptions);
        if (this.isGetter(name, desc) || this.isSetter(name, desc)) {
            LOG.debug("<<<<< visitMethod - remove method:" + name);
            return null;
        }
        LOG.debug("<<<<< visitMethod - untouched:" + name);
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private boolean isGetter(String methodName, String params) {
        if (methodName == null) {
            return false;
        }
        if (methodName.startsWith("get") && params.startsWith("()") && methodName.length() > 3) {
            return true;
        }
        return methodName.startsWith("is") && params.startsWith("()") && methodName.length() > 2;
    }

    private boolean isSetter(String methodName, String params) {
        if (methodName == null) {
            return false;
        }
        if (methodName.length() <= 3) {
            return false;
        }
        return methodName.startsWith("set") && !params.startsWith("()");
    }
}

