/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.xfire.fault.FaultInfoException;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TweakRemoteInterfaceException
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TweakRemoteInterfaceException.class);
    private final ClassLoader classLoader;
    private final List<String> exceptionsAdded = new ArrayList<String>();

    public TweakRemoteInterfaceException(ClassVisitor arg0, ClassLoader classLoader) {
        super(arg0);
        this.classLoader = classLoader;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        ArrayList<String> newExceptions = new ArrayList<String>();
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                String exception = exceptions[i];
                String exceptionName = exception.replace('/', '.');
                LOG.debug("Exception found in method " + name + ": " + exceptionName);
                Class<?> myExceptionClass = null;
                try {
                    myExceptionClass = this.classLoader.loadClass(exceptionName);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn(e.getMessage());
                }
                if (myExceptionClass == null) continue;
                if (myExceptionClass.getGenericSuperclass().equals(FaultInfoException.class)) {
                    LOG.debug("The exception: " + exceptionName + " is a FaultInfoException");
                }
                Method getFaultInfoMethod = null;
                try {
                    getFaultInfoMethod = myExceptionClass.getMethod("getFaultInfo", new Class[0]);
                }
                catch (SecurityException e) {
                    LOG.warn(e.getMessage());
                }
                catch (NoSuchMethodException e) {
                    LOG.warn(e.getMessage());
                }
                if (getFaultInfoMethod == null) continue;
                Class<?> returnType = getFaultInfoMethod.getReturnType();
                String exceptionInternalName = returnType.getName().replace('.', '/');
                newExceptions.add(exceptionInternalName);
                if (this.exceptionsAdded.contains(returnType.getName())) continue;
                this.exceptionsAdded.add(returnType.getName());
            }
        }
        String[] newExceptionsArray = newExceptions.toArray(new String[0]);
        for (int i = 0; i < newExceptionsArray.length; ++i) {
            LOG.debug("modifiying the method " + name + " with the exception: " + newExceptionsArray[i]);
        }
        return super.visitMethod(access, name, desc, signature, newExceptionsArray);
    }

    public List<String> getExceptionsAdded() {
        return this.exceptionsAdded;
    }
}

