/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.jbi.Messages;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class ByteCodeManipulationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ByteCodeManipulationUtil.class);
    private static final Messages MESSAGES = Messages.getMessages(ByteCodeManipulationUtil.class);

    String bytecodeClassName(String cn) {
        String suffix = ".class";
        if (cn == null) {
            LOG.error("CRB000601_Class_name_is_null");
            throw new NullPointerException(MESSAGES.getString("CRB000601_Class_name_is_null", new Object[0]));
        }
        String bcn = cn.substring(0, cn.length() - ".class".length());
        bcn = bcn.replace(".", "/");
        LOG.debug("bytecodeClassName:" + bcn);
        return bcn;
    }

    void createSetter(ClassWriter classWriter, String className, String propertyName, String type) {
        LOG.debug(">>>>> createSetter - begin");
        LOG.debug("createSetter.propertyName=" + propertyName + "; type=" + type);
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        MethodVisitor mv = classWriter.visitMethod(1, methodName, "(" + type + ")V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(Type.getType((String)type).getOpcode(21), 1);
        mv.visitFieldInsn(181, this.bytecodeClassName(className), propertyName, type);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        LOG.debug("<<<<< createSetter - end");
    }

    void createGetter(ClassWriter classWriter, String className, String propertyName, String returnType) {
        LOG.debug(">>>>> createGetter - begin");
        LOG.debug("createGetter.propertyName=" + propertyName + "; returnType=" + returnType);
        String methodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + returnType, null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.bytecodeClassName(className), propertyName, returnType);
        mv.visitInsn(Type.getType((String)returnType).getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        LOG.debug("<<<<< createGetter - end");
    }

    void createToString(ClassWriter classWriter) {
        MethodVisitor mv = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        Label start = new Label();
        mv.visitLabel(start);
        mv.visitLineNumber(53, start);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "org/apache/commons/lang/builder/ReflectionToStringBuilder", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
        mv.visitInsn(176);
        Label stop = new Label();
        mv.visitLabel(stop);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    void createEquals(ClassWriter classWriter) {
        MethodVisitor mv = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        Label start = new Label();
        mv.visitLabel(start);
        mv.visitLineNumber(53, start);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "org/apache/commons/lang/builder/EqualsBuilder", "reflectionEquals", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
        mv.visitInsn(172);
        Label stop = new Label();
        mv.visitLabel(stop);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }
}

