/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ClassGenerationException;
import it.imolinfo.jbi4corba.exception.WSDLGenerationException;
import it.imolinfo.jbi4corba.jbi.JbiServiceDescriptor;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaAddress;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaBinding;
import it.imolinfo.jbi4corba.jbi.wsdl.Jbi4CorbaExtension;
import it.imolinfo.jbi4corba.jbi.xfire.JbiTransport;
import it.imolinfo.jbi4corba.webservice.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.generator.ClientCorbaClassesHolder;
import it.imolinfo.jbi4corba.webservice.generator.CodeGenerationProperties;
import it.imolinfo.jbi4corba.webservice.generator.ProviderServiceClassesGenerator;
import it.imolinfo.jbi4corba.webservice.generator.WSDLDescriptor;
import it.imolinfo.jbi4corba.webservice.runtime.ProviderServiceCreator;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.xfire.DefaultXFire;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class WSDLGenerator {
    private static final WSDLGenerator THE_INSTANCE = new WSDLGenerator();
    private static final Logger LOG = LoggerFactory.getLogger(WSDLGenerator.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private WSDLGenerator() {
    }

    public static WSDLGenerator getWSDLGenerator() {
        return THE_INSTANCE;
    }

    public Definition generateWSDLfromIDL(File idlFile, WSDLDescriptor desc) throws ClassGenerationException, IOException, WSDLException, WSDLGenerationException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        String stringWsdl = this.createWSDLfromIDLFile(idlFile, desc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(stringWsdl);
        }
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        QName oldBindingName = new QName(desc.getNamespace(), desc.getCorbaServiceName() + "JBIBinding");
        Jbi4CorbaExtension.register(registry);
        Document wsdlDoc = this.parseWsdlDocument(stringWsdl);
        LOG.debug("wsdlDoc.getDocumentURI():" + wsdlDoc.getDocumentURI());
        Definition def = reader.readWSDL(wsdlDoc.getDocumentURI(), wsdlDoc);
        def.setExtensionRegistry(registry);
        def.addNamespace("imolacorba", "uri://schemas.imola.it/jbi/wsdl-extensions/corba/");
        def.removeService(new QName(desc.getNamespace(), desc.getCorbaServiceName()));
        javax.wsdl.Service service = def.createService();
        service.setQName(new QName(desc.getNamespace(), desc.getEndpointName()));
        def.addService(service);
        Port port = def.createPort();
        port.setName(desc.getEndpointName() + "CorbaPort");
        service.addPort(port);
        Jbi4CorbaAddress address = new Jbi4CorbaAddress();
        address.setElementType(Jbi4CorbaExtension.Q_ELEM_JBI4CORBA_ADDRESS);
        address.setName(desc.getCorbaServiceName());
        address.setLocalizationType("NameService");
        address.setOrbProperties(desc.getOrbProperties());
        port.addExtensibilityElement((ExtensibilityElement)address);
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setQName(new QName(desc.getNamespace(), desc.getEndpointName() + "CorbaBinding"));
        binding.setPortType(def.getPortType(new QName(desc.getNamespace(), desc.getEndpointName())));
        port.setBinding(binding);
        def.addBinding(binding);
        for (Object o : def.getBinding(oldBindingName).getBindingOperations()) {
            BindingOperation bo = (BindingOperation)o;
            Operation op = bo.getOperation();
            BindingInput in = bo.getBindingInput();
            BindingOutput out = bo.getBindingOutput();
            BindingOperation newBo = def.createBindingOperation();
            Operation newOp = def.createOperation();
            BindingInput newIn = def.createBindingInput();
            BindingOutput newOut = def.createBindingOutput();
            newBo.setName(bo.getName());
            newOp.setName(op.getName());
            newIn.setName(in.getName());
            if (out != null) {
                newOut.setName(out.getName());
                newBo.setBindingOutput(newOut);
            }
            newBo.setOperation(newOp);
            newBo.setBindingInput(newIn);
            for (Object obj : bo.getBindingFaults().values()) {
                BindingFault fault = (BindingFault)obj;
                BindingFault newFault = def.createBindingFault();
                newFault.setName(fault.getName());
                newBo.addBindingFault(newFault);
            }
            binding.addBindingOperation(newBo);
        }
        def.removeBinding(oldBindingName);
        Jbi4CorbaBinding corbaBinding = new Jbi4CorbaBinding();
        corbaBinding.setElementType(Jbi4CorbaExtension.Q_ELEM_JBI4CORBA_BINDING);
        corbaBinding.setIdl(WSDLGenerator.readFileAsString(idlFile));
        binding.addExtensibilityElement((ExtensibilityElement)corbaBinding);
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createWSDLfromIDLFile(File idl, WSDLDescriptor desc) throws IOException, ClassGenerationException {
        JbiServiceDescriptor jbiDesc = new JbiServiceDescriptor();
        CodeGenerationProperties codeGenProp = new CodeGenerationProperties();
        codeGenProp.setValueTypeImplementationWithToStringAndEquals(false);
        ProviderServiceClassesGenerator generator = new ProviderServiceClassesGenerator(codeGenProp);
        File tempDir = WSDLGenerator.createTempDir();
        if (tempDir == null) {
            return null;
        }
        jbiDesc.setIdlFileNameDirectory(idl.getParentFile().getAbsolutePath());
        jbiDesc.setIdlFileName(idl.getName());
        try {
            String xFirewsdl;
            List<ClientCorbaClassesHolder> classes = generator.generateProviderServiceClasses(jbiDesc, tempDir.getAbsolutePath(), (String)null);
            ClientCorbaClassesHolder corbaClasses = classes.get(0);
            ProviderServiceDescriptor serviceDesc = new ProviderServiceDescriptor();
            QName interfaceName = new QName(desc.getNamespace(), desc.getEndpointName());
            serviceDesc.setServiceInterface(corbaClasses.getOperationsClass());
            serviceDesc.setCorbaHelperClass(corbaClasses.getHelperClass());
            serviceDesc.setServiceName(desc.getCorbaServiceName());
            serviceDesc.setServiceNameSpace(desc.getNamespace());
            Service service = new ProviderServiceCreator().createJbiService(serviceDesc, WSDLGenerator.createXFire(), interfaceName);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            service.getWSDLWriter().write((OutputStream)outputStream);
            String string = xFirewsdl = outputStream.toString();
            return string;
        }
        finally {
            WSDLGenerator.deleteDirectory(tempDir);
        }
    }

    private static XFire createXFire() {
        DefaultXFire xfire = new DefaultXFire();
        TransportManager manager = xfire.getTransportManager();
        for (Object obj : manager.getTransports().toArray()) {
            manager.unregister((Transport)obj);
        }
        manager.register((Transport)new JbiTransport(null));
        return xfire;
    }

    private static File createTempDir() throws IOException {
        File f = File.createTempFile("IDL2WSDLWIZARD_", null);
        if (!f.delete()) {
            return null;
        }
        if (!f.mkdir()) {
            return null;
        }
        return f;
    }

    private static void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    WSDLGenerator.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
        directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(File f) throws IOException {
        BufferedReader file = null;
        try {
            StringBuilder buf = new StringBuilder();
            file = new BufferedReader(new FileReader(f));
            buf.append(LINE_SEPARATOR);
            String s = file.readLine();
            while (s != null) {
                buf.append(s).append(LINE_SEPARATOR);
                s = file.readLine();
            }
            String string = buf.toString();
            return string;
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    private Document parseWsdlDocument(String wsdlDoc) throws WSDLGenerationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document wrappedDoc = null;
        try {
            factory.setNamespaceAware(true);
            DocumentBuilder mBuilder = factory.newDocumentBuilder();
            wrappedDoc = mBuilder.parse(new InputSource(new StringReader(wsdlDoc)));
        }
        catch (ParserConfigurationException ex) {
            Object[] args = new Object[]{ex.getMessage()};
            LOG.error("CRB000554_Error_during_wsdl_parsing", args, ex);
            throw new WSDLGenerationException("CRB000554_Error_during_wsdl_parsing", args, ex);
        }
        catch (SAXException ex) {
            Object[] args = new Object[]{ex.getMessage()};
            LOG.error("CRB000554_Error_during_wsdl_parsing", args, ex);
            throw new WSDLGenerationException("CRB000554_Error_during_wsdl_parsing", args, ex);
        }
        catch (IOException ex) {
            Object[] args = new Object[]{ex.getMessage()};
            LOG.error("CRB000554_Error_during_wsdl_parsing", args, ex);
            throw new WSDLGenerationException("CRB000554_Error_during_wsdl_parsing", args, ex);
        }
        LOG.debug("wrappedDoc.class" + wrappedDoc.getClass());
        return wrappedDoc;
    }
}

