/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ClassGenerationException;
import it.imolinfo.jbi4corba.webservice.generator.MethodSignature;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilJavaSourceParsing {
    private static final Logger LOG = LoggerFactory.getLogger(UtilJavaSourceParsing.class);

    public List<MethodSignature> extractMethodSignature(String absPath) throws ClassGenerationException {
        List<String> listOfLines = null;
        try {
            listOfLines = this.readFile(absPath);
        }
        catch (FileNotFoundException e) {
            Object[] args = new Object[]{absPath};
            LOG.error("CRB000543_ExtractMethodSignatureError_FileNotFound", args, e);
            throw new ClassGenerationException("CRB000543_ExtractMethodSignatureError_FileNotFound", args, e);
        }
        catch (IOException e) {
            Object[] args = new Object[]{absPath};
            LOG.error("CRB000544_ExtractMethodSignatureError_IOException", args, e);
            throw new ClassGenerationException("CRB000544_ExtractMethodSignatureError_IOException", args, e);
        }
        LOG.debug("Reading file ... done");
        String[] lines = listOfLines.toArray(new String[listOfLines.size()]);
        FileContents fc = new FileContents(absPath, lines);
        DetailAST aRoot = null;
        try {
            aRoot = TreeWalker.parse((FileContents)fc);
        }
        catch (RecognitionException e) {
            Object[] args = new Object[]{absPath};
            LOG.error("CRB000545_ExtractMethodSignatureError_RecognitionException", args, e);
            throw new ClassGenerationException("CRB000545_ExtractMethodSignatureError_RecognitionException", args, e);
        }
        catch (TokenStreamException e) {
            Object[] args = new Object[]{absPath};
            LOG.error("CRB000546_ExtractMethodSignatureError_TokenStreamException", args, e);
            throw new ClassGenerationException("CRB000546_ExtractMethodSignatureError_TokenStreamException", args, e);
        }
        LOG.debug("Parsing file ... done");
        List<DetailAST> nodeList = this.getTreeAsListOfNode(aRoot);
        List<MethodSignature> methodSignatureList = this.extractMethodSignature(nodeList);
        LOG.debug("Extractiong method's signature ... done");
        return methodSignatureList;
    }

    private List<MethodSignature> extractMethodSignature(List<DetailAST> nodeList) {
        ArrayList<MethodSignature> methodSignatureList = new ArrayList<MethodSignature>();
        if (nodeList == null) {
            LOG.debug("The list of node is null. nothing to do.");
            return methodSignatureList;
        }
        for (DetailAST currentNode : nodeList) {
            if (currentNode != null && currentNode.getType() == 9) {
                String methodName = currentNode.getFirstChild().getNextSibling().getNextSibling().getText();
                String returnType = currentNode.getFirstChild().getNextSibling().getFirstChild().getText();
                MethodSignature methodSignature = new MethodSignature();
                methodSignature.setMethodName(methodName);
                methodSignature.setReturnType(returnType);
                methodSignatureList.add(methodSignature);
                LOG.debug("methodSignatureList.add:" + methodSignature);
            }
            if (currentNode == null || currentNode.getType() != 21) continue;
            MethodSignature methodSignature = (MethodSignature)methodSignatureList.get(methodSignatureList.size() - 1);
            String pName = currentNode.getFirstChild().getNextSibling().getNextSibling().getText();
            String pType = currentNode.getFirstChild().getNextSibling().getFirstChild().getText();
            methodSignature.getParamentersName().add(pName);
            methodSignature.getParametersType().add(pType);
            LOG.debug("methodSignature - update Parameter definition:" + methodSignature);
        }
        return methodSignatureList;
    }

    private List<DetailAST> getTreeAsListOfNode(DetailAST aRoot) {
        ArrayList<DetailAST> nodeList = new ArrayList<DetailAST>();
        DetailAST curNode = aRoot;
        while (curNode != null) {
            DetailAST toVisit = (DetailAST)curNode.getFirstChild();
            nodeList.add(toVisit);
            while (curNode != null && toVisit == null) {
                toVisit = (DetailAST)curNode.getNextSibling();
                if (toVisit == null) {
                    curNode = curNode.getParent();
                    continue;
                }
                nodeList.add(toVisit);
            }
            curNode = toVisit;
        }
        return nodeList;
    }

    private List<String> readFile(String filePath) throws IOException {
        ArrayList<String> listOfLines = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(filePath));
        String str = null;
        while ((str = in.readLine()) != null) {
            listOfLines.add(str);
        }
        in.close();
        return listOfLines;
    }

    private String tokenTypeToString(int tt) {
        switch (tt) {
            case 40: {
                return "ABSTRACT";
            }
            case 159: {
                return "ANNOTATION";
            }
            case 162: {
                return "ANNOTATION_ARRAY_INIT";
            }
            case 157: {
                return "ANNOTATION_DEF";
            }
            case 161: {
                return "ANNOTATION_FIELD_DEF";
            }
            case 160: {
                return "ANNOTATION_MEMBER_VALUE_PAIR";
            }
            case 158: {
                return "ANNOTATIONS";
            }
            case 17: {
                return "ARRAY_DECLARATOR";
            }
            case 29: {
                return "ARRAY_INIT";
            }
            case 80: {
                return "ASSIGN";
            }
            case 170: {
                return "AT";
            }
            case 114: {
                return "BAND";
            }
            case 106: {
                return "BAND_ASSIGN";
            }
            case 131: {
                return "BNOT";
            }
            case 112: {
                return "BOR";
            }
            case 108: {
                return "BOR_ASSIGN";
            }
            case 124: {
                return "BSR";
            }
            case 104: {
                return "BSR_ASSIGN";
            }
            case 113: {
                return "BXOR";
            }
            case 107: {
                return "BXOR_ASSIGN";
            }
            case 33: {
                return "CASE_GROUP";
            }
            case 138: {
                return "CHAR_LITERAL";
            }
            case 14: {
                return "CLASS_DEF";
            }
            case 82: {
                return "COLON";
            }
            case 74: {
                return "COMMA";
            }
            case 43: {
                return "CTOR_CALL";
            }
            case 8: {
                return "CTOR_DEF";
            }
            case 130: {
                return "DEC";
            }
            case 127: {
                return "DIV";
            }
            case 101: {
                return "DIV_ASSIGN";
            }
            case 175: {
                return "DO_WHILE";
            }
            case 59: {
                return "DOT";
            }
            case 34: {
                return "ELIST";
            }
            case 171: {
                return "ELLIPSIS";
            }
            case 38: {
                return "EMPTY_STAT";
            }
            case 153: {
                return "ENUM";
            }
            case 155: {
                return "ENUM_CONSTANT_DEF";
            }
            case 154: {
                return "ENUM_DEF";
            }
            case 1: {
                return "EOF";
            }
            case 116: {
                return "EQUAL";
            }
            case 28: {
                return "EXPR";
            }
            case 18: {
                return "EXTENDS_CLAUSE";
            }
            case 39: {
                return "FINAL";
            }
            case 36: {
                return "FOR_CONDITION";
            }
            case 156: {
                return "FOR_EACH_CLAUSE";
            }
            case 35: {
                return "FOR_INIT";
            }
            case 37: {
                return "FOR_ITERATOR";
            }
            case 120: {
                return "GE";
            }
            case 173: {
                return "GENERIC_END";
            }
            case 172: {
                return "GENERIC_START";
            }
            case 118: {
                return "GT";
            }
            case 58: {
                return "IDENT";
            }
            case 19: {
                return "IMPLEMENTS_CLAUSE";
            }
            case 30: {
                return "IMPORT";
            }
            case 129: {
                return "INC";
            }
            case 24: {
                return "INDEX_OP";
            }
            case 11: {
                return "INSTANCE_INIT";
            }
            case 15: {
                return "INTERFACE_DEF";
            }
            case 22: {
                return "LABELED_STAT";
            }
            case 111: {
                return "LAND";
            }
            case 72: {
                return "LCURLY";
            }
            case 119: {
                return "LE";
            }
            case 132: {
                return "LNOT";
            }
            case 76: {
                return "LPAREN";
            }
            case 117: {
                return "LT";
            }
            case 27: {
                return "METHOD_CALL";
            }
            case 9: {
                return "METHOD_DEF";
            }
            case 126: {
                return "MINUS";
            }
            case 99: {
                return "MINUS_ASSIGN";
            }
            case 128: {
                return "MOD";
            }
            case 102: {
                return "MOD_ASSIGN";
            }
            case 5: {
                return "MODIFIERS";
            }
            case 115: {
                return "NOT_EQUAL";
            }
            case 142: {
                return "NUM_DOUBLE";
            }
            case 140: {
                return "NUM_FLOAT";
            }
            case 137: {
                return "NUM_INT";
            }
            case 141: {
                return "NUM_LONG";
            }
            case 6: {
                return "OBJBLOCK";
            }
            case 16: {
                return "PACKAGE_DEF";
            }
            case 21: {
                return "PARAMETER_DEF";
            }
            case 20: {
                return "PARAMETERS";
            }
            case 125: {
                return "PLUS";
            }
            case 98: {
                return "PLUS_ASSIGN";
            }
            case 26: {
                return "POST_DEC";
            }
            case 25: {
                return "POST_INC";
            }
            case 109: {
                return "QUESTION";
            }
            case 48: {
                return "RBRACK";
            }
            case 73: {
                return "RCURLY";
            }
            case 77: {
                return "RPAREN";
            }
            case 45: {
                return "SEMI";
            }
            case 122: {
                return "SL";
            }
            case 105: {
                return "SL_ASSIGN";
            }
            case 7: {
                return "SLIST";
            }
            case 123: {
                return "SR";
            }
            case 103: {
                return "SR_ASSIGN";
            }
            case 60: {
                return "STAR";
            }
            case 100: {
                return "STAR_ASSIGN";
            }
            case 152: {
                return "STATIC_IMPORT";
            }
            case 12: {
                return "STATIC_INIT";
            }
            case 41: {
                return "STRICTFP";
            }
            case 139: {
                return "STRING_LITERAL";
            }
            case 42: {
                return "SUPER_CTOR_CALL";
            }
            case 13: {
                return "TYPE";
            }
            case 164: {
                return "TYPE_ARGUMENT";
            }
            case 163: {
                return "TYPE_ARGUMENTS";
            }
            case 174: {
                return "TYPE_EXTENSION_AND";
            }
            case 169: {
                return "TYPE_LOWER_BOUNDS";
            }
            case 166: {
                return "TYPE_PARAMETER";
            }
            case 165: {
                return "TYPE_PARAMETERS";
            }
            case 168: {
                return "TYPE_UPPER_BOUNDS";
            }
            case 23: {
                return "TYPECAST";
            }
            case 31: {
                return "UNARY_MINUS";
            }
            case 32: {
                return "UNARY_PLUS";
            }
            case 10: {
                return "VARIABLE_DEF";
            }
            case 167: {
                return "SEMI";
            }
        }
        return "TokenTypeUnknown";
    }
}

