/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.processor;

import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperBuilder;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.jbi.endpoint.Jbi4CorbaEndpoint;
import it.imolinfo.jbi4corba.jbi.processor.MessageDenormalizer;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageNormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDenormalizer.class);
    private Transformer mTrans = null;
    private WrapperBuilder wrapperBuilder = null;

    public MessageNormalizer() throws Jbi4CorbaException {
        try {
            this.wrapperBuilder = HelperFactory.createBuilder();
        }
        catch (WrapperProcessingException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(ex);
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            this.mTrans = factory.newTransformer();
        }
        catch (TransformerFactoryConfigurationError ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(ex);
        }
        catch (TransformerConfigurationException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(e);
        }
    }

    public void normalize(Source xmlSource, NormalizedMessage normalizedMsg, Jbi4CorbaEndpoint endpoint, QName operation, boolean toWrap, boolean isOutput) throws Jbi4CorbaException {
        try {
            String msg;
            Service service = endpoint.getDefinition().getService(endpoint.getServiceName());
            Port port = service.getPort(QName.valueOf(endpoint.getEndpointName()).getLocalPart());
            PortType portType = port.getBinding().getPortType();
            Iterator it = portType.getOperations().iterator();
            Message wsdlMessage = null;
            while (it.hasNext()) {
                Operation op = (Operation)it.next();
                if (!op.getName().equals(operation.toString()) && !op.getName().equals(operation.getLocalPart())) continue;
                if (isOutput) {
                    wsdlMessage = op.getOutput().getMessage();
                    continue;
                }
                wsdlMessage = op.getInput().getMessage();
            }
            this.wrapperBuilder.initialize(null, wsdlMessage, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WSDL Message: " + wsdlMessage);
                LOG.debug("WSDL Message Parts: " + wsdlMessage.getParts());
            }
            if (wsdlMessage.getParts().values().size() == 0) {
                msg = "No message parts found!";
                LOG.error(msg);
                throw new Jbi4CorbaException(msg);
            }
            if (wsdlMessage.getParts().values().size() > 1) {
                msg = "More than one message part found: using the first";
                LOG.warn(msg);
            }
            Part part = (Part)wsdlMessage.getParts().values().iterator().next();
            String partName = part.getName();
            Node node = null;
            if (xmlSource instanceof DOMSource) {
                node = ((DOMSource)xmlSource).getNode();
            } else {
                DOMResult domResult = new DOMResult();
                this.mTrans.transform(xmlSource, domResult);
                node = domResult.getNode();
            }
            DOMSource domSource = null;
            if (!toWrap) {
                domSource = new DOMSource(node);
            } else {
                if (node instanceof Document) {
                    this.wrapperBuilder.addPart(partName, ((Document)node).getDocumentElement());
                } else if (node instanceof Element) {
                    this.wrapperBuilder.addPart(partName, (Element)node);
                } else {
                    String msg2 = "Invalid result from XML transformation: " + node.getClass();
                    LOG.error(msg2);
                    throw new Jbi4CorbaException(msg2);
                }
                Document doc = this.wrapperBuilder.getResult();
                domSource = new DOMSource(doc);
            }
            normalizedMsg.setContent((Source)domSource);
        }
        catch (WrapperProcessingException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(msg);
        }
        catch (TransformerException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(msg);
        }
        catch (MessagingException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(msg);
        }
    }

    public Source normalize(Source xmlSource, Jbi4CorbaEndpoint endpoint, QName operation, boolean toWrap, boolean isOutput) throws Jbi4CorbaException {
        try {
            String msg;
            Service service = endpoint.getDefinition().getService(endpoint.getServiceName());
            Port port = service.getPort(QName.valueOf(endpoint.getEndpointName()).getLocalPart());
            PortType portType = port.getBinding().getPortType();
            Iterator it = portType.getOperations().iterator();
            Message wsdlMessage = null;
            while (it.hasNext()) {
                Operation op = (Operation)it.next();
                if (!op.getName().equals(operation.toString()) && !op.getName().equals(operation.getLocalPart())) continue;
                if (isOutput) {
                    wsdlMessage = op.getOutput().getMessage();
                    continue;
                }
                wsdlMessage = op.getInput().getMessage();
            }
            this.wrapperBuilder.initialize(null, wsdlMessage, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WSDL Message: " + wsdlMessage);
                LOG.debug("WSDL Message Parts: " + wsdlMessage.getParts());
            }
            if (wsdlMessage.getParts().values().size() == 0) {
                msg = "No message parts found!";
                LOG.error(msg);
                throw new Jbi4CorbaException(msg);
            }
            if (wsdlMessage.getParts().values().size() > 1) {
                msg = "More than one message part found: using the first";
                LOG.warn(msg);
            }
            Part part = (Part)wsdlMessage.getParts().values().iterator().next();
            String partName = part.getName();
            Node node = null;
            if (xmlSource instanceof DOMSource) {
                node = ((DOMSource)xmlSource).getNode();
            } else {
                DOMResult domResult = new DOMResult();
                this.mTrans.transform(xmlSource, domResult);
                node = domResult.getNode();
            }
            DOMSource domSource = null;
            if (!toWrap) {
                domSource = new DOMSource(node);
            } else {
                if (node instanceof Document) {
                    this.wrapperBuilder.addPart(partName, ((Document)node).getDocumentElement());
                } else if (node instanceof Element) {
                    this.wrapperBuilder.addPart(partName, (Element)node);
                } else {
                    String msg2 = "Invalid result from XML transformation: " + node.getClass();
                    LOG.error(msg2);
                    throw new Jbi4CorbaException(msg2);
                }
                Document doc = this.wrapperBuilder.getResult();
                domSource = new DOMSource(doc);
            }
            return domSource;
        }
        catch (WrapperProcessingException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(msg);
        }
        catch (TransformerException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(msg);
        }
    }

    public void normalizeFault(Source xmlSource, Fault fault, Jbi4CorbaEndpoint endpoint, QName operation, String faultName, boolean toWrap) throws Jbi4CorbaException {
        try {
            String msg;
            Service service = endpoint.getDefinition().getService(endpoint.getServiceName());
            Port port = service.getPort(QName.valueOf(endpoint.getEndpointName()).getLocalPart());
            PortType portType = port.getBinding().getPortType();
            Iterator it = portType.getOperations().iterator();
            Message wsdlFault = null;
            while (it.hasNext()) {
                Operation op = (Operation)it.next();
                LOG.debug("Looking for operation: " + op.getName());
                if (!op.getName().equals(operation.toString()) && !op.getName().equals(operation.getLocalPart())) continue;
                Map faults = op.getFaults();
                for (javax.wsdl.Fault wsdlFaultTmp : faults.values()) {
                    LOG.debug("Looking for fault: " + faultName + ", found fault: " + wsdlFaultTmp.getName());
                    if (!wsdlFaultTmp.getName().equals(faultName)) continue;
                    wsdlFault = wsdlFaultTmp.getMessage();
                }
            }
            this.wrapperBuilder.initialize(null, wsdlFault, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WSDL Fault: " + wsdlFault);
                LOG.debug("WSDL Fault Parts: " + wsdlFault.getParts());
            }
            if (wsdlFault.getParts().values().size() == 0) {
                msg = "No message parts found!";
                LOG.error(msg);
                throw new Jbi4CorbaException(msg);
            }
            if (wsdlFault.getParts().values().size() > 1) {
                msg = "More than one message part found: using the first";
                LOG.warn(msg);
            }
            Part part = (Part)wsdlFault.getParts().values().iterator().next();
            String partName = part.getName();
            Node node = null;
            if (xmlSource instanceof DOMSource) {
                node = ((DOMSource)xmlSource).getNode();
            } else {
                DOMResult domResult = new DOMResult();
                this.mTrans.transform(xmlSource, domResult);
                node = domResult.getNode();
            }
            DOMSource domSource = null;
            if (!toWrap) {
                domSource = new DOMSource(node);
            } else {
                if (node instanceof Document) {
                    this.wrapperBuilder.addPart(partName, ((Document)node).getDocumentElement());
                } else if (node instanceof Element) {
                    this.wrapperBuilder.addPart(partName, (Element)node);
                } else {
                    String msg2 = "Invalid result from XML transformation: " + node.getClass();
                    LOG.error(msg2);
                    throw new Jbi4CorbaException(msg2);
                }
                Document doc = this.wrapperBuilder.getResult();
                domSource = new DOMSource(doc);
            }
            fault.setContent((Source)domSource);
        }
        catch (WrapperProcessingException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(msg);
        }
        catch (TransformerException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(msg);
        }
        catch (MessagingException ex) {
            String msg = ex.getMessage();
            LOG.error(msg);
            throw new Jbi4CorbaException(msg);
        }
    }
}

