/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.netbeans.microedition.lcdui.TableModel;
import org.netbeans.microedition.lcdui.TableModelListener;
import org.netbeans.microedition.lcdui.laf.ColorSchema;
import org.netbeans.microedition.lcdui.laf.SystemColorSchema;

public class TableItem
extends CustomItem
implements TableModelListener {
    private static final boolean DEBUG = false;
    private int tableRows = 0;
    private int tableCols = 0;
    private String title = null;
    private boolean borders = true;
    private boolean usingHeaders = false;
    private final Display display;
    private static final Font STATIC_TEXT_FONT = Font.getFont((int)0);
    private static final Font DEFAULT_TITLE_FONT = Font.getFont((int)STATIC_TEXT_FONT.getFace(), (int)(STATIC_TEXT_FONT.getStyle() | 1), (int)STATIC_TEXT_FONT.getSize());
    private static final Font DEFAULT_HEADERS_FONT = Font.getFont((int)STATIC_TEXT_FONT.getFace(), (int)(STATIC_TEXT_FONT.getStyle() | 1), (int)STATIC_TEXT_FONT.getSize());
    private static final Font DEFAULT_VALUES_FONT = STATIC_TEXT_FONT;
    private Font titleFont = DEFAULT_TITLE_FONT;
    private Font headersFont = DEFAULT_HEADERS_FONT;
    private Font valuesFont = DEFAULT_VALUES_FONT;
    private TableModel model;
    private int[] colWidths;
    private int[] rowHeights;
    private int totalColWidth;
    private int defaultCellWidth;
    private int defaultCellHeight;
    private static final int CELL_PADDING = 2;
    private static final int DOUBLE_CELL_PADDING = 4;
    private static final int BORDER_LINE_WIDTH = 1;
    private boolean cursorOn = false;
    private int cursorCellX;
    private int cursorCellY;
    private int viewCellX = 0;
    private int viewCellX2 = 0;
    private boolean tableFitsHorizontally = true;
    private boolean firstPaint = true;
    private int sizeWidth = 0;
    private int sizeHeight = 0;
    private ColorSchema colorSchema;

    public TableItem(Display display, String label) throws IllegalArgumentException {
        this(display, label, null);
    }

    public TableItem(Display display, String label, TableModel model) throws IllegalArgumentException {
        this(display, label, model, null);
    }

    public TableItem(Display display, String label, TableModel model, ColorSchema colorSchema) throws IllegalArgumentException {
        super(label);
        if (display == null) {
            throw new IllegalArgumentException("display parameter cannot be null");
        }
        this.display = display;
        this.updateDefaultCellSize();
        if (model != null) {
            this.setModel(model);
        } else {
            this.recomputeModelValues();
        }
        this.setColorSchemaImpl(display, colorSchema);
    }

    public void setColorSchema(ColorSchema colorSchema) {
        this.setColorSchemaImpl(this.display, colorSchema);
        this.repaint();
    }

    public ColorSchema getColorSchema() {
        return this.colorSchema;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String tableTitle) {
        if (this.title != tableTitle) {
            this.title = tableTitle;
            this.repaint();
        }
    }

    public boolean isBorders() {
        return this.borders;
    }

    public void setBorders(boolean showBorders) {
        if (this.borders != showBorders) {
            this.borders = showBorders;
            this.repaint();
        }
    }

    public void setModel(TableModel model) throws IllegalArgumentException {
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        if (model == null) {
            throw new IllegalArgumentException("model parameter cannot be null");
        }
        if (model != null) {
            if (model.getRowCount() < 0) {
                throw new IllegalArgumentException("model cannot have negative number of rows");
            }
            if (model.getColumnCount() < 0) {
                throw new IllegalArgumentException("model cannot have negative number of cols");
            }
            model.addTableModelListener(this);
        }
        this.model = model;
        this.recomputeModelValues();
        this.invalidateTable();
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        if (this.titleFont != titleFont) {
            this.titleFont = titleFont != null ? titleFont : DEFAULT_TITLE_FONT;
            this.repaint();
        }
    }

    public Font getValuesFont() {
        return this.valuesFont;
    }

    public void setValuesFont(Font valuesFont) {
        if (this.valuesFont != valuesFont) {
            this.valuesFont = valuesFont != null ? valuesFont : DEFAULT_VALUES_FONT;
            this.updateDefaultCellSize();
            this.recomputeModelValues();
            this.repaint();
        }
    }

    public Font getHeadersFont() {
        return this.headersFont;
    }

    public void setHeadersFont(Font headersFont) {
        if (this.headersFont != headersFont) {
            this.headersFont = headersFont != null ? headersFont : DEFAULT_HEADERS_FONT;
            this.repaint();
        }
    }

    public int getSelectedCellRow() {
        return this.cursorCellY;
    }

    public int getSelectedCellColumn() {
        return this.cursorCellX;
    }

    protected int getMinContentHeight() {
        int sum = this.tableRows * (this.defaultCellHeight + 1) + 1;
        if (this.title != null) {
            sum += this.getTitleFont().getHeight() + 4 + 1;
        }
        if (this.usingHeaders) {
            sum += this.getHeadersFont().getHeight() + 4 + 1;
        }
        return sum;
    }

    protected int getMinContentWidth() {
        return -1;
    }

    protected int getPrefContentHeight(int width) {
        return this.getMinContentHeight();
    }

    protected int getPrefContentWidth(int height) {
        int titleWidth;
        Displayable currentDisplayable = this.display.getCurrent();
        int displayWidth = currentDisplayable == null ? -1 : currentDisplayable.getWidth();
        int sum = this.colWidths.length * 1 + 1;
        int result = 0;
        for (int i = 0; i < this.colWidths.length; ++i) {
            sum += this.colWidths[i];
        }
        result = sum;
        if (this.title != null && (titleWidth = this.getTitleFont().stringWidth(this.title)) > result) {
            result = titleWidth + 4;
        }
        if (displayWidth > 0 && result > displayWidth) {
            result = displayWidth;
        }
        return result;
    }

    protected void paint(Graphics g, int width, int height) {
        this.firstPaint = false;
        int paintWidth = this.sizeWidth > 0 ? this.sizeWidth : width;
        int paintHeight = this.sizeHeight > 0 ? this.sizeHeight : height;
        this.tableFitsHorizontally = this.totalColWidth <= paintWidth;
        boolean rightmostColumnFullyVisible = true;
        int currentColor = g.getColor();
        this.getColorSchema().paintBackground(g, false);
        int hy = paintHeight - 1;
        int wx = paintWidth - 1;
        int titleHeight = 0;
        if (this.title != null) {
            titleHeight = this.getTitleFont().getHeight() + 4;
        }
        int headersHeight = 0;
        if (this.usingHeaders) {
            headersHeight = this.getHeadersFont().getHeight() + 4;
        }
        int viewWidth = wx;
        int actualTableWidth = paintWidth;
        if (this.model != null && this.tableRows != 0 && this.tableCols != 0) {
            if (this.viewCellX2 < this.tableCols - 1) {
                viewWidth = wx;
            } else {
                viewWidth = 0;
                for (int i = this.viewCellX; i <= this.viewCellX2 && i < this.tableCols; ++i) {
                    viewWidth += this.colWidths[i];
                }
                if (viewWidth > wx) {
                    viewWidth = wx;
                }
            }
            if (this.cursorOn) {
                int x = this.getCursorX();
                int y = this.getCursorY() + 1;
                if (this.title != null) {
                    y += titleHeight + 1;
                }
                if (this.usingHeaders) {
                    y += headersHeight + 1;
                }
                int w = this.colWidths[this.cursorCellX];
                int h = this.defaultCellHeight;
                g.setColor(this.getColorSchema().getColor(2));
                g.fillRect(x, y, w, h);
            }
            int y = 0;
            if (this.title != null) {
                y += titleHeight + 1;
            }
            if (this.usingHeaders) {
                g.setColor(this.getColorSchema().getColor(1));
                g.setFont(this.getHeadersFont());
                int x = 1;
                int gy = y + 2 + 1;
                for (int j = this.viewCellX; j < this.model.getColumnCount(); ++j) {
                    this.viewCellX2 = j;
                    String value = this.model.getColumnName(j);
                    int colWidth = this.colWidths[j];
                    if (value != null) {
                        g.drawString(value.toString(), x + colWidth / 2, gy, 17);
                    }
                    if ((x += colWidth + 1) <= paintWidth) continue;
                    rightmostColumnFullyVisible = false;
                    break;
                }
                y += headersHeight + 1;
            }
            g.setColor(this.getColorSchema().getColor(1));
            g.setFont(this.getValuesFont());
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                int x = 3;
                int gy = y + 2 + 1;
                for (int j = this.viewCellX; j < this.model.getColumnCount(); ++j) {
                    this.viewCellX2 = j;
                    Object value = this.model.getValue(j, i);
                    if (value != null) {
                        if (this.cursorOn && j == this.cursorCellX && i == this.cursorCellY) {
                            g.setColor(this.getColorSchema().getColor(3));
                            g.drawString(value.toString(), x, gy, 20);
                            g.setColor(this.getColorSchema().getColor(1));
                        } else {
                            g.drawString(value.toString(), x, gy, 20);
                        }
                    }
                    if ((x += this.colWidths[j] + 1) <= width) continue;
                    rightmostColumnFullyVisible = false;
                    break;
                }
                y += this.defaultCellHeight + 1;
            }
            if (this.isBorders()) {
                int i;
                g.setColor(this.getColorSchema().getColor(4));
                int currentStrokeStyle = g.getStrokeStyle();
                g.setStrokeStyle(this.display.getBorderStyle(false));
                y = titleHeight;
                int totalTableHeight = this.tableRows * (this.defaultCellHeight + 1) + titleHeight;
                if (this.usingHeaders) {
                    totalTableHeight += headersHeight + 1;
                }
                int x = 0;
                for (i = this.viewCellX; i < this.tableCols && x < width; ++i) {
                    g.drawLine(x += this.colWidths[i] + 1, titleHeight, x, totalTableHeight);
                    actualTableWidth = x;
                }
                if (titleHeight > 0 && rightmostColumnFullyVisible) {
                    g.drawLine(x, 0, x, titleHeight);
                }
                g.drawLine(0, 0, actualTableWidth, 0);
                if (this.usingHeaders) {
                    g.drawLine(0, y, actualTableWidth, y);
                    y += headersHeight + 1;
                }
                for (i = 0; i <= this.tableRows && y <= totalTableHeight; ++i, y += this.defaultCellHeight + 1) {
                    g.drawLine(0, y, actualTableWidth, y);
                }
                g.drawLine(0, 0, 0, totalTableHeight);
                g.setStrokeStyle(currentStrokeStyle);
            }
        }
        if (this.title != null) {
            g.setColor(this.getColorSchema().getColor(1));
            g.setFont(this.titleFont);
            g.drawString(this.title, actualTableWidth / 2, 3, 17);
            int half = titleHeight / 2;
            if (this.viewCellX > 0) {
                g.drawLine(2, half, 5, half - 2);
                g.drawLine(2, half, 5, half + 2);
            }
            if (!rightmostColumnFullyVisible) {
                int rx = actualTableWidth - 2;
                g.drawLine(rx, half, rx - 3, half - 2);
                g.drawLine(rx, half, rx - 3, half + 2);
            }
        }
        g.setColor(currentColor);
    }

    protected void sizeChanged(int w, int h) {
        if (!this.firstPaint && w > 0 && h > 0 && w != this.sizeWidth && h != this.sizeHeight) {
            this.sizeWidth = w;
            this.sizeHeight = h;
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        int visibleWidth = visRect_inout[2];
        int visibleHeight = visRect_inout[3];
        if (this.model == null) {
            return false;
        }
        boolean retValue = false;
        boolean repaint = false;
        if (!this.cursorOn) {
            if (dir == 1) {
                this.cursorCellY = this.tableRows - 1;
            } else if (dir == 6) {
                this.cursorCellY = 0;
            } else if (dir == 5) {
                this.cursorCellY = 0;
                this.cursorCellX = 0;
            } else if (dir == 2) {
                this.cursorCellY = this.tableRows - 1;
                this.viewCellX2 = this.cursorCellX = this.tableCols - 1;
            }
            this.cursorOn = true;
            retValue = true;
            repaint = true;
        } else {
            if (dir == 1) {
                --this.cursorCellY;
            } else if (dir == 6) {
                ++this.cursorCellY;
            } else if (dir == 2) {
                --this.cursorCellX;
            } else if (dir == 5) {
                ++this.cursorCellX;
            }
            if (this.cursorCellX < 0) {
                this.cursorCellX = 0;
                retValue = true;
                repaint = false;
            } else if (this.cursorCellX >= this.tableCols) {
                this.cursorCellX = this.tableCols - 1;
                retValue = true;
                repaint = false;
            }
            if (this.cursorCellY >= 0 && this.cursorCellY < this.tableRows) {
                retValue = true;
                repaint = true;
            } else {
                retValue = false;
                repaint = false;
                this.cursorCellY = this.cursorCellY < 0 ? 0 : this.tableRows - 1;
            }
        }
        int cursorY = this.getCursorY();
        int cursorHeight = this.defaultCellHeight;
        int headersHeight = 0;
        if (this.title != null) {
            headersHeight += this.getTitleFont().getHeight() + 4 + 1;
        }
        if (this.usingHeaders) {
            headersHeight += this.getHeadersFont().getHeight() + 4 + 1;
        }
        visRect_inout[1] = cursorY + headersHeight + 2;
        visRect_inout[3] = this.defaultCellHeight;
        visRect_inout[0] = this.getCursorX();
        visRect_inout[2] = this.defaultCellWidth;
        if (!this.tableFitsHorizontally) {
            repaint = true;
            if (this.cursorCellX >= this.viewCellX2) {
                int i;
                int sum = 3;
                for (i = this.viewCellX2; sum <= visibleWidth && i >= 0; sum += this.colWidths[i] + 1, --i) {
                }
                this.viewCellX = i + 2;
                if (this.viewCellX > this.viewCellX2) {
                    this.viewCellX = this.cursorCellX;
                }
            } else if (this.cursorCellX < this.viewCellX) {
                --this.viewCellX;
            }
        }
        if (repaint) {
            this.repaint();
        }
        return retValue;
    }

    protected void traverseOut() {
        super.traverseOut();
        this.cursorOn = false;
        this.repaint();
    }

    private int getCursorX() {
        int x = 1;
        for (int i = this.viewCellX; i < this.cursorCellX; ++i) {
            x += this.colWidths[i] + 1;
        }
        return x;
    }

    private int getCursorY() {
        return this.cursorCellY * (this.defaultCellHeight + 1);
    }

    private void recomputeModelValues() {
        int i;
        if (this.model != null) {
            this.tableRows = this.model.getRowCount();
            this.tableCols = this.model.getColumnCount();
        } else {
            this.tableCols = 0;
            this.tableRows = 0;
            this.usingHeaders = false;
        }
        this.colWidths = new int[this.tableCols];
        for (i = 0; i < this.tableCols; ++i) {
            this.colWidths[i] = this.defaultCellWidth;
        }
        if (this.model != null) {
            int i2;
            int columnCount = this.model.getColumnCount();
            int rowCount = this.model.getRowCount();
            for (i2 = 0; i2 < columnCount; ++i2) {
                for (int j = 0; j < rowCount; ++j) {
                    int width;
                    Object value = this.model.getValue(i2, j);
                    if (value == null || (width = this.getValuesFont().stringWidth(value.toString()) + 4) <= this.colWidths[i2]) continue;
                    this.colWidths[i2] = width;
                }
            }
            this.usingHeaders = this.model.isUsingHeaders();
            if (this.model.isUsingHeaders()) {
                for (i2 = 0; i2 < columnCount; ++i2) {
                    int width;
                    String columnName = this.model.getColumnName(i2);
                    if (columnName == null || (width = this.getHeadersFont().stringWidth(columnName.toString()) + 4) <= this.colWidths[i2]) continue;
                    this.colWidths[i2] = width;
                }
            }
        }
        this.totalColWidth = 1;
        for (i = 0; i < this.colWidths.length; ++i) {
            this.totalColWidth += this.colWidths[i] + 1;
        }
    }

    private void updateDefaultCellSize() {
        this.defaultCellWidth = this.getValuesFont().stringWidth("X") + 4;
        this.defaultCellHeight = this.getValuesFont().getHeight() + 4;
    }

    private void setColorSchemaImpl(Display display, ColorSchema colorSchema) {
        this.colorSchema = colorSchema != null ? colorSchema : SystemColorSchema.getForDisplay(display);
    }

    private void invalidateTable() {
        if (this.sizeWidth > 0 && this.sizeHeight > 0) {
            this.invalidate();
        }
    }

    public void tableModelChanged(TableModel changedModel) {
        if (changedModel == this.model) {
            this.recomputeModelValues();
            this.invalidateTable();
        }
    }
}

