/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Animate;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import org.w3c.dom.DOMException;

public class AnimateTransform
extends Animate {
    public static final int TYPE_TRANSLATE = 2;
    public static final int TYPE_SCALE = 3;
    public static final int TYPE_ROTATE = 4;
    public static final int TYPE_SKEW_X = 5;
    public static final int TYPE_SKEW_Y = 6;

    public AnimateTransform(DocumentNode ownerDocument) {
        super(ownerDocument, "animateTransform");
        this.type = 2;
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new AnimateTransform(doc);
    }

    boolean supportsTrait(String traitName) {
        if ("type" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("type" == name) {
            switch (this.type) {
                case 2: {
                    return "translate";
                }
                case 3: {
                    return "scale";
                }
                case 4: {
                    return "rotate";
                }
                case 5: {
                    return "skewX";
                }
            }
            return "skewY";
        }
        return super.getTraitImpl(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("type" == name) {
            this.checkWriteLoading(name);
            if ("translate".equals(value)) {
                this.type = 2;
                return;
            } else if ("scale".equals(value)) {
                this.type = 3;
                return;
            } else if ("rotate".equals(value)) {
                this.type = 4;
                return;
            } else if ("skewX".equals(value)) {
                this.type = 5;
                return;
            } else {
                if (!"skewY".equals(value)) throw this.illegalTraitValue(name, value);
                this.type = 6;
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }
}

