/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.xml;

import java.io.InputStream;
import javanet.staxutils.ContentHandlerToXMLStreamWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.stax.ElementWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.xml.DocumentType;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.STAXUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceType
extends Type {
    public SourceType() {
        this.setTypeClass(Source.class);
        this.setWriteOuter(false);
    }

    public Object readObject(MessageReader mreader, MessageContext context) throws XFireFault {
        DocumentType dt = (DocumentType)this.getTypeMapping().getType(Document.class);
        return new DOMSource((Document)dt.readObject(mreader, context));
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        try {
            if (object == null) {
                return;
            }
            this.write((Source)object, ((ElementWriter)writer).getXMLStreamWriter());
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not write xml.", (Throwable)e, XFireFault.SENDER);
        }
    }

    protected void write(Source object, XMLStreamWriter writer) throws FactoryConfigurationError, XMLStreamException, XFireFault {
        if (object == null) {
            return;
        }
        if (object instanceof DOMSource) {
            DOMSource ds = (DOMSource)object;
            Element element = null;
            if (ds.getNode() instanceof Element) {
                element = (Element)ds.getNode();
            } else if (ds.getNode() instanceof Document) {
                element = ((Document)ds.getNode()).getDocumentElement();
            } else {
                throw new XFireFault("Node type " + ds.getNode().getClass() + " was not understood.", XFireFault.RECEIVER);
            }
            STAXUtils.writeElement((Element)element, (XMLStreamWriter)writer, (boolean)false);
        } else if (object instanceof SAXSource) {
            SAXSource source = (SAXSource)object;
            try {
                XMLReader xmlReader = source.getXMLReader();
                if (xmlReader == null) {
                    xmlReader = this.createXMLReader();
                }
                xmlReader.setContentHandler((ContentHandler)((Object)new FilteringContentHandlerToXMLStreamWriter(writer)));
                xmlReader.parse(source.getInputSource());
            }
            catch (Exception e) {
                throw new XFireFault("Could not send xml.", (Throwable)e, XFireFault.RECEIVER);
            }
        } else if (object instanceof StreamSource) {
            StreamSource ss = (StreamSource)object;
            XMLStreamReader reader = STAXUtils.createXMLStreamReader((InputStream)ss.getInputStream(), null, null);
            STAXUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
        }
    }

    protected XMLReader createXMLReader() throws SAXException {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (Exception e) {
            return XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
    }

    class FilteringContentHandlerToXMLStreamWriter
    extends ContentHandlerToXMLStreamWriter {
        public FilteringContentHandlerToXMLStreamWriter(XMLStreamWriter xmlStreamWriter) {
            super(xmlStreamWriter);
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }
    }
}

