/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.plugins;

import java.awt.Container;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JFileChooserOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.modules.visualweb.gravy.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsOperator
extends JDialogOperator {
    private static final String MAIN_MENU_ITEM_TOOLS = "Tools";
    private static final String MAIN_MENU_ITEM_TOOLS_PLUGINS = "Tools|Plugins";
    private static final String DIALOG_TITLE_PLUGINS = "Plugins";
    private static final String DIALOG_TITLE_NETBEANS_IDE_INSTALLER = "NetBeans IDE Installer";
    private static final String DIALOG_TITLE_VALIDATION_WARNING = "Validation Warning";
    private static final String TAB_TITLE_AVAILABLE_PLUGINS = "Available Plugins";
    private static final String TAB_TITLE_DOWNLOADED_PLUGINS = "Downloaded";
    private static final String COLUMN_TITLE_NAME = "Name";
    private static final String COLUMN_TITLE_INSTALL = "Install";
    private static final String RADIO_BUTTON_LICENSE_AGREEMENT_ACCEPT_TEXT = "I accept";
    private static final String BUTTON_LABEL_ADD_PLUGINS = "Add Plugins";
    private static final String BUTTON_LABEL_RELOAD_CATALOG = "Reload Catalog";
    private static final String BUTTON_LABEL_INSTALL = "Install";
    private static final String BUTTON_LABEL_NEXT = "Next";
    private static final String BUTTON_LABEL_CONTINUE = "Continue";
    private static final String BUTTON_LABEL_FINISH = "Finish";
    private static final String BUTTON_LABEL_CLOSE = "Close";
    private JTabbedPaneOperator tabbedPane;
    private JButtonOperator btnClose;

    public static PluginsOperator getInstance() {
        PluginsOperator.display();
        return new PluginsOperator();
    }

    private PluginsOperator() {
        super(DIALOG_TITLE_PLUGINS);
        this.verify();
    }

    public void installAvailablePlugins() {
        this.installAvailablePlugins(Collections.EMPTY_LIST);
    }

    public void installAvailablePlugins(String pluginName) {
        this.installAvailablePlugins(new String[]{pluginName});
    }

    public void installAvailablePlugins(String[] pluginNames) {
        this.installAvailablePlugins(Arrays.asList(pluginNames));
    }

    public void installAvailablePlugins(List<String> pluginNames) {
        ContainerOperator containerOp = this.waitTabEnabled(TAB_TITLE_AVAILABLE_PLUGINS);
        JTableOperator pluginTable = new JTableOperator(containerOp);
        this.fillAvailablePluginsTable(containerOp, pluginTable);
        this.selectPlugins(pluginTable, pluginNames);
        this.installSelectedPlugins(containerOp);
        this.closeDialog();
    }

    public void installDownloadedPlugins(String nbmPath) {
        ContainerOperator containerOp = this.waitTabEnabled(TAB_TITLE_DOWNLOADED_PLUGINS);
        new JButtonOperator(containerOp, BUTTON_LABEL_ADD_PLUGINS).pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
        this.addDownloadedPlugins(nbmPath, containerOp);
        JTableOperator pluginTable = new JTableOperator(containerOp);
        this.waitPluginsTableFilling(pluginTable);
        this.installSelectedPlugins(containerOp);
        this.closeDialog();
    }

    private ContainerOperator waitTabEnabled(String tabTitle) {
        int cursorType;
        for (int i = 0; i < 200 && (cursorType = this.tabbedPane.getCursor().getType()) == 3; ++i) {
            Util.wait(1000);
            new QueueTool().waitEmpty();
        }
        int tabIndex = this.findTab(tabTitle);
        if (tabIndex > -1) {
            this.tabbedPane.setSelectedIndex(tabIndex);
            ContainerOperator containerOp = new ContainerOperator((Container)this.tabbedPane.getComponentAt(tabIndex));
            Util.wait(500);
            new QueueTool().waitEmpty();
            return containerOp;
        }
        throw new RuntimeException("Tab with title [" + tabTitle + "] isn't found in the dialog [" + this.getTitle() + "]");
    }

    private int findTab(String tabTitle) {
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            String title = this.tabbedPane.getTitleAt(i);
            if (title.indexOf(tabTitle) <= -1) continue;
            return i;
        }
        return -1;
    }

    private int getColumnIndexByName(JTableOperator tableOp, String columnName) {
        int colCount = tableOp.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            String name = tableOp.getColumnName(i);
            if (name.indexOf(columnName) <= -1) continue;
            return i;
        }
        return -1;
    }

    private void fillAvailablePluginsTable(ContainerOperator containerOp, JTableOperator pluginTable) {
        int rowCount = pluginTable.getRowCount();
        if (rowCount == 0) {
            new JButtonOperator(containerOp, BUTTON_LABEL_RELOAD_CATALOG).pushNoBlock();
            Util.wait(500);
            new QueueTool().waitEmpty();
            this.waitPluginsTableFilling(pluginTable);
        }
    }

    private void waitPluginsTableFilling(JTableOperator pluginTable) {
        int rowCount;
        for (int i = 0; i < 200 && (rowCount = pluginTable.getRowCount()) < 1; ++i) {
            Util.wait(1000);
            new QueueTool().waitEmpty();
        }
    }

    private void selectPlugins(JTableOperator pluginTable, List<String> pluginNames) {
        int nameColumnIndex = this.getColumnIndexByName(pluginTable, COLUMN_TITLE_NAME);
        int installColumnIndex = this.getColumnIndexByName(pluginTable, "Install");
        int rowCount = pluginTable.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            Object cellValue = pluginTable.getValueAt(row, nameColumnIndex);
            if (!this.isPluginInList(pluginNames, cellValue.toString())) continue;
            int rowIndex = row;
            pluginTable.clickOnCell(rowIndex, installColumnIndex);
            Util.wait(500);
            new QueueTool().waitEmpty();
        }
    }

    private boolean isPluginInList(List<String> pluginNames, String checkedPluginName) {
        if (pluginNames.isEmpty()) {
            return true;
        }
        return pluginNames.contains(checkedPluginName);
    }

    private void addDownloadedPlugins(String nbmPath, ContainerOperator containerOp) {
        new JButtonOperator(containerOp, BUTTON_LABEL_ADD_PLUGINS).pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
        JFileChooserOperator fileChooserOp = new JFileChooserOperator();
        fileChooserOp.setSelectedFile(new File(nbmPath));
        Util.wait(500);
        new QueueTool().waitEmpty();
        fileChooserOp.approve();
        Util.wait(500);
        new QueueTool().waitEmpty();
    }

    private void installSelectedPlugins(ContainerOperator containerOp) {
        JButtonOperator btnInstall = new JButtonOperator(containerOp, "Install");
        if (!btnInstall.isEnabled()) {
            throw new RuntimeException("The button [Install] isn't enabled in the dialog [Plugins]");
        }
        btnInstall.pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
        this.workInstallerDialog();
    }

    private void workInstallerDialog() {
        JDialogOperator installerDialog = new JDialogOperator(DIALOG_TITLE_NETBEANS_IDE_INSTALLER);
        Util.wait(3000);
        new QueueTool().waitEmpty();
        String timeoutName = "ComponentOperator.WaitComponentTimeout";
        long previousTimeoutValue = JemmyProperties.getCurrentTimeout((String)timeoutName);
        long newTimeoutValue = 1000L;
        JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, newTimeoutValue);
        try {
            new JButtonOperator((ContainerOperator)installerDialog, BUTTON_LABEL_NEXT).pushNoBlock();
            Util.wait(1000);
            new QueueTool().waitEmpty();
            JRadioButtonOperator rbtLicenseAgreements = new JRadioButtonOperator((ContainerOperator)installerDialog, RADIO_BUTTON_LICENSE_AGREEMENT_ACCEPT_TEXT);
            Util.wait(500);
            new QueueTool().waitEmpty();
            rbtLicenseAgreements.setSelected(true);
            Util.wait(500);
            new QueueTool().waitEmpty();
            System.err.println();
            System.err.println("Method [setSelected()] has been invoked for the radio button [I accept]");
            System.err.println();
            rbtLicenseAgreements.doClick();
            Util.wait(500);
            new QueueTool().waitEmpty();
            System.err.println();
            System.err.println("Method [doClick()] has been invoked for the radio button [I accept]");
            System.err.println();
            Util.wait(500);
            new QueueTool().waitEmpty();
        }
        catch (TimeoutExpiredException tee) {
            tee.printStackTrace(System.out);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e);
        }
        finally {
            JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, previousTimeoutValue);
        }
        new JButtonOperator((ContainerOperator)installerDialog, "Install").pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
        this.waitInstallationFinish(installerDialog);
    }

    private void waitInstallationFinish(JDialogOperator dialogOp) {
        String timeoutName = "DialogWaiter.WaitDialogTimeout";
        long previousTimeoutValue = JemmyProperties.getCurrentTimeout((String)timeoutName);
        long newTimeoutValue = 1000L;
        JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, newTimeoutValue);
        JButtonOperator btnFinish = null;
        for (int i = 0; !(i >= 600 || (btnFinish = this.checkButtonFinishAppearance(dialogOp)) != null && btnFinish.isEnabled()); ++i) {
        }
        JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, previousTimeoutValue > 0L ? previousTimeoutValue : 60000L);
        if (btnFinish == null || !btnFinish.isEnabled()) {
            throw new RuntimeException("The button [Finish] is not found or disabled in the dialog [NetBeans IDE Installer]");
        }
        btnFinish.pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
    }

    private JButtonOperator checkButtonFinishAppearance(JDialogOperator dialogOp) {
        String timeoutName = "ComponentOperator.WaitComponentTimeout";
        long previousTimeoutValue = JemmyProperties.getCurrentTimeout((String)timeoutName);
        long newTimeoutValue = 1000L;
        JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, newTimeoutValue);
        JButtonOperator btnFinish = null;
        try {
            JButtonOperator jButtonOperator = btnFinish = new JButtonOperator((ContainerOperator)dialogOp, BUTTON_LABEL_FINISH);
            return jButtonOperator;
        }
        catch (TimeoutExpiredException tee) {
            Util.wait(500);
            new QueueTool().waitEmpty();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e);
        }
        finally {
            JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, previousTimeoutValue);
        }
        return null;
    }

    private void closeDialog() {
        this.btnClose.pushNoBlock();
        Util.wait(500);
        new QueueTool().waitEmpty();
    }

    /*
     * Loose catch block
     */
    public static void display() {
        String timeoutName = "DialogWaiter.WaitDialogTimeout";
        long previousTimeoutValue = JemmyProperties.getCurrentTimeout((String)timeoutName);
        long newTimeoutValue = 1500L;
        JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, newTimeoutValue);
        try {
            new JDialogOperator(DIALOG_TITLE_PLUGINS);
        }
        catch (TimeoutExpiredException tee) {
            Util.getMainMenu().pushMenuNoBlock(MAIN_MENU_ITEM_TOOLS_PLUGINS);
            Util.wait(1000);
            new QueueTool().waitEmpty();
            JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, previousTimeoutValue > 0L ? previousTimeoutValue : 60000L);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e);
            {
                catch (Throwable throwable) {
                    JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, previousTimeoutValue > 0L ? previousTimeoutValue : 60000L);
                    throw throwable;
                }
            }
        }
        JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, previousTimeoutValue > 0L ? previousTimeoutValue : 60000L);
    }

    public JTabbedPaneOperator checkTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPaneOperator((ContainerOperator)this);
        }
        return this.tabbedPane;
    }

    private JButtonOperator checkButtonClose() {
        if (this.btnClose == null) {
            this.btnClose = new JButtonOperator((ContainerOperator)this, BUTTON_LABEL_CLOSE);
        }
        return this.btnClose;
    }

    public void verify() {
        this.checkTabbedPane();
        this.checkButtonClose();
    }

    private void debugOutput(Object ... dataArray) {
        System.out.println();
        for (Object obj : dataArray) {
            System.out.println(obj.toString());
        }
        System.out.println();
    }

    private class DialogWatcher
    implements Runnable {
        private String dialogTitle;
        private String buttonLabel;
        private boolean stopWatch = true;
        private Thread watchThread = new Thread(this);

        public DialogWatcher(String dialogTitle, String buttonLabel) {
            this.dialogTitle = dialogTitle;
            this.buttonLabel = buttonLabel;
        }

        public void startWatch() {
            this.stopWatch = false;
            this.watchThread.start();
        }

        public void stopWatch() {
            this.stopWatch = true;
            do {
                Util.wait(500);
            } while (this.watchThread.isAlive());
            Util.wait(1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopWatch) {
                DialogWatcher dialogWatcher = this;
                synchronized (dialogWatcher) {
                    try {
                        this.wait(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        throw new RuntimeException(e);
                    }
                }
                JDialogOperator dialogOp = this.checkDialogAppearance();
                if (dialogOp == null) continue;
                new JButtonOperator((ContainerOperator)dialogOp, this.buttonLabel).pushNoBlock();
                Util.wait(500);
                new QueueTool().waitEmpty();
                this.stopWatch = true;
            }
            return;
        }

        private JDialogOperator checkDialogAppearance() {
            String timeoutName = "DialogWaiter.WaitDialogTimeout";
            long previousTimeoutValue = JemmyProperties.getCurrentTimeout((String)timeoutName);
            long newTimeoutValue = 1000L;
            JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, newTimeoutValue);
            try {
                JDialogOperator dialogOp;
                JDialogOperator jDialogOperator = dialogOp = new JDialogOperator(this.dialogTitle);
                return jDialogOperator;
            }
            catch (TimeoutExpiredException tee) {
                Util.wait(500);
                new QueueTool().waitEmpty();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                throw new RuntimeException(e);
            }
            finally {
                JemmyProperties.getCurrentTimeouts().setTimeout(timeoutName, previousTimeoutValue);
            }
            return null;
        }
    }
}

