/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.project;

import java.io.File;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.ProjectNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.model.project.JSFWebProject;
import org.netbeans.modules.visualweb.gravy.model.project.Project;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectDescriptor;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectFactory;

public class DefaultProjectFactory
extends ProjectFactory {
    private static final String bundle = "org.netbeans.modules.visualweb.gravy.model.project.Bundle";
    private static final String projectType = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectWizardBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectType"));
    private static final String projectCategory = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectWizardBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectCategory"));
    private static final String blueprintsStructure = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectWizardBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "JavaBluePrints"));
    private static final String jakartaStructure = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectWizardBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "Jakarta"));
    private static DefaultProjectFactory defaultPFactory;

    public static DefaultProjectFactory getFactory() {
        if (defaultPFactory != null) {
            return defaultPFactory;
        }
        defaultPFactory = new DefaultProjectFactory();
        return defaultPFactory;
    }

    protected Project createProject(ProjectDescriptor projectDescriptor) {
        String _projectPath = projectDescriptor.getProperty("projectLocation");
        String _projectName = projectDescriptor.getProperty("projectName");
        String _J2EEVersion = projectDescriptor.getProperty("J2EEVersion");
        String _targetServer = projectDescriptor.getProperty("targetServer");
        if (_projectPath.lastIndexOf(File.separator) != _projectPath.length() - 1) {
            _projectPath = _projectPath + File.separator;
        }
        try {
            TestUtils.createNewProject(_projectPath, _projectName, true, projectType, projectCategory, blueprintsStructure, _J2EEVersion, _targetServer);
        }
        catch (Exception e) {
            throw new JemmyException("Project can't be created!", (Throwable)e);
        }
        return new JSFWebProject(projectDescriptor);
    }

    protected Project openProject(String pathToProject) {
        try {
            TestUtils.openProject(pathToProject);
        }
        catch (Exception e) {
            throw new JemmyException("Project can't be opened!", (Throwable)e);
        }
        String projectName = pathToProject.substring(pathToProject.lastIndexOf(File.separator) + 1, pathToProject.length());
        String projectLocation = pathToProject.substring(0, pathToProject.lastIndexOf(File.separator) + 1);
        ProjectNavigatorOperator.pressPopupItemOnNode(projectName, "Properties");
        JDialogOperator propertiesDialog = new JDialogOperator("Project Properties - " + projectName);
        TestUtils.wait(1000);
        JTreeOperator tree = new JTreeOperator((ContainerOperator)propertiesDialog);
        tree.selectPath(tree.findPath("Run"));
        TestUtils.wait(1000);
        String targetServer = new JComboBoxOperator((ContainerOperator)propertiesDialog).getSelectedItem().toString();
        String J2EEVersion = new JTextFieldOperator((ContainerOperator)propertiesDialog, 0).getText();
        new JButtonOperator((ContainerOperator)propertiesDialog, "OK").pushNoBlock();
        TestUtils.wait(1000);
        System.out.println("projectName=" + projectName + "; projectLocation=" + projectLocation + "; J2EEVersion=" + J2EEVersion + "; targetServer=" + targetServer);
        ProjectDescriptor projectDescriptor = new ProjectDescriptor(projectName, projectLocation, J2EEVersion, targetServer);
        return new JSFWebProject(projectDescriptor);
    }
}

